/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.rel.Aggregation;
import com.kingdee.bos.olap.rel.CellRequest;
import com.kingdee.bos.olap.rel.CellRequestBatch;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMeasureImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.ValueNotReady;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RelCellReaderImpl
implements CellReader {
    static Logger logger = CommonLogger.getLogger(RelCellReaderImpl.class);
    private final Set pinnedSegments = new HashSet();
    private final Map batches = new HashMap();
    private int requestCount;

    public RelCellReaderImpl(RelCubeImpl cube) {
    }

    @Override
    public Object get(Evaluator evaluator) throws OLAPException {
        CellRequest request = RelCellReaderImpl.makeRequest(evaluator.getCurrentMembers());
        if (request == null) {
            return Util.nullValue;
        }
        Object o = this.getCellFromCache(request, this.pinnedSegments);
        if (o != null) {
            if (o == Util.nullValue) {
                return null;
            }
            return o;
        }
        this.recordCellRequest(request);
        return ValueNotReady.instance;
    }

    public Object getCellFromCache(CellRequest request, Set pinSet) {
        Star.Column measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().getAggregationManager().lookupAggregation(request.getColumns());
        return aggregation == null ? null : aggregation.get(measure, request.getSingleValues(), pinSet);
    }

    void recordCellRequest(CellRequest request) {
        ++this.requestCount;
        List key = request.getBatchKey();
        CellRequestBatch batch = (CellRequestBatch)this.batches.get(key);
        if (batch == null) {
            batch = new CellRequestBatch(request, this.pinnedSegments);
            this.batches.put(key, batch);
        }
        batch.add(request);
    }

    boolean isBatchEmpty() {
        return this.batches.isEmpty();
    }

    boolean loadAggregations() throws OLAPException {
        this.requestCount = 0;
        if (this.isBatchEmpty()) {
            return false;
        }
        Iterator it = this.batches.values().iterator();
        while (it.hasNext()) {
            ((CellRequestBatch)it.next()).loadAggregation();
        }
        this.batches.clear();
        return true;
    }

    public static CellRequest makeRequest(Member[] members) throws OLAPException {
        Member o = members[members.length - 1];
        if (!(o instanceof RelMeasureImpl)) {
            return null;
        }
        RelMeasureImpl measure = (RelMeasureImpl)o;
        Star.Measure starMeasure = (Star.Measure)measure.getStarMeasure();
        Star star = starMeasure.getStar();
        CellRequest request = new CellRequest(starMeasure);
        Map mapLevelToColumn = star.getMapLevelToColumn();
        block0: for (int i = 0; i < members.length - 1; ++i) {
            Member member = members[i];
            Hierarchy hierarchy = member.getHierarchy();
            boolean isPCNotAgg = hierarchy.getDimension().isParentChildrenDimension() && !hierarchy.isAggregate();
            for (Member m = member; m != null; m = m.getParentMember()) {
                Star.Column column;
                RelMemberImpl rm = (RelMemberImpl)m;
                if (rm.getKey() == null) {
                    if (m == hierarchy.getNullMember()) {
                        return null;
                    }
                    if (m.isAll() || m.isInner()) continue;
                    throw new OLAPException("todo.");
                }
                RelLevelImpl level = (RelLevelImpl)m.getLevel();
                if (isPCNotAgg) {
                    level = RelUtil.getDefineLevel(level.hie);
                }
                if ((column = (Star.Column)mapLevelToColumn.get(level)) == null) {
                    return null;
                }
                request.addConstrainedColumn(column, (RelMemberImpl)m);
                if (isPCNotAgg) continue block0;
            }
        }
        return request;
    }
}

