/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.olap.mdx.type.DimensionType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.util.Util;

public class RelDimensionImpl
extends OLAPElementBase
implements Dimension {
    RelSchemaImpl schema;
    RelCubeImpl cube;
    byte dimensionType;
    RelHierarchyImpl[] hies;
    private transient String uniqueName;

    RelDimensionImpl() {
    }

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hies;
    }

    @Override
    public Hierarchy getHierarchy(String name) {
        for (int i = 0; i < this.hies.length; ++i) {
            if (name == null || !name.equalsIgnoreCase(this.hies[i].getSubName())) continue;
            return this.hies[i];
        }
        return null;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        Hierarchy hie = this.getHierarchy(name);
        if (hie != null) {
            return hie;
        }
        return this.getDefaultHierarchy().lookupChild(schemaReader, name);
    }

    @Override
    public Hierarchy getDefaultHierarchy() {
        if (this.hies == null || this.hies.length == 0) {
            return null;
        }
        return this.hies[0];
    }

    @Override
    public byte getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getOrdinal(Cube cube) throws OLAPException {
        return cube.getDimensionOrdinal(this.getName());
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = Util.makeFqName(this.getName());
        }
        return this.uniqueName;
    }

    public Type getExpType() {
        return new DimensionType(this);
    }

    public int getCategory() {
        return 2;
    }

    @Override
    public boolean isMeasureDimension() {
        return this.dimensionType == -1;
    }

    @Override
    public boolean isTimeDimension() {
        return this.dimensionType == 1;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getDefaultHierarchy();
    }

    @Override
    public Dimension getDimension() {
        return this;
    }

    public String getTable() {
        return (String)this.getProperty("table");
    }

    public boolean addToSqlQuery(SqlQuery sqlQuery) throws OLAPException {
        TableDef tableDef = RelUtil.lookupOrCreateTableDef(this.schema, this.getTable());
        return sqlQuery.addFrom(tableDef);
    }

    @Override
    public boolean isParentChildrenDimension() {
        return this.hies[0].def.levels[0].parentColumn != null;
    }

    @Override
    public String getCaption() {
        if (this.caption != null && !this.caption.equals("")) {
            return this.caption;
        }
        if (this.isMeasureDimension()) {
            return OLAPEngine.getResource(this.schema.conn.getLocale(), "measureDimensionCaption");
        }
        return super.getCaption();
    }

    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantDimension(this);
    }
}

