/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.base.Field;
import com.kingdee.bos.olap.base.MemberTreeNode;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class RelLevelFetch {
    Field field;
    Field[] propFields = new Field[0];
    PropertyDef[] props = new PropertyDef[0];
    String[] propDataTypes = new String[0];
    String dataType;
    String closureDataType;
    RelLevelImpl level;
    LevelDef def;
    Field childField = null;
    Field parentField = null;
    Field orderByField = null;
    boolean hasName = false;
    HashMap[] propValueMaps;

    RelLevelFetch(RelLevelImpl _level, LevelDef _def) {
        this.def = _def;
        this.level = _level;
        this.field = new Field(this.def.column);
        this.field.type = this.level.levelType;
        if (this.def.parentColumn != null) {
            this.parentField = new Field(this.def.parentColumn);
        }
        if (this.def.childColumn != null) {
            this.childField = new Field(this.def.childColumn);
        }
        if (this.def.properties != null) {
            this.props = this.def.properties;
            this.propFields = new Field[this.props.length];
            this.propValueMaps = new HashMap[this.props.length];
            this.propDataTypes = new String[this.props.length];
            for (int i = 0; i < this.propFields.length; ++i) {
                this.propFields[i] = new Field(this.props[i].column);
                this.propDataTypes[i] = this.props[i].dataType;
                if (this.props[i].name.equals("name")) {
                    this.hasName = true;
                }
                if (this.props[i].name.equals("name") || this.props[i].name.equals("caption")) continue;
                this.propValueMaps[i] = new HashMap();
            }
        }
        if (this.def.orderBy != null) {
            this.orderByField = new Field(this.def.orderBy);
        }
    }

    MemberTreeNode fetch(MemberTreeNode parent, ResultSet rs) throws SQLException {
        MemberTreeNode item;
        Object key = this.field.getValue(rs);
        if (this.dataType == null) {
            this.dataType = Util.decideDataType(key);
        }
        Object childKey = key;
        if (this.childField != null) {
            childKey = this.childField.getValue(rs);
        }
        if (parent.children == null) {
            parent.children = new HashMap();
        }
        if ((item = (MemberTreeNode)parent.children.get(childKey)) == null) {
            RelMemberImpl member = new RelMemberImpl((RelMemberImpl)parent.member);
            member.level = this.level;
            member.memberType = 1;
            member.setKey(key);
            for (int i = 0; i < this.props.length; ++i) {
                Object value = this.propFields[i].getValue(rs);
                if (value == null) continue;
                if (this.propValueMaps[i] != null) {
                    Object value2 = this.propValueMaps[i].get(value);
                    if (value2 == null) {
                        this.propValueMaps[i].put(value, value);
                    } else {
                        value = value2;
                    }
                }
                member.setProperty(this.props[i].name, value);
                if (this.propDataTypes[i] != null) continue;
                this.propDataTypes[i] = Util.decideDataType(value);
            }
            if (this.orderByField != null) {
                Object value = this.orderByField.getValue(rs);
                member.setProperty("orderBy", value);
            }
            item = new MemberTreeNode();
            item.member = member;
            if (this.parentField != null) {
                item.childValue = childKey;
                item.parentValue = this.parentField.getValue(rs);
                if (this.closureDataType == null) {
                    this.closureDataType = Util.decideDataType(item.parentValue);
                }
            }
            item.levelDef = this.def;
            parent.children.put(childKey, item);
        }
        return item;
    }

    public void finish() {
        this.level.setProperty("dataType", this.dataType);
        this.level.setProperty("closureDataType", this.closureDataType);
        if (this.level.props == null) {
            return;
        }
        for (int i = 0; i < this.level.props.length; ++i) {
            this.level.props[i].setProperty("dataType", this.propDataTypes[i]);
        }
    }
}

