/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Property;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.LevelType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.impl.PropertyImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.Iterator;

public class RelLevelImpl
extends OLAPElementBase
implements Level {
    private static final long serialVersionUID = -3071051630764472489L;
    LevelDef def;
    RelHierarchyImpl hie;
    byte levelType = 0;
    RelLevelImpl parent;
    RelLevelImpl child;
    byte depth;
    PropertyImpl[] props;
    private transient String uniqueName;

    public RelLevelImpl(LevelDef def) {
        this.def = def;
    }

    @Override
    public Property[] getMemberProperties() {
        return this.props;
    }

    @Override
    public Level getChildLevel() {
        return this.child;
    }

    @Override
    public Level getParentLevel() {
        return this.parent;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hie;
    }

    @Override
    public byte getDepth() {
        return this.depth;
    }

    @Override
    public byte getLevelType() {
        return this.levelType;
    }

    public Type getExpType() {
        return new LevelType(this.hie, this);
    }

    public int getCategory() {
        return 4;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        IMemberList levelMembers = schemaReader.getLevelMembers(this);
        Iterator iter = levelMembers.iterator();
        while (iter.hasNext()) {
            RelMemberImpl m = (RelMemberImpl)iter.next();
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = Util.makeFqName(this.hie, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isAll() {
        return this.levelType == -1;
    }

    @Override
    public boolean isMeasures() {
        return this.levelType == -2;
    }

    @Override
    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            if (this.isAll()) {
                return "All";
            }
            if (this.isMeasures()) {
                return "MeasuresLevel";
            }
            return "Level #" + (this.depth + 1);
        }
        return name;
    }

    RelLevelImpl createChildLevel() {
        if (this.child == null) {
            this.child = new RelLevelImpl(null);
            this.child.hie = this.hie;
            this.child.levelType = this.levelType;
            this.child.def = this.def;
            this.child.depth = (byte)(this.depth + 1);
            this.child.props = this.props;
            this.child.parent = this;
            this.child.name = "Level #" + (this.depth + 1);
            if (this.child.hie.depth < this.depth + 1) {
                this.child.hie.depth = this.depth + 1;
            }
        }
        return this.child;
    }

    public boolean isParentChildren() {
        return this.hie.dim.isParentChildrenDimension();
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public LevelDef getLevelDef() {
        return this.def;
    }
}

