/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelCalculatedMemberImpl;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.Iterator;

public class RelSchemaReaderImpl
implements SchemaReader {
    RelSchemaImpl schema;

    public RelSchemaReaderImpl(RelSchemaImpl schema) {
        this.schema = schema;
    }

    @Override
    public Cube[] getCubes() {
        return this.schema.getCubes();
    }

    @Override
    public Cube getCube(String name) {
        return this.schema.getCube(Util.trimBracketsAround(name));
    }

    public void init() throws OLAPException {
        this.initMemberReader();
    }

    private void initMemberReader() throws OLAPException {
        for (int i = 0; i < this.schema.cubes.length; ++i) {
            Dimension[] dims = this.schema.cubes[i].getDimensions();
            for (int j = 0; j < dims.length; ++j) {
                ((RelHierarchyImpl)dims[j].getDefaultHierarchy()).getMemberReader();
            }
        }
    }

    MemberReader getMemberReader(Hierarchy hierarchy) throws OLAPException {
        return ((RelHierarchyImpl)hierarchy).getMemberReader();
    }

    @Override
    public OLAPElement getElementChild(OLAPElement parent, String name) throws OLAPException {
        return parent.lookupChild(this, name);
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        return hierarchy.getDefaultMember();
    }

    @Override
    public IMemberList getHierarchyRootMembers(Hierarchy hierarchy) throws OLAPException {
        return this.getLevelMembers(hierarchy.getLevels()[0]);
    }

    @Override
    public Member getLeadMember(Member member, int n) throws OLAPException {
        return this.getMemberReader(member.getHierarchy()).getLeadMember((RelMemberImpl)member, n);
    }

    @Override
    public IMemberList getLevelMembers(Level level) throws OLAPException {
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        return memberReader.getMembersInLevel((RelLevelImpl)level);
    }

    @Override
    public int getMemberCount(Hierarchy hierarchy) throws OLAPException {
        MemberReader memberReader = this.getMemberReader(hierarchy);
        return memberReader.getMemberCount();
    }

    @Override
    public int getLevelMemberCount(Level level) throws OLAPException {
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        return memberReader.getLevelMemberCount((RelLevelImpl)level);
    }

    @Override
    public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OLAPException {
        String[] nameParts = Util.explode(uniqueName);
        Member member = (Member)this.lookupCompound(cube, nameParts, 6);
        return member;
    }

    @Override
    public IMemberList getMemberChildren(Member member) throws OLAPException {
        IMemberList children = DefaultListFactory.instance.createMemberList();
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberChildren((RelMemberImpl)member, children);
        return children;
    }

    @Override
    public IMemberList getMemberChildren(IMemberList members) throws OLAPException {
        if (members.isEmpty()) {
            return IMemberList.EMPTY;
        }
        IMemberList children = DefaultListFactory.instance.createMemberList();
        Hierarchy hierarchy = ((Member)members.getFirst()).getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            RelMemberImpl m = (RelMemberImpl)iter.next();
            memberReader.getMemberChildren(m, children);
        }
        return children;
    }

    @Override
    public void getMemberDescendants(Member member, IMemberList result, Level level, boolean before, boolean self, boolean after) throws OLAPException {
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberDescendants((RelMemberImpl)member, result, (RelLevelImpl)level, before, self, after);
    }

    @Override
    public int getMemberDepth(Member member) {
        return member.getDepth();
    }

    @Override
    public Member getMemberParent(Member member) {
        return member.getParentMember();
    }

    @Override
    public void getMemberRange(Level level, Member startMember, Member endMember, IMemberList list) throws OLAPException {
        this.getMemberReader(level.getHierarchy()).getMemberRange((RelLevelImpl)level, (RelMemberImpl)startMember, (RelMemberImpl)endMember, list);
    }

    @Override
    public OLAPElement lookupCompound(OLAPElement parent, String[] names, int category) throws OLAPException {
        return SchemaLookup.lookupCompound(this, parent, names, category);
    }

    @Override
    public Member getCalculatedMember(Cube cube, String uniqueName) {
        RelCubeImpl cubeX = (RelCubeImpl)cube;
        RelCalculatedMemberImpl[] members = cubeX.calculatedMembers;
        if (members != null && members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                if (!uniqueName.equalsIgnoreCase(members[i].getUniqueName())) continue;
                return members[i];
            }
        }
        return null;
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
        RelCubeImpl cubeX = (RelCubeImpl)cube;
        RelCalculatedMemberImpl[] members = cubeX.calculatedMembers;
        ArrayList<RelCalculatedMemberImpl> jlist = new ArrayList<RelCalculatedMemberImpl>();
        if (members != null && members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getHierarchy().equals(hierarchy)) continue;
                jlist.add(members[i]);
            }
        }
        return jlist.toArray(new Member[0]);
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube) {
        RelCubeImpl cubeX = (RelCubeImpl)cube;
        return cubeX.calculatedMembers;
    }

    @Override
    public boolean isDrillable(Member member) {
        return !member.isLeaf();
    }

    @Override
    public IMemberList getHierarchyMembers(Hierarchy hierarchy, boolean hierarchize) throws OLAPException {
        MemberReader memberReader = this.getMemberReader(hierarchy);
        IMemberList list = hierarchize ? memberReader.getHierarchizeMembers() : memberReader.getMembers();
        return list;
    }
}

