/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.rel.DBType;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.SiblingIterator;
import com.kingdee.bos.olap.rel.dialect.DatabaseMetaUtil;
import com.kingdee.bos.olap.util.Util;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RelUtil
extends Util {
    private static Logger logger = CommonLogger.getLogger(RelUtil.class);
    public static int MAX_AGGREGATION_PASS_COUNT = 10;
    public static int RESULT_MAX_ROWCOUNT = 50000;
    public static int RESULT_MAX_COLUMNCOUNT = 1000;

    public static ResultSet executeQuery(Connection jdbcConnection, String sql, String component) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        logger.debug((Object)(component + ": executing sql ::" + sql));
        statement = jdbcConnection.createStatement();
        resultSet = statement.executeQuery(sql);
        return resultSet;
    }

    public static ResultSet executeQueryWithParam(Connection jdbcConnection, String sql, Object[] values, String component) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        logger.debug((Object)(component + ": executing sql ::" + sql + " with params:" + Util.toString(values)));
        statement = jdbcConnection.prepareStatement(sql);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof String) {
                statement.setString(i + 1, (String)values[i]);
                continue;
            }
            statement.setObject(i + 1, values[i]);
        }
        resultSet = statement.executeQuery();
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(Connection jdbcConnection, String sql, String component) throws SQLException {
        Statement statement = null;
        logger.debug((Object)(component + ": executing sql ::" + sql));
        statement = jdbcConnection.createStatement();
        try {
            int i;
            int n = i = statement.executeUpdate(sql);
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static int compare(MemberReader memberReader, RelMemberImpl m1, RelMemberImpl m2, boolean siblingsAreEqual) throws OLAPException {
        byte levelDepth2;
        if (m1 == null && m2 == null) {
            return 0;
        }
        if (m1 != null && m1.equals(m2)) {
            return 0;
        }
        if (m1.getParentMember() != null && m1.getParentMember().equals(m2.getParentMember())) {
            if (siblingsAreEqual) {
                return 0;
            }
            if (m1.getParentMember() == null) {
                if (m1.ordinal > m2.ordinal) {
                    return 1;
                }
                return -1;
            }
            IMemberList children = DefaultListFactory.instance.createMemberList();
            memberReader.getMemberChildren((RelMemberImpl)m1.getParentMember(), children);
            int pos1 = -1;
            int pos2 = -1;
            int index = 0;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                RelMemberImpl child = (RelMemberImpl)iter.next();
                if (child.equals(m1)) {
                    pos1 = index;
                }
                if (child.equals(m2)) {
                    pos2 = index;
                }
                ++index;
            }
            if (pos1 == -1) {
                throw new OLAPException(m1 + " not found among siblings");
            }
            if (pos2 == -1) {
                throw new OLAPException(m2 + " not found among siblings");
            }
            Util.assertTrue(pos1 != pos2);
            return pos1 < pos2 ? -1 : 1;
        }
        byte levelDepth1 = m1.getLevel().getDepth();
        if (levelDepth1 < (levelDepth2 = m2.getLevel().getDepth())) {
            int c = RelUtil.compare(memberReader, m1, (RelMemberImpl)m2.getParentMember(), false);
            return c == 0 ? -1 : c;
        }
        if (levelDepth1 > levelDepth2) {
            int c = RelUtil.compare(memberReader, (RelMemberImpl)m1.getParentMember(), m2, false);
            return c == 0 ? 1 : c;
        }
        return RelUtil.compare(memberReader, (RelMemberImpl)m1.getParentMember(), (RelMemberImpl)m2.getParentMember(), false);
    }

    static void getMemberRange(MemberReader memberReader, RelLevelImpl level, RelMemberImpl startMember, RelMemberImpl endMember, IMemberList list) throws OLAPException {
        if (RelUtil.compare(memberReader, startMember, endMember, false) > 0) {
            return;
        }
        list.add(startMember);
        if (startMember.equals(endMember)) {
            return;
        }
        SiblingIterator siblings = new SiblingIterator(memberReader, startMember);
        while (siblings.hasNext()) {
            RelMemberImpl member = siblings.nextMember();
            list.add(member);
            if (!member.equals(endMember)) continue;
            return;
        }
    }

    public static void getMemberDescendants(MemberReader memberReader, RelMemberImpl ancestor, RelLevelImpl level, IMemberList result, boolean before, boolean self, boolean after) throws OLAPException {
        byte levelDepth = level.getDepth();
        IMemberList members = memberReader.getListFactory().createMemberList();
        members.add(ancestor);
        IMemberList fertileMembers = null;
        do {
            fertileMembers = memberReader.getListFactory().createMemberList();
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                RelMemberImpl member = (RelMemberImpl)iter.next();
                byte currentDepth = member.getLevel().getDepth();
                if (currentDepth == levelDepth) {
                    if (self) {
                        result.add(member);
                    }
                    if (!after) continue;
                    fertileMembers.add(member);
                    continue;
                }
                if (currentDepth < levelDepth) {
                    if (before) {
                        result.add(member);
                    }
                    fertileMembers.add(member);
                    continue;
                }
                if (!after) continue;
                result.add(member);
                fertileMembers.add(member);
            }
            members = memberReader.getListFactory().createMemberList();
            memberReader.getMemberChildren(fertileMembers, members);
        } while (members.size() > 0);
    }

    static RelMemberImpl getLeadMember(MemberReader memberReader, RelMemberImpl member, int n) throws OLAPException {
        if (n == 0 || member.isNull()) {
            return member;
        }
        if (member.isInner()) {
            return (RelMemberImpl)member.getHierarchy().getNullMember();
        }
        SiblingIterator iter = new SiblingIterator(memberReader, member);
        if (n > 0) {
            RelMemberImpl sibling = null;
            while (n-- > 0) {
                if (!iter.hasNext()) {
                    return (RelMemberImpl)member.getHierarchy().getNullMember();
                }
                sibling = iter.nextMember();
            }
            return sibling;
        }
        n = -n;
        RelMemberImpl sibling = null;
        while (n-- > 0) {
            if (!iter.hasPrevious()) {
                return (RelMemberImpl)member.getHierarchy().getNullMember();
            }
            sibling = iter.previousMember();
        }
        return sibling;
    }

    static final RelMemberImpl[] toArray(IMemberList v) {
        if (v.isEmpty()) {
            return new RelMemberImpl[0];
        }
        RelMemberImpl[] ms = new RelMemberImpl[v.size()];
        int i = 0;
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            ms[i++] = (RelMemberImpl)iter.next();
        }
        return ms;
    }

    static RelMemberImpl lookupMember(MemberReader reader, String[] uniqueNameParts) throws OLAPException {
        RelMemberImpl member = null;
        for (int i = 0; i < uniqueNameParts.length; ++i) {
            IMemberList children;
            String name = uniqueNameParts[i];
            if (member == null) {
                children = reader.getRootMembers();
            } else {
                children = reader.getListFactory().createMemberList();
                reader.getMemberChildren(member, children);
                member = null;
            }
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                RelMemberImpl child = (RelMemberImpl)iter.next();
                if (child.isMeasure()) {
                    if (!child.getName().equalsIgnoreCase(name)) continue;
                    member = child;
                    break;
                }
                if (!child.getName().equals(name)) continue;
                member = child;
                break;
            }
            if (member == null) break;
        }
        return member;
    }

    public static TableDef lookupOrCreateTableDef(RelSchemaImpl schema, String table) {
        TableDef td = schema.conn.getTableDef(table);
        if (td != null) {
            return td;
        }
        return new TableDef(table);
    }

    public static String getSqlType(DBType dbType, ResultSetMetaData rsmd, int index) throws SQLException {
        int type = rsmd.getColumnType(index);
        int precision = rsmd.getPrecision(index);
        int scale = rsmd.getScale(index);
        return DatabaseMetaUtil.getColumnDefine(dbType, type, precision, scale);
    }

    public static RelLevelImpl getDefineLevel(RelHierarchyImpl hie) {
        RelLevelImpl[] levels = (RelLevelImpl[])hie.getLevels();
        RelLevelImpl level = hie.hasAll() ? levels[1] : levels[0];
        return level;
    }

    public static String genLevelColumnName(int depth) {
        return "Olap_Level_" + depth;
    }

    public static String getKeyColumnName() {
        return "Olap_Key";
    }

    public static String getIsLeafColumnName() {
        return "Olap_isleaf";
    }

    public static String getDepthColumnName() {
        return "Olap_depth";
    }

    public static String getLevelNameColumn(RelLevelImpl level) {
        return RelUtil.getLevelNameColumn(level.def);
    }

    public static String getLevelNameColumn(LevelDef def) {
        if (def.properties == null) {
            return null;
        }
        for (int i = 0; i < def.properties.length; ++i) {
            if (!def.properties[i].name.equalsIgnoreCase("name")) continue;
            return def.properties[i].column;
        }
        return null;
    }

    public static void setValue(int index, Object value, PreparedStatement ps, int sqlType) throws SQLException {
        if (value == null || value instanceof String && ((String)value).length() == 0) {
            if (sqlType == 2005) {
                ps.setString(index, null);
                return;
            }
            if (sqlType == 2004) {
                ps.setBytes(index, null);
                return;
            }
            if (value == null) {
                ps.setNull(index, sqlType);
            } else {
                ps.setString(index, "");
            }
            return;
        }
        switch (sqlType) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                ps.setString(index, (String)value);
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(index, (BigDecimal)value);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                ps.setInt(index, ((Number)value).intValue());
                break;
            }
            case -5: {
                ps.setLong(index, ((Number)value).longValue());
                break;
            }
            case 8: {
                ps.setDouble(index, ((Number)value).doubleValue());
                break;
            }
            case 6: {
                ps.setFloat(index, ((Number)value).floatValue());
                break;
            }
            case 16: {
                ps.setBoolean(index, (Boolean)value);
            }
            case 91: {
                ps.setDate(index, (Date)value);
                break;
            }
            case 92: {
                ps.setTime(index, (Time)value);
                break;
            }
            case 93: {
                ps.setTimestamp(index, (Timestamp)value);
                break;
            }
            default: {
                throw new RuntimeException("unsupport sql type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectInto(RelConnectionImpl olapConn, Connection jdbcConn, String sql, String tableName) throws SQLException, OLAPException {
        ResultSet rs = null;
        Statement ps = null;
        try {
            int i;
            rs = RelUtil.executeQuery(jdbcConn, sql, "");
            ResultSetMetaData rsmd = rs.getMetaData();
            String[] columnNames = new String[rsmd.getColumnCount()];
            int[] columnTypes = new int[columnNames.length];
            String[] columnTypeNames = new String[columnNames.length];
            StringBuffer create = new StringBuffer("create table  ").append(tableName).append("(");
            for (int i2 = 0; i2 < columnNames.length; ++i2) {
                String columnName = rsmd.getColumnName(i2 + 1);
                int type = rsmd.getColumnType(i2 + 1);
                int precision = rsmd.getPrecision(i2 + 1);
                int scale = rsmd.getScale(i2 + 1);
                columnNames[i2] = columnName;
                columnTypes[i2] = type;
                columnTypeNames[i2] = DatabaseMetaUtil.getColumnDefine(olapConn.dbType, type, precision, scale);
                if (i2 > 0) {
                    create.append(",");
                }
                create.append(columnNames[i2]).append(" ").append(columnTypeNames[i2]);
            }
            create.append(")");
            olapConn.createTempTable(create.toString());
            StringBuffer insert = new StringBuffer("insert into ").append(tableName).append(" values(");
            for (i = 0; i < columnTypes.length; ++i) {
                insert.append("?");
                if (i >= columnTypes.length - 1) continue;
                insert.append(",");
            }
            insert.append(")");
            ps = jdbcConn.prepareStatement(insert.toString());
            while (rs.next()) {
                for (i = 0; i < columnTypes.length; ++i) {
                    RelUtil.setValue(i + 1, rs.getObject(i + 1), (PreparedStatement)ps, columnTypes[i]);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static String prixTableName(String tableName) {
        return "T_" + tableName;
    }
}

