/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.util.Util;

class SiblingIterator {
    private final MemberReader reader;
    private final SiblingIterator parentIterator;
    private RelMemberImpl[] siblings;
    private int position;

    SiblingIterator(MemberReader reader, RelMemberImpl member) throws OLAPException {
        IMemberList siblingList;
        this.reader = reader;
        RelMemberImpl parent = (RelMemberImpl)member.getParentMember();
        if (parent == null) {
            siblingList = reader.getRootMembers();
            this.parentIterator = null;
        } else {
            siblingList = reader.getListFactory().createMemberList();
            reader.getMemberChildren(parent, siblingList);
            this.parentIterator = new SiblingIterator(reader, parent);
        }
        this.siblings = RelUtil.toArray(siblingList);
        this.position = -1;
        for (int i = 0; i < this.siblings.length; ++i) {
            if (!this.siblings[i].equals(member)) continue;
            this.position = i;
            break;
        }
        if (this.position == -1) {
            throw new OLAPException("member " + member + " not found among its siblings");
        }
    }

    boolean hasNext() {
        return this.position < this.siblings.length - 1 || this.parentIterator != null && this.parentIterator.hasNext();
    }

    Object next() throws OLAPException {
        return this.nextMember();
    }

    RelMemberImpl nextMember() throws OLAPException {
        if (++this.position >= this.siblings.length) {
            if (this.parentIterator == null) {
                throw Util.newInternal("there is no next member");
            }
            RelMemberImpl parent = this.parentIterator.nextMember();
            IMemberList siblingList = DefaultListFactory.instance.createMemberList();
            this.reader.getMemberChildren(parent, siblingList);
            this.siblings = RelUtil.toArray(siblingList);
            this.position = 0;
        }
        return this.siblings[this.position];
    }

    boolean hasPrevious() {
        return this.position > 0 || this.parentIterator != null && this.parentIterator.hasPrevious();
    }

    Object previous() throws OLAPException {
        return this.previousMember();
    }

    RelMemberImpl previousMember() throws OLAPException {
        if (--this.position < 0) {
            if (this.parentIterator == null) {
                throw Util.newInternal("there is no next member");
            }
            RelMemberImpl parent = this.parentIterator.previousMember();
            IMemberList siblingList = DefaultListFactory.instance.createMemberList();
            this.reader.getMemberChildren(parent, siblingList);
            this.siblings = RelUtil.toArray(siblingList);
            this.position = this.siblings.length - 1;
        }
        return this.siblings[this.position];
    }
}

