/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.print.config.IConfigUI;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.AbstractDialog;
import com.kingdee.bos.ctrl.print.config.ui.FixedLayout;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;

public class PageDialog
extends AbstractDialog {
    private static final long serialVersionUID = 8147273532238062889L;
    private PrintJobConfig manager;
    private Map panelCache = new HashMap();
    private String title;
    private KDPanel leftTree;
    private KDPanel rightPane;

    public PageDialog(PrintJobConfig manager, Frame owner, boolean isPreviewing) {
        super(owner, true);
        this.setPreviewing(isPreviewing);
        this.initDialog(manager);
        this.setLocationRelativeTo(owner);
    }

    public PageDialog(PrintJobConfig manager, Dialog owner, boolean isPreviewing) {
        super(owner, true);
        this.setPreviewing(isPreviewing);
        this.initDialog(manager);
        this.setLocationRelativeTo(owner);
    }

    private void initDialog(PrintJobConfig manager) {
        this.manager = manager;
        this.title = Resources.getMsg("dialog.pagetitle");
        this.setTitle(this.title);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(null);
        KDTree onfigTree = this.initLeftPane(this.manager.getConfigPanes());
        this.rightPane = new KDPanel((LayoutManager)FixedLayout.ONE());
        KDPanel separater = new KDPanel((LayoutManager)FixedLayout.ONE());
        separater.setBorder(BorderFactory.createEtchedBorder());
        JPanel applyPanel = this.initApplyPane();
        cp.add((Component)this.leftTree);
        cp.add((Component)this.rightPane);
        cp.add((Component)separater);
        cp.add(applyPanel);
        int x = 5;
        int y = 5;
        int w = 143;
        int h = 309;
        this.leftTree.setBounds(x, y, w, 309);
        x = x + w + 5;
        w = 410;
        this.rightPane.setBounds(x, y, w, h);
        y = y + h + 5;
        separater.setBounds(-2, y, 570, 2);
        h = applyPanel.getPreferredSize().height;
        applyPanel.setBounds(0, y + 2 + 5, 568, h);
        cp.setPreferredSize(new Dimension(568, 350));
        this.setResizable(false);
        this.pack();
        onfigTree.setSelectionRow(1);
    }

    private KDTree initLeftPane(Map configPanes) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)Resources.getMsg("tree.root"));
        for (String name : configPanes.keySet()) {
            PrintJobConfig.OneConfigPage page = (PrintJobConfig.OneConfigPage)configPanes.get(name);
            if (!page.isVisible()) continue;
            root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)name));
        }
        KDTree configTree = new KDTree((ITreeNode)root);
        configTree.setShowCheckBox(false);
        configTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                String name = e.getPath().getLastPathComponent().toString();
                if (e.getPath().getPathCount() == 1) {
                    return;
                }
                PageDialog.this.onSelect(name);
            }
        });
        KDTreeView view = new KDTreeView(configTree);
        view.setShowControlPanel(false);
        view.setPreferredSize(new Dimension(143, 309));
        this.leftTree = new KDPanel((LayoutManager)FixedLayout.ONE());
        this.leftTree.add((Component)view);
        return configTree;
    }

    private void onSelect(String name) {
        JPanel panel = (JPanel)this.panelCache.get(name);
        if (panel == null) {
            panel = this.createPanelByName(name);
            this.panelCache.put(name, panel);
            ((IConfigUI)((Object)panel)).setPanelCache(this.panelCache);
        }
        this.showPanel(panel);
    }

    @Override
    protected void approve() {
        for (IConfigUI configUI : this.panelCache.values()) {
            configUI.approve();
        }
        super.approve();
        this.dispose();
    }

    @Override
    protected void preview() {
        this.approve();
        super.preview();
    }

    private JPanel createPanelByName(String name) {
        JPanel panel = this.manager.createPanelByName(name);
        IConfigUI configUI = (IConfigUI)((Object)panel);
        configUI.setPreviewing(this.isPreviewing());
        configUI.init(this.manager, name);
        configUI.updateConfigToUI();
        return panel;
    }

    private void showPanel(JPanel panel) {
        ((IConfigUI)((Object)panel)).onShow();
        this.rightPane.removeAll();
        this.rightPane.add((Component)panel);
        this.rightPane.validate();
        this.rightPane.repaint();
    }
}

