/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Html;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class HtmlExport
extends AbstractExport {
    String imageDirectionName;
    Map imagesMap = null;

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        this.imagesMap = new HashMap();
        Page page = paper.getBody();
        String des = fileNamePre;
        File tempFile = new File(fileNamePre);
        this.imageDirectionName = tempFile.getName() + "_files";
        des = des + index + ".html";
        File destFile = new File(des);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(destFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UNICODE");
            this.exportToWriter(page, writer);
            ((Writer)writer).close();
            this.saveImages(destFile.getParentFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(destFile + " FileNotFoundException error:" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("UnsupportedEncodingException error:" + e1.getMessage(), e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException error:" + e2.getMessage(), e2);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void saveImages(File direction) {
        int iamgeSize = this.imagesMap.size();
        if (iamgeSize == 0) {
            return;
        }
        File imageDirect = new File(direction.getAbsolutePath() + File.separator + this.imageDirectionName + File.separator);
        if (!imageDirect.exists()) {
            imageDirect.mkdir();
        }
        for (Object key : this.imagesMap.keySet()) {
            Image image = (Image)this.imagesMap.get(key);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(imageDirect.getAbsolutePath() + File.separator + key + ".jpg");
                BufferedImage bimg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics gc = bimg.getGraphics();
                gc.drawImage(image, 0, 0, null);
                ImageIO.write((RenderedImage)bimg, "jpeg", fos);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("FileNotFoundException error:" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException error:" + e.getMessage(), e);
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void exportToWriter(Page page, Writer writer) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<html\n");
        sb.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        sb.append("<head>\n<meta http-equiv=Content-Type content=\"text/html; charset=utf-8\"></head>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        String bodyContent = this.exportToString(page);
        sb.append(bodyContent);
        sb.append("</body>\n");
        sb.append("</html>\n");
        writer.write(sb.toString());
        writer.flush();
    }

    private String exportToString(Page page) {
        if (page != null) {
            Painter2Html p2Html = new Painter2Html();
            return p2Html.makePage(page, this.imagesMap, this.imageDirectionName);
        }
        return null;
    }
}

