/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.view.MixVariantLabelView;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.util.ArrayList;

public class MixVariantLabelCell
extends LabelCell {
    private ArrayList strList;

    @Override
    public void setText(String text) {
        super.setText(text);
        this.strList = text == null ? null : KDPrinterUtils.parseVariantText(text);
    }

    @Override
    public String getParserText(PainterInfo info) {
        if (this.strList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.strList.size();
        for (int i = 0; i < size; ++i) {
            String str = (String)this.strList.get(i);
            if (str == null) continue;
            int len = str.length();
            if (len > 2 && str.charAt(0) == '&' && str.charAt(1) == '[') {
                String temp = KDPrinterUtils.parseVariant(info, str.substring(2));
                if (temp == null) continue;
                sb.append(temp);
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public void updateView() {
        this.setPainterView(MixVariantLabelView.createPainterView());
    }
}

