/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls.output;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.bos.ctrl.print.xls.widget.XlsCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsImageCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsLabelCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsPaper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XlsNodeContainer {
    private int _limit = 10;
    private List _nodeCache;
    private int _size = 0;
    private XMLOutputter _outputter;
    private SAXBuilder _sb;
    private RandomAccessFile _file;
    private List _objSize;
    private Logger _log = LogUtil.getLogger(XlsNodeContainer.class);
    private boolean _reachLimit = false;
    private FileInputStream _is = null;

    public XlsNodeContainer(int count) {
        this._limit = count;
        this._nodeCache = new ArrayList(count);
    }

    public void add(XlsPaper node) {
        this._nodeCache.add(node);
        ++this._size;
    }

    private void reachLimit() {
        if (this._size == this._limit) {
            this._log.info((Object)"init hd cache");
            this._reachLimit = true;
            Format format = Format.getPrettyFormat();
            format.setIndent("");
            format.setEncoding("utf-8");
            this._outputter = new XMLOutputter(format);
            this._objSize = new ArrayList();
            File path = this.createBufferFile();
            try {
                this._is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                this._log.error((Object)"xls cache does not exits!!", (Throwable)e);
            }
        }
    }

    public void clear() {
        try {
            if (this._file != null) {
                this._file.close();
                this._file = null;
            }
            if (this._is != null) {
                this._is.close();
            }
            this._size = 0;
            if (this._reachLimit) {
                this._objSize.clear();
            }
            this._nodeCache.clear();
            this._reachLimit = false;
        }
        catch (IOException e) {
            this._log.error((Object)"XlsNodeContainer clear faild");
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int _currentIndex = 0;

            @Override
            public boolean hasNext() {
                return XlsNodeContainer.this._size > 0;
            }

            public Object next() {
                Object obj = null;
                obj = XlsNodeContainer.this._nodeCache.get(this._currentIndex);
                return obj;
            }

            @Override
            public void remove() {
                XlsNodeContainer.this._nodeCache.remove(this._currentIndex);
                XlsNodeContainer.this._size--;
            }
        };
    }

    private XlsPaper toPaper(Element element) {
        XlsPaper paper = new XlsPaper();
        Element paperInfo = element.getChild("common");
        Element kids = element.getChild("children");
        Element curElement2 = null;
        this.parseCommon(paperInfo, paper);
        List children = kids.getChildren();
        for (Element curElement2 : children) {
            paper.addNode(this.toNode(curElement2));
        }
        return paper;
    }

    private IXlsNode toNode(Element element) {
        XlsCell node = null;
        if (element.getName().equals("text")) {
            node = new XlsLabelCell();
            String value = element.getChild("value").getText();
            node.setValue(value);
        } else if (element.getName().equals("image")) {
            String content = element.getText();
            byte[] data = Base64.decode((String)content);
            ImageIcon icon = null;
            try {
                ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(data));
                icon = (ImageIcon)oin.readObject();
            }
            catch (Exception e) {
                this._log.error((Object)"read image cached data faild!", (Throwable)e);
            }
            XlsImageCell cell = new XlsImageCell();
            if (icon != null) {
                cell.setImage(icon.getImage());
            }
            node = cell;
        }
        Element tempE = element.getChild("common");
        this.parseCommon(tempE, node);
        return node;
    }

    private void parseCommon(Element element, IXlsNode node) {
        if (element == null) {
            return;
        }
        float width = Float.parseFloat(element.getAttribute("cell.width").getValue());
        float height = Float.parseFloat(element.getAttribute("cell.height").getValue());
        int layer = Integer.parseInt(element.getAttribute("layer").getValue());
        String stylekey = element.getAttributeValue("stylecode");
        String location = element.getChildText("location");
        String[] locations = location.split(",");
        node.setBounds(Float.parseFloat(locations[0]), Float.parseFloat(locations[1]), width + 1.0f, height + 1.0f);
        node.setStyleKey(stylekey);
        node.setLayer(layer);
    }

    private File createBufferFile() {
        File bufferFile = null;
        if (this._file == null) {
            bufferFile = TempFileUtil.createTempFile();
            try {
                this._file = new RandomAccessFile(bufferFile, "rw");
            }
            catch (IOException e) {
                this._log.error((Object)"create xls cache faild", (Throwable)e);
            }
        }
        return bufferFile.getAbsoluteFile();
    }

    private byte[] toByte(Element element) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this._outputter.output(element, (OutputStream)bos);
        }
        catch (IOException e) {
            this._log.error((Object)"Xls\u5bf9\u8c61\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        byte[] data = bos.toByteArray();
        return data;
    }

    private Element toElement(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Element element = null;
        try {
            Document doc = this.getSAXBuilder().build((InputStream)bis);
            element = doc.getRootElement();
        }
        catch (JDOMException e) {
            this._log.error((Object)"Xls\u5bf9\u8c61\u7f13\u5b58\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        catch (IOException e) {
            this._log.error((Object)"Xls\u7f13\u5b58\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
        }
        return element;
    }

    private SAXBuilder getSAXBuilder() {
        if (this._sb == null) {
            this._sb = new SAXBuilder();
        }
        return this._sb;
    }

    public int size() {
        return this._size;
    }
}

