/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.rowsfile;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IPersistent;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.olap.util.InOutSqlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class RowsFile {
    private String filePath;
    private Object persistent;
    private ResultSetMetaData metaData;
    private ArrayList offsets;
    private int opRows;
    private Object[] cachedRows;
    private int length = 0;
    private int lastPersistent = 0;
    private int readPos;
    private int nextRow;

    public RowsFile(ResultSetMetaData rsmd, int cacheRows) throws IOException, SQLException {
        this.cachedRows = new Object[cacheRows];
        this.filePath = "t" + System.currentTimeMillis() + ".dat";
        this.metaData = rsmd instanceof IPersistent ? rsmd : new SimpleResultSetMetaData(rsmd);
        this.offsets = new ArrayList();
        this.setReadMode(false);
    }

    public RowsFile(ResultSetMetaData rsmd) throws IOException, SQLException {
        this(rsmd, 128);
    }

    public final ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public final int getCacheSize() {
        return this.cachedRows.length;
    }

    public final int getRowCount() {
        return this.offsets.size();
    }

    public void addRow(Object[] rowData) throws IOException {
        this.assertStatus();
        if (this.isReadMode()) {
            throw new IOException("Couldn't write row at reading mode.");
        }
        try {
            this.cachedRows[this.opRows] = ArrayUtil.copyGenericArray((Object[])rowData);
            if (++this.opRows == this.cachedRows.length) {
                this.flushRows();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private final void flushRows() throws IOException, SQLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.cachedRows.length * 32);
        DataOutputStream dataOutput = new DataOutputStream(baos);
        for (int i = 0; i < this.cachedRows.length && this.cachedRows[i] != null; ++i) {
            this.offsets.add(new Integer(this.length));
            InOutSqlUtil.writeJavaRow((ResultSetMetaData)this.metaData, (Object[])((Object[])this.cachedRows[i]), (DataOutput)dataOutput);
            this.length = this.lastPersistent + baos.size();
        }
        this.lastPersistent = this.length;
        baos.writeTo(this.asOutputStream());
        baos.reset();
        ArrayUtil.clearArray((Object[])this.cachedRows);
        this.opRows = 0;
    }

    private final int readToCache() throws IOException, SQLException {
        byte[] bytes = this.readRowsAsBytes(this.cachedRows.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dataInput = new DataInputStream(bais);
        for (int i = 0; i < this.cachedRows.length; ++i) {
            try {
                this.cachedRows[i] = InOutSqlUtil.readJavaRow((ResultSetMetaData)this.metaData, (DataInput)dataInput);
                continue;
            }
            catch (EOFException e) {
                return i;
            }
        }
        return this.cachedRows.length;
    }

    public final void setReadMode(boolean readMode) throws IOException, SQLException {
        if ((readMode && this.isReadMode() || !readMode && !this.isReadMode()) && this.persistent != null) {
            return;
        }
        if (this.persistent != null) {
            this.closeStream(readMode);
        }
        if (readMode) {
            this.persistent = new FileInputStream(this.filePath);
            this.opRows = 0;
            this.nextRow = 0;
            this.readPos = 0;
        } else {
            this.persistent = new FileOutputStream(this.filePath);
            this.opRows = 0;
        }
    }

    public final boolean isReadMode() {
        return this.persistent != null && this.persistent instanceof InputStream;
    }

    public final Object[] readNextRow() throws IOException {
        this.assertStatus();
        if (!this.isReadMode()) {
            throw new IOException("Couldn't read row at reading mode.");
        }
        if (this.nextRow == this.getRowCount()) {
            return null;
        }
        try {
            if (this.opRows == 0) {
                this.readToCache();
            }
            Object row = this.cachedRows[this.opRows];
            ++this.nextRow;
            if (++this.opRows == this.cachedRows.length) {
                this.opRows = 0;
            }
            return (Object[])row;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final void seek(int row) throws IOException {
        this.assertStatus();
        if (row < 0 || row >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.isReadMode()) {
            throw new IOException("Couldn't read row at reading mode.");
        }
        if (row == this.nextRow) {
            return;
        }
        int dest = (Integer)this.offsets.get(row);
        this.asInputStream().skip(dest - this.readPos);
        this.readPos = dest;
        this.opRows = 0;
        this.nextRow = row;
    }

    private final void closeStream(boolean tryFlush) throws IOException, SQLException {
        if (this.persistent == null) {
            return;
        }
        if (this.isReadMode()) {
            this.asInputStream().close();
        } else {
            if (tryFlush) {
                this.flushRows();
            }
            this.asOutputStream().close();
        }
        this.persistent = null;
    }

    private final byte[] readRowsAsBytes(int rows) throws IOException {
        int row2 = this.nextRow + rows;
        int offset0 = (Integer)this.offsets.get(this.nextRow);
        this.readPos = row2 >= this.offsets.size() ? this.length : (Integer)this.offsets.get(row2);
        byte[] bytes = new byte[this.readPos - offset0];
        this.asInputStream().read(bytes);
        return bytes;
    }

    private final void assertStatus() throws IOException {
        if (this.persistent == null) {
            throw new IOException("Object was already destroied.");
        }
    }

    public final void destroy() {
        this.pureDestroy();
    }

    private final void pureDestroy() {
        try {
            this.closeStream(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        new File(this.filePath).delete();
    }

    private final InputStream asInputStream() {
        return (InputStream)this.persistent;
    }

    private final OutputStream asOutputStream() {
        return (OutputStream)this.persistent;
    }
}

