/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.meta.ui;

import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.res.MetaIcons;
import com.kingdee.bos.ctrl.reportone.data.modal.comparor.DefObjComparator;
import com.kingdee.bos.ctrl.reportone.data.modal.comparor.IndexedComparator;
import com.kingdee.bos.ctrl.reportone.data.res.DataIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;

public class MetaTreeCtrl
extends ATreeController {
    private DefObj rootObj;
    private Map mcIcons;

    public MetaTreeCtrl(DefObj rootMeta) {
        this.rootObj = rootMeta;
    }

    public void setRootObj(DefObj rootMeta) {
        this.rootObj = rootMeta;
    }

    public DefObj getRootObj() {
        return this.rootObj;
    }

    public void initTreeUI(TreeUI treeUI) {
        TreeUINode topNode = this.makeNode(this.rootObj);
        treeUI.setRootNode(topNode);
        this.bindTreeUI(treeUI, topNode);
    }

    private ImageIcon getIcon(Object obj) {
        if (obj instanceof MetaField) {
            return MetaIcons.ICON_FIELD;
        }
        if (obj instanceof MetaClass) {
            String mcType = ((MetaClass)obj).getType();
            ImageIcon icon = null;
            if (this.mcIcons != null) {
                icon = (ImageIcon)this.mcIcons.get(mcType);
            }
            if (icon == null) {
                icon = DataIcons.getDataDefIcon(mcType);
            }
            return icon != null ? icon : MetaIcons.ICON_CLASS;
        }
        if (obj instanceof MetaLibrary) {
            return MetaIcons.ICON_LIBRARY;
        }
        if (obj instanceof MetaPackage) {
            return MetaIcons.ICON_PACKAGE;
        }
        if (obj instanceof MetaManager) {
            return MetaIcons.ICON_LIBRARY;
        }
        return null;
    }

    private TreeUINode makeNode(DefObj defObj) {
        TreeUINode node;
        if (defObj == null) {
            node = new TreeUINode("null");
        } else {
            node = new TreeUINode(defObj.getName());
            node.setAlias(defObj.getAlias());
            node.setUserObject((Object)defObj);
            node.setCustomIcon((Icon)this.getIcon(defObj));
        }
        return node;
    }

    protected boolean initNode(TreePath treePath) {
        block3: {
            Object obj;
            TreeUINode node;
            block4: {
                block2: {
                    node = (TreeUINode)treePath.getLastPathComponent();
                    obj = node.getUserObject();
                    if (!(obj instanceof MetaPackage) && !(obj instanceof MetaLibrary)) break block2;
                    MetaPackage mp = obj instanceof MetaPackage ? (MetaPackage)obj : ((MetaLibrary)obj).getRootPackage();
                    this.initMetaPackage(node, mp);
                    break block3;
                }
                if (!(obj instanceof MetaClass)) break block4;
                MetaClass mc = (MetaClass)obj;
                Iterator itrFld = mc.getFields().iterator();
                while (itrFld.hasNext()) {
                    TreeUINode ndFld = this.makeNode((DefObj)itrFld.next());
                    this.getTreeUI().addChildNode(ndFld, node);
                    ndFld.setAllowsChildren(false);
                }
                break block3;
            }
            if (!(obj instanceof MetaManager)) break block3;
            MetaManager mm = (MetaManager)obj;
            Iterator itrLib = mm.getLibraries().iterator();
            while (itrLib.hasNext()) {
                TreeUINode ndLib = this.makeNode((DefObj)itrLib.next());
                this.getTreeUI().addChildNode(ndLib, node);
            }
        }
        return true;
    }

    private void initMetaPackage(TreeUINode node, MetaPackage mp) {
        List mps = mp.getPackages();
        Collections.sort(mps, DefObjComparator.getInstance());
        List mcs = mp.getClasses();
        Collections.sort(mcs, MetaClassComparator.getInstance());
        Iterator itrPkg = mps.iterator();
        while (itrPkg.hasNext()) {
            TreeUINode ndPkg = this.makeNode((DefObj)((MetaPackage)itrPkg.next()));
            this.getTreeUI().addChildNode(ndPkg, node);
        }
        for (MetaClass mc : mcs) {
            if (!this.isVisible(mc.getType(), mc.toString())) continue;
            TreeUINode ndCls = this.makeNode((DefObj)mc);
            ndCls.setAllowsChildren(false);
            this.getTreeUI().addChildNode(ndCls, node);
        }
    }

    public DefObj getSelectedObj() {
        TreePath path = this.getTreeUI().getSelectionPath();
        if (path == null) {
            return null;
        }
        TreeUINode node = (TreeUINode)path.getLastPathComponent();
        return (DefObj)node.getUserObject();
    }

    public void setMetaClassIcon(String mcType, ImageIcon icon) {
        if (this.mcIcons == null) {
            this.mcIcons = new HashMap();
        }
        this.mcIcons.put(mcType, icon);
    }

    public static class MetaClassComparator
    extends IndexedComparator {
        private static final MetaClassComparator instance = new MetaClassComparator();

        public static final MetaClassComparator getInstance() {
            return instance;
        }

        private MetaClassComparator() {
            super(new Object[]{DataDefType.KDRS_QUERY.getName(), DataDefType.KDRS_ROWSET.getName(), DataDefType.KDRS_GROUPING.getName(), DataDefType.KDRS_CROSSTAB.getName(), DataDefType.BOS_MDQUERY.getName(), DataDefType.BOS_QUERY.getName(), DataDefType.BOS_ENTITY.getName(), DataDefType.BOS_TABLE.getName(), DataDefType.BOS_MDQUERY.getName(), DataDefType.DB_TABLE.getName(), DataDefType.DB_VIEW.getName(), DataDefType.DB_CODE.getName()});
        }

        @Override
        public int compare(Object o1, Object o2) {
            MetaClass mc1 = (MetaClass)o1;
            MetaClass mc2 = (MetaClass)o2;
            int r = super.compare(mc1.getType(), mc2.getType());
            if (r == 0) {
                r = DefObjComparator.getInstance().compare(mc1, mc2);
            }
            return r;
        }
    }
}

