/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal.io;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import com.kingdee.bos.ctrl.reportone.data.modal.DataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.Import;
import com.kingdee.bos.ctrl.reportone.data.modal.Imports;
import com.kingdee.bos.ctrl.reportone.data.modal.Outputs;
import com.kingdee.bos.ctrl.reportone.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.reportone.data.modal.io.ExecDefIO;
import com.kingdee.bos.ctrl.reportone.data.modal.io.XmlTool;
import com.kingdee.bos.ctrl.reportone.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.reportone.data.modal.types.crosstab.io.Xml2CrosstabDef;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.io.Xml2Grouping;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.io.Xml2OutputColumns;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class Xml2DataDef {
    public static final Logger log = LogUtil.getPackageLogger(Xml2DataDef.class);
    public static HashMap outputDefRegistry = new HashMap();

    public static final DataDef toObject(Element e) {
        DataDef dataObject = new DataDef();
        Xml2DataDef.toObject(dataObject, e);
        return dataObject;
    }

    public static final void toObject(DataDef obj, Element e) {
        Xml2Def.parseDefObj((IDefObj)obj, (Element)e);
        Element child = e.getChild("Imports");
        obj.setImports(child == null ? null : Xml2Imports.toObject(child));
        child = e.getChild("Parameters");
        obj.setParameters(child == null ? new ArrayList() : ParameterIO.parseParameters((Element)child));
        child = e.getChild("ProccessScript");
        obj.setProcessScript(child == null ? null : Xml2ProcessScript.toObject(child));
        child = e.getChild("Outputs");
        obj.setOutputs(child == null ? null : Xml2Outputs.toObject(child));
        child = e.getChild("DesignInfoes");
        obj.setDesignInfoes(child);
    }

    static {
        outputDefRegistry.put("Columns", Xml2OutputColumns.class);
        outputDefRegistry.put("Grouping", Xml2Grouping.class);
        outputDefRegistry.put("Crosstab", Xml2CrosstabDef.class);
    }

    public static final class Xml2ProcessScript {
        public static final ProcessScript toObject(Element e) {
            String bStr;
            ScriptType st;
            ProcessScript ps = new ProcessScript();
            String scriptType = e.getAttributeValue("script-type");
            if (scriptType != null && (st = ScriptType.valueOf(scriptType)) != null) {
                ps.setType(st);
                ps.setScript(e.getText());
            }
            if ((bStr = e.getAttributeValue("auto-make-calling")) != null) {
                ps.setAutoMakeCalling(Boolean.valueOf(bStr));
            }
            Xml2Def.parseDefObj((IDefObj)ps, (Element)e);
            return ps;
        }
    }

    public static final class Xml2Imports {
        public static final Imports toObject(Element e) {
            Imports imports = new Imports();
            try {
                List c = XmlTool.xml2List(e, "Import", Xml2Import.class);
                imports.addAll(c);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return imports;
        }

        public static final class Xml2Import {
            public static final Import toObject(Element e) {
                Element xmlArgs;
                Import obj = new Import();
                Xml2Def.parseDefObj((IDefObj)obj, (Element)e);
                String expr = e.getAttributeValue("expr");
                if (expr != null) {
                    obj.setExpr(expr);
                }
                if ((xmlArgs = e.getChild("Args")) != null) {
                    obj.setArgs(ExecDefIO.parseArgs(xmlArgs));
                }
                return obj;
            }
        }
    }

    public static final class Xml2Outputs {
        public static final Outputs toObject(Element e) {
            if (e == null) {
                return null;
            }
            Outputs outputs = new Outputs();
            for (Element output_e : e.getChildren()) {
                Object output = Xml2Outputs.xml2Output(output_e);
                if (output == null) continue;
                outputs.add(output);
            }
            return outputs;
        }

        public static final Object xml2Output(Element e) {
            Class xml2ObjClass = (Class)outputDefRegistry.get(e.getName());
            try {
                Method m = xml2ObjClass.getMethod("toObject", Element.class);
                return m.invoke(null, e);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }
    }
}

