/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.reportone.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.FilterPaneWrapper;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.SortPaneWrapper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class CommonFilterPanel
extends KDPanel {
    private FilterPaneWrapper _filterUI;
    private SortPaneWrapper _sortUI;
    private IQuery _data;

    public CommonFilterPanel() {
        this.init();
    }

    private void init() {
        this._filterUI = new CustomFilterUI();
        this._sortUI = new SortPaneWrapper();
        KDPanel panFilter = new KDPanel((LayoutManager)new BorderLayout());
        panFilter.setCustomInsets(new Insets(8, 8, 8, 8));
        panFilter.add((Component)this._filterUI.getPanel(), (Object)"Center");
        KDPanel panSort = new KDPanel((LayoutManager)new BorderLayout());
        panSort.setCustomInsets(new Insets(8, 8, 8, 8));
        panSort.add((Component)this._sortUI.getPanel(), (Object)"Center");
        KDTabbedPane tabbedPane = new KDTabbedPane();
        tabbedPane.addTab(Wizard2Resource.getString("res_3"), (Component)panFilter);
        tabbedPane.addTab(Wizard2Resource.getString("res_4"), (Component)panSort);
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
    }

    public void setData(IQuery data, IMetaProvider metaProvider) {
        this.updateSupply(data, metaProvider);
        this._data = data;
        if (data.getFilter() != null) {
            this._filterUI.showValue((DesignedFilterList)data.getFilter().getExtObj());
        }
        this._sortUI.showValue(data);
    }

    public IQuery getData() {
        this._filterUI.updateData(this._data);
        this._sortUI.updateData(this._data);
        return this._data;
    }

    private void updateSupply(IQuery data, IMetaProvider metaProvider) {
        this._filterUI.setExpressSupply((List)((Object)data.getColumns()));
        this._filterUI.setValueSupply(metaProvider.getParams().getFields());
        this._filterUI.setFormulaWizardSupply(data, metaProvider);
    }

    public static interface IMetaProvider {
        public MetaClass getMetaClass(String var1);

        public MetaClass getParams();
    }

    private class CustomFilterUI
    extends FilterPaneWrapper {
        public CustomFilterUI() {
            this._cmbValue.setEditor((ComboBoxEditor)new CustomComboBoxEditor());
        }

        @Override
        protected String getColExpressString(Object value) {
            if (value instanceof Column) {
                return ((Column)((Object)value)).getName();
            }
            return super.getColExpressString(value);
        }

        @Override
        protected Object getColExpressCellValue(String expr) {
            int c = this._cmbExpress.getItemCount();
            for (int i = 0; i < c; ++i) {
                Object item = this._cmbExpress.getItemAt(i);
                if (!(item instanceof Column) || !StringUtil.equals((String)((Column)((Object)item)).getName(), (String)expr)) continue;
                return item;
            }
            return super.getColExpressCellValue(expr);
        }

        @Override
        protected String getColValueString(Object value) {
            if (value instanceof MetaField) {
                return this.makeString((MetaField)value);
            }
            return super.getColValueString(value);
        }

        private String makeString(MetaField mf) {
            boolean needQuotationMark;
            StringBuffer sb = new StringBuffer();
            sb.append("@");
            sb.append(mf.getExpr());
            boolean bl = needQuotationMark = mf.getType().equals(DataType.STRING) || mf.getType().equals(DataType.DATETIME);
            if (needQuotationMark) {
                sb.insert(0, "'");
                sb.append("'");
            }
            return sb.toString();
        }

        @Override
        protected Object getColValueCellValue(String value) {
            return value;
        }

        class CustomComboBoxEditor
        extends BasicComboBoxEditor {
            CustomComboBoxEditor() {
            }

            @Override
            public void setItem(Object anObject) {
                if (anObject instanceof MetaField) {
                    this.editor.setText(CustomFilterUI.this.getColValueString(anObject));
                } else if (anObject instanceof String) {
                    this.editor.setText((String)anObject);
                } else {
                    this.editor.setText("");
                }
            }

            @Override
            public Object getItem() {
                return this.editor.getText();
            }
        }
    }
}

