/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.data.modal.DataConvertHelper;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.io.OutputColumns2Xml;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.io.Xml2OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.wizard.WizardResource;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.ColumnsEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.RowsEditor;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom2.Content;
import org.jdom2.Element;

public class CustomRowsEditor {
    private ColumnsEditor colsEditor = new ColumnsEditor();
    private RowsEditor rowsEditor = new RowsEditor();
    private KDTabbedPane tabPane = new KDTabbedPane();

    public CustomRowsEditor() {
        this.tabPane.addTab(WizardResource.getString("res_1"), (Component)((Object)this.colsEditor));
        this.tabPane.addTab(WizardResource.getString("res_2"), (Component)((Object)this.rowsEditor));
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDTabbedPane pane = (KDTabbedPane)e.getSource();
                Component obj = pane.getSelectedComponent();
                if (obj == CustomRowsEditor.this.rowsEditor) {
                    CustomRowsEditor.this.rowsEditor.setColumns(CustomRowsEditor.this.colsEditor.getColumns());
                } else if (obj == CustomRowsEditor.this.colsEditor) {
                    CustomRowsEditor.this.colsEditor.trim();
                }
            }
        });
    }

    private void update() {
        Component obj = this.tabPane.getSelectedComponent();
        if (obj == this.rowsEditor) {
            this.colsEditor.trim();
        } else if (obj == this.colsEditor) {
            this.rowsEditor.setColumns(this.colsEditor.getColumns());
        }
    }

    public final KDTabbedPane getComponent() {
        return this.tabPane;
    }

    public static class XmlIO {
        public static final void loadXml(CustomRowsEditor editor, Element e) {
            Element eCols = e.getChild("Columns");
            Element eRows = e.getChild("Rows");
            XmlUtil.printElement((Element)e);
            OutputColumns columns = XmlIO.loadXml(editor.colsEditor, eCols);
            editor.rowsEditor.setColumns(columns);
            XmlIO.loadXml(editor.rowsEditor, columns, eRows);
        }

        public static final Element toXml(CustomRowsEditor editor) {
            editor.update();
            Element e = new Element("XmlTable");
            e.addContent((Content)XmlIO.toXml(editor.colsEditor));
            e.addContent((Content)XmlIO.toXml(editor.rowsEditor));
            return e;
        }

        private static final OutputColumns loadXml(ColumnsEditor colsEditor, Element e) {
            OutputColumns ocs = Xml2OutputColumns.toObject(e);
            colsEditor.setColumns(ocs);
            return ocs;
        }

        private static final Element toXml(ColumnsEditor colsEditor) {
            List cols = colsEditor.getColumns();
            OutputColumns ocs = new OutputColumns();
            ocs.addAll(cols);
            return OutputColumns2Xml.toXml(ocs);
        }

        private static final void loadXml(RowsEditor rowsEditor, List columns, Element e) {
            OutputColumn[] colArray = new OutputColumn[columns.size()];
            columns.toArray(colArray);
            KDTable table = rowsEditor.getTable();
            table.removeRows();
            for (Element eRow : e.getChildren()) {
                Iterator cols = eRow.getChildren().iterator();
                int column = 0;
                IRow row = table.addRow();
                while (cols.hasNext()) {
                    String strVal = ((Element)cols.next()).getText();
                    if (colArray[column].getDataType() == DataType.DATETIME) {
                        try {
                            DateFormat formater = DateFormat.getDateInstance();
                            Date date = formater.parse(strVal);
                            row.getCell(column).setValue((Object)date);
                            ++column;
                            continue;
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                    row.getCell(column).setValue(DataConvertHelper.str2data(strVal, colArray[column].getDataType()));
                    ++column;
                }
            }
        }

        private static final Element toXml(RowsEditor rowsEditor) {
            Element e = new Element("Rows");
            KDTable table = rowsEditor.getTable();
            int rows = table.getRowCount();
            int colCount = table.getColumnCount();
            for (int i = 0; i < rows; ++i) {
                Element eRow = new Element("R");
                IRow row = table.getRow(i);
                for (int j = 0; j < colCount; ++j) {
                    Object val = row.getCell(j).getValue();
                    if (val instanceof Date) {
                        Date date = (Date)val;
                        DateFormat fomater = DateFormat.getDateInstance();
                        String strDate = fomater.format(date);
                        eRow.addContent((Content)new Element("C").setText(val == null ? "" : strDate));
                        continue;
                    }
                    eRow.addContent((Content)new Element("C").setText(val == null ? "" : val.toString()));
                }
                e.addContent((Content)eRow);
            }
            return e;
        }
    }
}

