/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.TablePanel;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class RowsEditor
extends TablePanel {
    private List list = null;

    public RowsEditor() {
        this.table.addHeadRow();
    }

    public void setColumns(List columns) {
        OutputColumn col;
        int i;
        this.list = columns;
        int rows = this.table.getRowCount();
        int curColCount = this.table.getColumnCount();
        int newColCount = columns.size();
        Object[][] vals = new Object[rows][newColCount];
        for (i = 0; i < newColCount; ++i) {
            col = (OutputColumn)((Object)columns.get(i));
            int oldCol = col.getOriginSeq() - 1;
            if (oldCol < 0 || oldCol >= curColCount) continue;
            for (int row = 0; row < rows; ++row) {
                vals[row][i] = this.table.getRow(row).getCell(oldCol).getValue();
            }
        }
        if (newColCount < curColCount) {
            for (i = 0; i < curColCount - newColCount; ++i) {
                this.table.removeColumn(newColCount);
            }
        } else if (newColCount > curColCount) {
            this.table.addColumns(newColCount - curColCount);
        }
        for (int colIdx = 0; colIdx < newColCount; ++colIdx) {
            col = (OutputColumn)((Object)columns.get(colIdx));
            this.table.getHeadRow(0).getCell(colIdx).setValue((Object)col.getName());
        }
        for (int rowIdx = 0; rowIdx < vals.length; ++rowIdx) {
            IRow row = this.table.getRow(rowIdx);
            for (int colIdx = 0; colIdx < newColCount; ++colIdx) {
                OutputColumn col2 = (OutputColumn)((Object)columns.get(colIdx));
                this.updateRowBandEdit(col2.getDataType(), colIdx);
                row.getCell(colIdx).setValue(vals[rowIdx][colIdx]);
            }
        }
    }

    private void updateRowBandEdit(DataType dataType, int idx) {
        KDTDefaultCellEditor cell;
        KDFormattedTextField formattedText;
        if (dataType == DataType.INTEGER) {
            formattedText = new KDFormattedTextField(0);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.DECIMAL || dataType == DataType.BYTE || dataType == DataType.SHORT || dataType == DataType.LONG || dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            formattedText = new KDFormattedTextField(1);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.BYTE) {
            formattedText = new KDFormattedTextField(6);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.SHORT) {
            formattedText = new KDFormattedTextField(2);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.LONG) {
            formattedText = new KDFormattedTextField(7);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.DOUBLE) {
            formattedText = new KDFormattedTextField(5);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.FLOAT) {
            formattedText = new KDFormattedTextField(4);
            cell = new KDTDefaultCellEditor((JTextField)formattedText);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        }
        if (dataType == DataType.BOOLEAN) {
            KDCheckBox check = new KDCheckBox();
            cell = new KDTDefaultCellEditor((JCheckBox)check);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
        } else if (dataType == DataType.DATETIME) {
            KDDatePicker date = new KDDatePicker();
            cell = new KDTDefaultCellEditor(date);
            this.table.getColumn(idx).setEditor((ICellEditor)cell);
            this.table.getColumn(idx).getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        }
    }

    @Override
    protected void onClickBT(int btVal) {
        super.onClickBT(btVal);
        if (btVal == 1 && this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                OutputColumn column = (OutputColumn)((Object)this.list.get(i));
                this.updateRowBandEdit(column.getDataType(), i);
            }
        }
    }
}

