/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.restype.INamedObject;
import com.kingdee.bos.ctrl.common.restype.NamedObjectList;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.AbstractArgsSchemaProvider;
import com.kingdee.util.Uuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Eas_ArgsSchemeProvider
extends AbstractArgsSchemaProvider {
    private static final Logger log = LogUtil.getPackageLogger(Eas_ArgsSchemeProvider.class);
    private String userId;
    private String rptPath;
    private String basePath;
    private Properties userIndeces;

    public void saveAll() {
        this.saveSchemes(this.schemes);
    }

    public final String getBasePath() {
        return this.basePath;
    }

    public final void setBaseFolder(String basePath) {
        this.basePath = basePath;
    }

    public final String getRptPath() {
        return this.rptPath;
    }

    public final void setReportPath(String rptPath) {
        this.rptPath = rptPath;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(String userId) {
        this.userId = userId;
    }

    private String getUserIndexFilePath() {
        return this.basePath + File.separator + this.userId + File.separator + "index";
    }

    private String getUserFolderPath() {
        return this.basePath + File.separator + this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUserRptIndexes() {
        if (this.userIndeces == null) {
            this.userIndeces = new Properties();
            File indexFile = new File(this.getUserIndexFilePath());
            if (indexFile.exists() && indexFile.isFile()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(indexFile);
                    this.userIndeces.load(fin);
                }
                catch (Exception ex) {
                    try {
                        log.error((Object)"", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        CtrlUtil.Stream.closeStream(fin);
                        throw throwable;
                    }
                    CtrlUtil.Stream.closeStream((InputStream)fin);
                }
                CtrlUtil.Stream.closeStream((InputStream)fin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void loadSchemes(NamedObjectList list) {
        this.ensureUserRptIndexes();
        String schemesFileName = this.userIndeces.getProperty(this.rptPath.toLowerCase());
        if (schemesFileName == null) {
            return;
        }
        String schemesFilePath = this.getUserFolderPath() + File.separator + schemesFileName;
        File schemesFile = new File(schemesFilePath);
        if (schemesFile.isFile() && schemesFile.exists()) {
            FileInputStream fin = null;
            ObjectInputStream objIn = null;
            try {
                INamedObject obj;
                fin = new FileInputStream(schemesFile);
                objIn = new ObjectInputStream(fin);
                while ((obj = (INamedObject)objIn.readObject()) != null) {
                    list.add(obj);
                }
            }
            catch (IOException obj) {
                CtrlUtil.Stream.closeStream(fin);
                CtrlUtil.Stream.closeStream(objIn);
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                {
                    catch (Throwable throwable) {
                        CtrlUtil.Stream.closeStream(fin);
                        CtrlUtil.Stream.closeStream(objIn);
                        throw throwable;
                    }
                }
                CtrlUtil.Stream.closeStream((InputStream)fin);
                CtrlUtil.Stream.closeStream((InputStream)objIn);
            }
            CtrlUtil.Stream.closeStream((InputStream)fin);
            CtrlUtil.Stream.closeStream((InputStream)objIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveSchemes(NamedObjectList list) {
        if (list == null) {
            return;
        }
        File userConfigFolder = CtrlUtil.File.createFolder((String)this.getUserFolderPath());
        if (userConfigFolder == null) {
            return;
        }
        this.ensureUserRptIndexes();
        String lowerPath = this.rptPath.toLowerCase();
        String schemesFileName = this.userIndeces.getProperty(lowerPath);
        if (schemesFileName == null) {
            schemesFileName = Uuid.create().toString();
            this.userIndeces.put(lowerPath, schemesFileName);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(this.getUserIndexFilePath());
                this.userIndeces.store(fout, null);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    CtrlUtil.Stream.closeStream(fout);
                    throw throwable;
                }
                CtrlUtil.Stream.closeStream((OutputStream)fout);
                return;
            }
            CtrlUtil.Stream.closeStream((OutputStream)fout);
        }
        String schemesFilePath = this.getUserFolderPath() + File.separator + schemesFileName;
        CtrlUtil.File.deleteFile((String)schemesFilePath);
        OutputStream fout = null;
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(new FileOutputStream(schemesFilePath));
            Iterator i = list.iterator();
            while (i.hasNext()) {
                objOut.writeObject(i.next());
            }
        }
        catch (Exception ex) {
            try {
                log.error((Object)"", (Throwable)ex);
            }
            catch (Throwable throwable) {
                CtrlUtil.Stream.closeStream(fout);
                CtrlUtil.Stream.closeStream(objOut);
                throw throwable;
            }
            CtrlUtil.Stream.closeStream(fout);
            CtrlUtil.Stream.closeStream((OutputStream)objOut);
        }
        CtrlUtil.Stream.closeStream(fout);
        CtrlUtil.Stream.closeStream((OutputStream)objOut);
    }
}

