/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.common.ui.restree.ItemsHelper;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.EasResource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_KdrsUI;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.BizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.util.AbortException;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class Eas_BizContentTreeCtrl
extends BizContentTreeCtrl {
    public static final Logger log = LogUtil.getPackageLogger(Eas_BizContentTreeCtrl.class);
    private KDToolBar toolBar;
    private KDTable resourceTable;
    private boolean firstAdjustToolbar = true;
    private Eas_KdrsUI eas_kdrs_ui;

    public Eas_BizContentTreeCtrl(Eas_KdrsUI eas_kdrs_ui, IContextSupplier contextSupplier, IBizSecurity bizSec) {
        super(BizStorageTreeCtrl.loadTypeDefs(Eas_BizContentTreeCtrl.class, "content_restree.xml"), contextSupplier, bizSec);
        this.eas_kdrs_ui = eas_kdrs_ui;
        this.resourceTable = eas_kdrs_ui.getContentComponent();
        this.toolBar = eas_kdrs_ui.getUIToolBar();
        this.resourceTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (Eas_BizContentTreeCtrl.this.resourceTable.getSelectManager().getActiveRowIndex() < 0) {
                    return;
                }
                if (2 == e.getClickCount() && e.getType() == 1) {
                    IRow row = Eas_BizContentTreeCtrl.this.resourceTable.getRow(Eas_BizContentTreeCtrl.this.resourceTable.getSelectManager().getActiveRowIndex());
                    try {
                        Eas_BizContentTreeCtrl.this.initResNode((ResObjectNode)row.getUserObject());
                    }
                    catch (Exception ex) {
                        log.error(null, (Throwable)ex);
                    }
                } else {
                    Eas_BizContentTreeCtrl.this.adjustToolbar(false);
                }
            }
        });
        this.resourceTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == Eas_BizContentTreeCtrl.this.getTreeUI().getTree()) {
                    Eas_BizContentTreeCtrl.this.adjustToolbar(true);
                }
            }
        });
        KDTSortManager sm = new KDTSortManager(this.resourceTable);
        sm.setSortAuto(true);
    }

    public Eas_KdrsUI getKdrsUI() {
        return this.eas_kdrs_ui;
    }

    protected boolean onPopMenu(TreePath[] treePaths, JPopupMenu popupMenu) {
        return false;
    }

    protected boolean onSelectNode(TreePath selectPath, TreePath deselectPath) {
        if (deselectPath != null) {
            ResObjectNode deselectNode = (ResObjectNode)deselectPath.getLastPathComponent();
            deselectNode.setChildrenLoaded(false);
        }
        this.adjustToolbar(true);
        try {
            super.initNode(selectPath);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return true;
    }

    private void adjustToolbar(boolean fromTree) {
        IUIWindow uiWindow;
        Object description;
        this.toolBar.removeAllToolBarComponents();
        ArrayList menuItems = fromTree ? this.getPopMenuActions() : this.getTableItemPopMenuActions();
        int rowIdx = this.resourceTable.getSelectManager().getActiveRowIndex();
        if (!fromTree && rowIdx != -1 && (description = this.resourceTable.getRow(rowIdx).getCell(Eas_KdrsUI.TAB_COL_DESCRIPTION).getValue()) != null) {
            for (int i = 0; i < menuItems.size(); ++i) {
                Object obj = menuItems.get(i);
                if (!(obj instanceof ResNodeAction) || !"publishMenu".equals(((ResNodeAction)obj).getActionDef().getName())) continue;
                ((ResNodeAction)obj).putValue("Name", (Object)EasResource.getString("undopublish"));
            }
        }
        Iterator i = menuItems.iterator();
        while (i.hasNext()) {
            ItemsHelper.addAction((KDToolBar)this.toolBar, i.next());
        }
        if (!this.firstAdjustToolbar && (uiWindow = this.eas_kdrs_ui.getUIWindow()) != null) {
            try {
                ((NewWinMainUI)SystemEntry.instance.getMainUIObject()).addAppToolBar(uiWindow.getUIObject());
            }
            catch (Exception ex) {
                log.warn(null, (Throwable)ex);
            }
        }
        this.firstAdjustToolbar = false;
        Container c = this.toolBar.getParent();
        if (c != null) {
            c.validate();
            c.repaint();
        }
    }

    protected ArrayList getTableItemPopMenuActions() {
        KDTRange range = this.resourceTable.getSelectManager().toRange();
        ArrayList<ResObjectNode> list = new ArrayList<ResObjectNode>();
        for (KDTSelectBlock block : range) {
            for (int row = block.getBeginRow(); row <= block.getEndRow(); ++row) {
                list.add((ResObjectNode)this.resourceTable.getRow(row).getUserObject());
            }
        }
        ResObjectNode[] nodes = new ResObjectNode[list.size()];
        list.toArray(nodes);
        if (nodes.length == 1) {
            return super.getSingleObjectPopMenuActions(nodes[0]);
        }
        return super.getMultiObjectsPopMenuActions(nodes);
    }

    public KDTable getResourceTable() {
        return this.resourceTable;
    }

    public int findRowByResObjectNode(ResObjectNode resNode) {
        int count = this.resourceTable.getRowCount();
        for (int row = 0; row < count; ++row) {
            Object obj = this.resourceTable.getRow(row).getUserObject();
            if (obj != resNode) continue;
            return row;
        }
        return -1;
    }

    public void updateRowByResObjectNode(int rowIdx, ResObjectNode resNode) {
        if (rowIdx < 0) {
            rowIdx = this.findRowByResObjectNode(resNode);
        }
        if (rowIdx >= 0) {
            IRow rowObj = this.resourceTable.getRow(rowIdx);
            rowObj.getCell(Eas_KdrsUI.TAB_COL_TYPEICON).setValue((Object)resNode.getCustomIcon());
            rowObj.getCell(Eas_KdrsUI.TAB_COL_ALIAS).setValue((Object)StringUtil.getDisplayName((String)resNode.getName(), (String)resNode.getAlias()));
            rowObj.getCell(Eas_KdrsUI.TAB_COL_TYPE).setValue(resNode.getStaticResType().getProperty("alias"));
        }
    }

    public boolean removeRowByResObjectNode(ResObjectNode resNode) {
        int count = this.resourceTable.getRowCount();
        for (int row = 0; row < count; ++row) {
            Object obj = this.resourceTable.getRow(row).getUserObject();
            if (obj != resNode) continue;
            this.resourceTable.removeRow(row);
            if (count == 1) {
                this.adjustToolbar(true);
            } else {
                if (row == count - 1) {
                    --row;
                }
                KDTableUtil.setSelectedRow((KDTable)this.resourceTable, (int)row);
                this.adjustToolbar(false);
            }
            return true;
        }
        return false;
    }

    public void selectRowByResObjectNode(String name) {
        int count = this.resourceTable.getRowCount();
        for (int row = 0; row < count; ++row) {
            ResObjectNode obj = (ResObjectNode)this.resourceTable.getRow(row).getUserObject();
            if (!obj.getName().equals(name)) continue;
            KDTableUtil.setSelectedRow((KDTable)this.resourceTable, (int)row);
            this.adjustToolbar(false);
            break;
        }
    }

    protected boolean handleException(Exception ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof UserCancelException || cause instanceof AbortException) {
            return true;
        }
        if (cause instanceof KDRSException || cause instanceof ReportException || cause instanceof RuntimeException || ex instanceof RuntimeException) {
            return false;
        }
        log.error((Object)"unkown error:", (Throwable)ex);
        this.eas_kdrs_ui.handUIExceptionAndAbort((Exception)cause);
        return true;
    }
}

