/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleDataEnvProvider;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.IDBConnectionProvider;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.ITempTableManager;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset.SqlUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_BizContent;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Eas_DataEnvProvider
extends SimpleDataEnvProvider {
    public static final Logger log = LogUtil.getPackageLogger(Eas_DataEnvProvider.class);
    protected Eas_BizContent bizContent;
    protected Context bosCtx;
    public static final String VAR_BOS_CONTEXT = "_ENV_BOS_CONTEXT";
    public static final String VAR_LOCAL2_4BOS = "_ENV_LOCAL2_BY_BOS_CONTEXT";
    private LanguageCollection solu_languages;

    public Eas_DataEnvProvider(Eas_BizContent bizContent) {
        this.bizContent = bizContent;
    }

    public Context getBosContext() {
        if (this.bosCtx == null) {
            this.bosCtx = Eas_DataEnvProvider.getContextFromSession();
        }
        return this.bosCtx;
    }

    protected Connection mekeDBConnection() throws SQLException {
        return EJBFactory.getConnection((Context)this.getBosContext());
    }

    public IDBConnectionProvider getDBConnectionProvider() {
        IDBConnectionProvider provider = (IDBConnectionProvider)super.get("_ENV_DB_CONNECTION_PROVIDER");
        if (provider == null) {
            provider = new IDBConnectionProvider(){

                @Override
                public Connection openConnection() throws SQLException {
                    return Eas_DataEnvProvider.this.mekeDBConnection();
                }
            };
            super.put("_ENV_DB_CONNECTION_PROVIDER", provider);
        }
        return provider;
    }

    public Locale getLocale2ByBosContext() throws Exception {
        Locale boxLocale = this.getBosContext().getLocale();
        if (this.solu_languages == null) {
            MDLoader loader = MDLoader.getInstance();
            if (loader == null) {
                throw new IllegalStateException("Solution not init.");
            }
            IStateManager rtv = loader.findMD(new MetaDataPK2("eas!solu"));
            this.solu_languages = (LanguageCollection)rtv.getStateValue("languages");
        }
        for (int i = 0; i < this.solu_languages.size(); ++i) {
            LanguageInfo li = this.solu_languages.get(i);
            if (!boxLocale.equals(li.getLocale())) continue;
            return li.getOriginalLocale();
        }
        throw new IllegalStateException("Solution not init.");
    }

    public ITempTableManager getTempTableManager() {
        ITempTableManager manager = (ITempTableManager)super.get("_ENV_TEMP_TABLE_NAME_PROVIDER");
        if (manager == null) {
            manager = new ITempTableManager(){
                private String tempView = null;
                private String tempTable = null;

                @Override
                public String allocateTemp() {
                    try {
                        this.tempTable = TableManagerFacadeFactory.getLocalInstance((Context)Eas_DataEnvProvider.this.getBosContext()).getTableName(null);
                        return this.tempTable;
                    }
                    catch (Exception ex) {
                        log.error((Object)"", (Throwable)ex);
                        return null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String allocateTemp(String select_sql) {
                    this.tempTable = this.allocateTemp();
                    this.tempView = this.allocateTemp();
                    if (this.tempTable != null && this.tempView != null) {
                        Connection conn = null;
                        try {
                            conn = Eas_DataEnvProvider.this.mekeDBConnection();
                            StringBuffer sb = new StringBuffer();
                            sb.append("CREATE VIEW ").append(this.tempView).append(" AS ").append(select_sql);
                            Statement stmt = conn.createStatement();
                            stmt.addBatch(sb.toString());
                            sb.setLength(0);
                            sb.append("SELECT * INTO ").append(this.tempTable).append("FROM ").append(this.tempView);
                            stmt.addBatch(sb.toString());
                            stmt.executeBatch();
                        }
                        catch (Exception ex) {
                            log.error((Object)"", (Throwable)ex);
                        }
                        finally {
                            DBUtil.closeDBConn((Connection)conn);
                        }
                    }
                    return this.tempTable;
                }

                @Override
                public String allocateTemp(ResultSet rs) throws SQLException {
                    this.tempTable = this.allocateTemp();
                    Connection conn = null;
                    try {
                        conn = Eas_DataEnvProvider.this.mekeDBConnection();
                        SqlUtil.makeTable(rs, this.tempTable, null, conn);
                    }
                    finally {
                        DBUtil.closeDBConn((Connection)conn);
                    }
                    return null;
                }

                @Override
                public void freeTemp(String name) {
                    try {
                        if (name == null) {
                            name = this.tempTable;
                        }
                        TableManagerFacadeFactory.getLocalInstance((Context)Eas_DataEnvProvider.this.getBosContext()).releaseTableName(name);
                        if (this.tempTable.equals(name) && this.tempView != null) {
                            TableManagerFacadeFactory.getLocalInstance((Context)Eas_DataEnvProvider.this.getBosContext()).releaseTableName(this.tempView);
                            this.tempView = null;
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"", (Throwable)ex);
                    }
                }
            };
            super.put("_ENV_TEMP_TABLE_NAME_PROVIDER", manager);
        }
        return manager;
    }

    @Override
    public Object get(String name) {
        try {
            if ("_ENV_DB_CONNECTION_PROVIDER".equals(name)) {
                return this.getDBConnectionProvider();
            }
            if ("_ENV_TEMP_TABLE_NAME_PROVIDER".equals(name)) {
                return this.getTempTableManager();
            }
            if (VAR_BOS_CONTEXT.equals(name)) {
                return this.getBosContext();
            }
            if (VAR_LOCAL2_4BOS.equals(name)) {
                return this.getLocale2ByBosContext();
            }
            return super.get(name);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    private static Context getContextFromSession() {
        Context ctx = ContextUtils.getContextFromSessionNoException();
        if (ctx != null) {
            return ctx;
        }
        ctx = ConfigMDUtil.getContext();
        if (ctx != null) {
            return ctx;
        }
        throw new RuntimeException("Failed to get context from current session");
    }
}

