/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeTree;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ItemsHelper;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.restree.ResTreeController;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.EasResource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ArgsSchemeProvider;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_Context;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_KdrsUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ObjectSelector;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ReportEnv;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_RptPrintConfigSerializer;
import com.kingdee.bos.ctrl.reportone.forapp.eas.perm.ReportPermissionUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.AbstractArgsSchemaProvider;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.BizContent_ClientExecutor;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui.ArgInput;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AccessDeniedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.r1.common.script.ScriptExecutor;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1argui.AbstractTargetReportInfoProvider;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1argui.ArgUIConfig;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1argui.TargetReportInfo;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.report.IReportEntity;
import com.kingdee.eas.rpts.report.ReportEntityFactory;
import com.kingdee.eas.rpts.report.ReportEntityInfo;
import com.kingdee.eas.util.AbortException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Eas_KdrsReportUI
extends CoreUI {
    private static Logger log = LogUtil.getPackageLogger(Eas_KdrsReportUI.class);
    public static final String UICTX_MainMenuName = "MainMenuName";
    public static final String UICTX_IGNORE_CHECK_PERMISSION = "IGNORE_CHECK_PERMISSION";
    private static final String RES_TYPE = "reportui";
    private static ResTypeDefs typeDefs = BizContentTreeCtrl.loadTypeDefs(Eas_BizContentTreeCtrl.class, "content_restree.xml");
    private ResTreeController controller = new ResTreeController(typeDefs);
    private AReportBrowser browser;
    private OpenRptBrowserThread openRptTask;
    private String reportPath;
    protected boolean windowDisposed = false;

    public void print() throws ReportException {
        this.loadPrintConfigSerializer();
        this.browser.print();
    }

    public void printPreview() throws ReportException {
        this.loadPrintConfigSerializer();
        this.browser.printPreview();
    }

    protected boolean processException(Exception ex) {
        if (this.windowDisposed) {
            log.error((Object)"windowDisposed=true", (Throwable)ex);
            return true;
        }
        if (ex instanceof AccessDeniedException) {
            WindowUtil.msgboxError((Object)EasResource.getString("res_20"), (String)EasResource.getString("res_21"), (Component)((Object)this));
            return true;
        }
        if (ex instanceof UserCancelException) {
            return true;
        }
        log.error((Object)"", (Throwable)ex);
        MessageDialog.show((Component)((Object)this), (Object)EasResource.getString("viewReportError"), (String)EasResource.getString("res_21"), (int)-1, (int)0, (int)0, (String)ExceptionUtil.makeTrace((Throwable)ex));
        return true;
    }

    private void closeReportAndView() throws ReportException {
        this.remove(this.browser.getComponent());
        this.getUIToolBar().removeAllToolBarComponents();
        this.validate();
        this.repaint();
        this.closeReportBrowser();
    }

    private void openReport(RptOpenMode openMode) throws Exception {
        try {
            this.asyncOpenReport(openMode);
        }
        catch (Exception ex) {
            if (!this.processException(ex)) {
                throw ex;
            }
            throw new AbortException();
        }
    }

    public void reopenReport() throws Exception {
        this.openReport(RptOpenMode.REOPEN);
    }

    public void refreshReport() throws Exception {
        this.openReport(RptOpenMode.REFRESH);
    }

    public void onLoad() throws Exception {
        this.openReport(RptOpenMode.NORMAL);
        super.onLoad();
    }

    protected void disposeUIWindow() {
        this.windowDisposed = true;
        super.disposeUIWindow();
        this.closeReportBrowser();
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        BorderLayout layout = new BorderLayout();
        layout.setHgap(8);
        layout.setVgap(8);
        this.setLayout(layout);
    }

    private void loadToolbar() {
        ResTypeDef typeDef = typeDefs.find(RES_TYPE);
        ResObjectNode resObjNode = new ResObjectNode("onlineReport", typeDef);
        ResTypeTree typeTree = this.controller.getTypeSystem().getTypeTree(typeDef);
        resObjNode.setTypeTree(typeTree);
        resObjNode.setUserObject((Object)this);
        ArrayList list = this.controller.getSingleObjectPopMenuActions(resObjNode);
        KDToolBar toolBar = this.getUIToolBar();
        toolBar.removeAllToolBarComponents();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ItemsHelper.addAction((KDToolBar)toolBar, i.next());
        }
        Container c = toolBar.getParent();
        if (c != null) {
            c.validate();
            c.repaint();
        }
    }

    private void asyncOpenReport(RptOpenMode openMode) throws Exception {
        if (openMode == RptOpenMode.NORMAL) {
            String uiTitle = (String)this.getUIContext().get(UICTX_MainMenuName);
            String fpText = (String)this.getUIContext().get("UIClassParam");
            HashMap execArgs = (HashMap)this.getUIContext().get(BizContent_ClientExecutor.ARG_HashMap_execArgs);
            String category = null;
            String aOrgType = null;
            String rptId = null;
            String eas_permissionItem = null;
            String publishType = null;
            if (uiTitle == null) {
                this.setUITitle("\u6b63\u5728\u6253\u5f00...");
            } else {
                this.setUITitle(uiTitle);
            }
            if (!fpText.startsWith("::")) {
                ObjectUuidPK rptPk = new ObjectUuidPK("id", BOSUuid.create((String)"59CB05C6"));
                rptPk.setKeyValue("id", (Object)fpText);
                IReportEntity iReport = ReportEntityFactory.getRemoteInstance();
                ReportEntityInfo info = iReport.getReportEntityInfo((IObjectPK)rptPk);
                if (info != null && info.getReportPath() != null) {
                    fpText = "::" + info.getReportPath().substring("/EAS_Report.kdrs".length());
                } else {
                    throw new NotFoundException("\u627e\u4e0d\u5230\u62a5\u8868\u7684\u53d1\u5e03\u8bb0\u5f55. pk='" + fpText + "'");
                }
            }
            String pathText = Eas_KdrsUtil.buildPathText(fpText);
            IBizContent bizCnt = Eas_KdrsUtil.getContext().getBizContent();
            if (category == null || aOrgType == null || rptId == null || eas_permissionItem == null || publishType == null) {
                HashMap atts = bizCnt.getAttributes(pathText, new String[]{"easOrgType", "category", "eas-report-id", "eas-permission-item", "eas-publish-type"});
                if (category == null) {
                    category = (String)atts.get("category");
                }
                if (aOrgType == null) {
                    aOrgType = (String)atts.get("easOrgType");
                }
                if (rptId == null) {
                    rptId = (String)atts.get("eas-report-id");
                }
                if (eas_permissionItem == null) {
                    eas_permissionItem = (String)atts.get("eas-permission-item");
                }
                if (publishType == null) {
                    publishType = (String)atts.get("eas-publish-type");
                }
            }
            OrgType orgType = null;
            if (!StringUtil.isEmptyString(aOrgType)) {
                orgType = OrgType.getEnum(aOrgType);
            }
            if (orgType == null) {
                orgType = OrgType.Company;
            }
            if (rptId != null && !"publish-public".equals(publishType) && !Boolean.TRUE.equals(this.getUIContext().get(UICTX_IGNORE_CHECK_PERMISSION))) {
                if (StringUtil.isEmptyString(eas_permissionItem)) {
                    ReportPermissionUtil.checkViewRptPermission(rptId, orgType);
                } else {
                    ReportPermissionUtil.checkViewRptPermission(eas_permissionItem);
                }
            }
            OrgUnitCollection orgs = new OrgUnitCollection();
            OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(orgType);
            orgs.add(org != null ? org : SysContext.getSysContext().getCurrentOrgUnit());
            Eas_Context pubEnv = new Eas_Context();
            pubEnv.setOrgType(orgType);
            pubEnv.setOrgs(orgs);
            Eas_ReportEnv rptEnv = new Eas_ReportEnv(bizCnt);
            rptEnv.setPublicEnv(pubEnv);
            BizContent_ClientExecutor executor = new BizContent_ClientExecutor(bizCnt);
            executor.setReportEnv(rptEnv);
            executor.setResolver((IObjectSelector)new Eas_ObjectSelector(bizCnt, null));
            HashMap<Object, Object> args = new HashMap<Object, Object>();
            args.put(BizContent_ClientExecutor.ARG_String_uiTitle, uiTitle);
            args.put(BizContent_ClientExecutor.ARG_Component_uiOwner, this.getUIContext().get("OwnerWindow"));
            args.put(BizContent_ClientExecutor.ARG_HashMap_execArgs, execArgs);
            Eas_ArgsSchemeProvider schemesProvider = new Eas_ArgsSchemeProvider();
            SysContext sysCtx = SysContext.getSysContext();
            schemesProvider.setUserId(sysCtx.getCurrentUserInfo().getId().toString());
            schemesProvider.setReportPath(pathText);
            schemesProvider.setBaseFolder(GlobalLocator.getInstance().locateResourceFolder("/RptArgsScheme").getAbsolutePath());
            args.put(AbstractArgsSchemaProvider.class, schemesProvider);
            this.openRptTask = new OpenRptBrowserThread(this, executor, category, pathText, args);
        } else {
            this.openRptTask = new OpenRptBrowserThread(this, this.openRptTask.executor, this.openRptTask.category, this.openRptTask.pathText, this.openRptTask.args);
        }
        this.reportPath = this.openRptTask.pathText;
        this.openRptTask.getArgs().put(RptOpenMode.class, openMode);
        this.openRptTask.start();
    }

    private void closeReportBrowser() {
        try {
            if (this.browser != null) {
                this.browser.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)EasResource.getString("res_22"), (Throwable)ex);
        }
    }

    private void loadPrintConfigSerializer() {
        AReportBrowser ab = this.browser;
        if (ab.getPrntConfigSerializer() != null) {
            return;
        }
        try {
            Eas_RptPrintConfigSerializer serializer = new Eas_RptPrintConfigSerializer();
            SysContext sysCtx = SysContext.getSysContext();
            serializer.setUserId(sysCtx.getCurrentUserInfo().getId().toString());
            serializer.setReportPath(this.reportPath);
            serializer.setBaseFolder(GlobalLocator.getInstance().locateResourceFolder("/PrintConfig").getAbsolutePath());
            ab.setPrintCfgSerializer(serializer);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    public static class a
    extends AbstractTargetReportInfoProvider {
        @Override
        public void process() {
            this.info.setTarget("/Eas_Report.kdrs/test/\u6d4b\u8bd5\u76f4\u63a5\u5f15\u7528BOSQUERY\u7684\u62a5\u8868/rpt.r1-form");
        }
    }

    class OpenRptBrowserThread
    extends Thread {
        ProcessingBoxPanel processingBoxPanel;
        Eas_KdrsReportUI uiObject;
        BizContent_ClientExecutor executor;
        String category;
        String pathText;
        HashMap args;

        public OpenRptBrowserThread(Eas_KdrsReportUI uiObject, BizContent_ClientExecutor executor, String category, String pathText, HashMap args) {
            this.uiObject = uiObject;
            this.executor = executor;
            this.category = category;
            this.pathText = pathText;
            this.args = args;
        }

        private HashMap getArgs() {
            return this.args;
        }

        private void showWaitingBox() {
            if (this.processingBoxPanel == null) {
                this.processingBoxPanel = new ProcessingBoxPanel();
            }
            Eas_KdrsReportUI.this.add((Component)((Object)this.processingBoxPanel), "Center");
        }

        private void hideWaitingBox() {
            Eas_KdrsReportUI.this.remove((Component)((Object)this.processingBoxPanel));
        }

        @Override
        public void run() {
            super.run();
            this.showWaitingBox();
            boolean hasException = false;
            try {
                this.doOpen();
            }
            catch (Exception ex) {
                Eas_KdrsReportUI.this.processException(ex);
                hasException = true;
            }
            finally {
                Eas_ArgsSchemeProvider schemesProvider;
                if (!Eas_KdrsReportUI.this.windowDisposed) {
                    this.hideWaitingBox();
                    if (hasException) {
                        this.uiObject.getUIWindow().close();
                    }
                }
                if ((schemesProvider = (Eas_ArgsSchemeProvider)this.args.get(AbstractArgsSchemaProvider.class)) != null) {
                    schemesProvider.saveAll();
                }
            }
        }

        private void doOpen() throws Exception {
            ArgUIConfig cfg;
            RptOpenMode openMode = (RptOpenMode)this.args.get(RptOpenMode.class);
            if (openMode == RptOpenMode.REFRESH) {
                Eas_KdrsReportUI.this.closeReportAndView();
                Eas_KdrsReportUI.this.browser.browse((HashMap)this.args.get(BizContent_ClientExecutor.ARG_HashMap_execArgs));
            } else {
                if (openMode == RptOpenMode.REOPEN) {
                    this.args.put(BizContent_ClientExecutor.ARG_HashMap_default_execArgs, this.args.remove(BizContent_ClientExecutor.ARG_HashMap_execArgs));
                }
                AReportBrowser newBrowser = null;
                try {
                    newBrowser = (AReportBrowser)this.executor.execute(this.category, this.pathText, this.args, null);
                }
                catch (UserCancelException c) {
                    if (openMode == RptOpenMode.REOPEN) {
                        this.args.put(BizContent_ClientExecutor.ARG_HashMap_execArgs, this.args.remove(BizContent_ClientExecutor.ARG_HashMap_default_execArgs));
                        return;
                    }
                    throw c;
                }
                if (openMode == RptOpenMode.REOPEN) {
                    Eas_KdrsReportUI.this.closeReportAndView();
                }
                Eas_KdrsReportUI.this.browser = newBrowser;
            }
            this.hideWaitingBox();
            if ("true".equals(ReportFactory.getCategoryAttribute(this.category, "is-argui")) && !(cfg = (ArgUIConfig)Eas_KdrsReportUI.this.browser.getReportConfig()).noForward()) {
                this.viewAsArgUI();
                Eas_KdrsReportUI.this.closeReportBrowser();
                return;
            }
            Eas_KdrsReportUI.this.setUITitle(Eas_KdrsReportUI.this.browser.getRptTitle());
            Eas_KdrsReportUI.this.add(Eas_KdrsReportUI.this.browser.getComponent(), "Center");
            Eas_KdrsReportUI.this.validate();
            Eas_KdrsReportUI.this.repaint();
            Eas_KdrsReportUI.this.loadToolbar();
        }

        private void viewAsArgUI() throws Exception {
            AReportBrowser arg_ui_browser = Eas_KdrsReportUI.this.browser;
            Component c = arg_ui_browser.getComponent();
            ArgUIConfig cfg = (ArgUIConfig)arg_ui_browser.getReportConfig();
            if (WindowUtil.showSimpleDialog((Component)c, (Component)((Object)this.uiObject), (String)arg_ui_browser.getRptTitle(), (Dimension)WindowUtil.SIZE_640_480)) {
                if ("miniscript".equals(cfg.getForwardScriptType()) || "javaClass".equals(cfg.getForwardScriptType())) {
                    HashMap execArgs = new HashMap();
                    new ArgInput().parseComponent(c, execArgs);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("execArgs 0:" + execArgs));
                        log.debug((Object)("script type:" + cfg.getForwardScriptType()));
                        log.debug((Object)("script:" + cfg.getForwardScript()));
                    }
                    TargetReportInfo info = new TargetReportInfo();
                    info.setTargetArgs(execArgs);
                    info.setTargetNeedCheckPermission(false);
                    if ("miniscript".equals(cfg.getForwardScriptType())) {
                        HashMap script_RelativedObjs = new HashMap();
                        script_RelativedObjs.put("args", execArgs);
                        ScriptExecutor.getInstance().execute(cfg.getForwardScript(), info, script_RelativedObjs);
                    } else {
                        Class<?> providerCls = Class.forName(cfg.getForwardScript().trim());
                        AbstractTargetReportInfoProvider provider = (AbstractTargetReportInfoProvider)providerCls.newInstance();
                        provider.setInputArgs(execArgs);
                        provider.setInfo(info);
                        provider.process();
                        info = provider.getInfo();
                    }
                    if (info.getTarget() != null) {
                        UIContext uiContext = new UIContext((Object)this);
                        uiContext.put((Object)Eas_KdrsReportUI.UICTX_MainMenuName, (Object)info.getTargetTitle());
                        uiContext.put((Object)"UIClassParam", (Object)Eas_KdrsUtil.buildFullPath(info.getTarget()));
                        uiContext.put((Object)BizContent_ClientExecutor.ARG_HashMap_execArgs, (Object)info.getTargetArgs());
                        if (!info.isTargetNeedCheckPermission()) {
                            uiContext.put((Object)Eas_KdrsReportUI.UICTX_IGNORE_CHECK_PERMISSION, (Object)Boolean.TRUE);
                        }
                        Eas_KdrsReportUI.this.getUIContext().putAll(uiContext);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("uiContext:" + Eas_KdrsReportUI.this.getUIContext()));
                        }
                        Eas_KdrsReportUI.this.openReport(RptOpenMode.NORMAL);
                        return;
                    }
                } else {
                    log.info((Object)("not support,script-type:" + cfg.getForwardScriptType()));
                }
            }
            this.uiObject.getUIWindow().close();
        }

        class ProcessingBoxPanel
        extends KDPanel {
            private KDProgressBar progressBar = new KDProgressBar();

            ProcessingBoxPanel() {
                this.progressBar.setStringPainted(false);
                this.progressBar.setIndeterminate(true);
                KDLabel lblTitle = new KDLabel(EasResource.getString("openingReports"));
                TableLayout layout = TableLayout.split((int)4, (int)3);
                this.setLayout((LayoutManager)layout);
                this.add((Component)lblTitle, layout.cell(1, 1));
                this.add((Component)this.progressBar, layout.cell(2, 1));
                layout.rowStyle(2).setHeight(17);
                layout.colStyle(1).setWidth(380);
                layout.colStyle(1).setAlignmentX((short)4);
                layout.colStyle(0).setPriX(1);
                layout.colStyle(2).setPriX(1);
                layout.rowStyle(0).setPriY(1);
                layout.rowStyle(3).setPriY(1);
            }
        }
    }

    public static class RptOpenMode {
        public static final RptOpenMode NORMAL = new RptOpenMode();
        public static final RptOpenMode REFRESH = new RptOpenMode();
        public static final RptOpenMode REOPEN = new RptOpenMode();

        private RptOpenMode() {
        }
    }
}

