/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs;

import com.kingdee.bos.ctrl.bizshare.AConnection;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.RpcBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;

public class KDRSConnection
extends AConnection {
    private String protocal = "http";
    private String host;
    private String port;
    private String service = "/kdrs";
    private String org;
    private String account;
    private String password;
    private boolean savePassword;
    private String lang = LangUtil.makeDefaultLang();
    private IBizContext context;

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrganization(String organization) {
        this.org = organization;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProtocal() {
        return this.protocal;
    }

    public void setProtocal(String protocal) {
        this.protocal = protocal;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getServiceURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.protocal);
        sb.append("://");
        sb.append(this.host);
        sb.append(":");
        sb.append(this.port);
        if (!StringUtil.isEmptyString((String)this.service)) {
            sb.append(this.service);
        }
        return sb.toString();
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    protected void pureOpen() throws ConnectException {
        RpcBizContext ctx = null;
        if (!"tcp".equalsIgnoreCase(this.getProtocal())) {
            throw new ConnectException(":( Unsupport protocal " + this.getProtocal());
        }
        ctx = new RpcBizContext();
        try {
            ctx.login(this.getServiceURL(), this.getOrg(), this.getAccount(), this.getPassword(), this.getLang());
            this.context = ctx;
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    protected void pureClose() throws ConnectException {
        try {
            this.context.logout();
            this.context = null;
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    public IBizContext getContext() {
        return this.context;
    }
}

