/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ValueAndText;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class ArgInput {
    private static final Logger log = LogUtil.getPackageLogger(ArgInput.class);
    private HashMap args;

    public final void setParameters(List ps) {
        this.args = new HashMap();
        int z = ps.size();
        for (int i = 0; i < z; ++i) {
            Parameter p = (Parameter)ps.get(i);
            this.args.put(p.getName(), p);
        }
    }

    public final HashMap getArgs() {
        Iterator i = this.args.entrySet().iterator();
        while (i.hasNext()) {
            Object val = i.next().getValue();
            if (!(val instanceof Parameter)) continue;
            i.remove();
        }
        return this.args;
    }

    public final void parseComponent(Component comp) {
        Object v;
        String name = comp.getName();
        if (name != null && (v = this.args.get(name)) instanceof Parameter) {
            try {
                Object obj;
                Object val = obj = ArgInput.getArg(comp);
                if (obj instanceof F7ValueObject) {
                    F7ValueObject valueObject = (F7ValueObject)obj;
                    val = valueObject.val;
                    this.args.put(ArgInput.makeValueObjectKey(name), valueObject);
                }
                this.args.put(name, val);
            }
            catch (Exception ex) {
                log.error((Object)("\u83b7\u53d6\u53c2\u6570\u503c\uff08" + name + "\uff09\u5931\u8d25\uff01"), (Throwable)ex);
                this.args.put(name, null);
            }
        }
        if (comp instanceof Container) {
            Container cnt = (Container)comp;
            int z = cnt.getComponentCount();
            for (int i = 0; i < z; ++i) {
                this.parseComponent(cnt.getComponent(i));
            }
        }
    }

    public void bindArgsToComponent(Map vals, Component comp) {
        Object v;
        String name = comp.getName();
        if (name != null && (v = this.args.get(name)) instanceof Parameter) {
            Object val = null;
            if (vals != null) {
                Object valueObject = vals.get(ArgInput.makeValueObjectKey(name));
                val = valueObject == null ? vals.get(name) : valueObject;
            }
            ArgInput.setArg(comp, val);
        }
        if (comp instanceof Container && !(comp instanceof KDPromptBox)) {
            Container cnt = (Container)comp;
            int z = cnt.getComponentCount();
            for (int i = 0; i < z; ++i) {
                this.bindArgsToComponent(vals, cnt.getComponent(i));
            }
        }
    }

    public static void setArg(Component comp, Object val) {
        if (val == null) {
            return;
        }
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText("" + val);
        } else if (comp instanceof JToggleButton) {
            boolean selected;
            boolean bl = selected = val != null;
            if (selected) {
                selected = val.equals(Boolean.TRUE) || "true".equalsIgnoreCase("" + val) || new Integer(1).equals(val);
            }
            ((JToggleButton)comp).setSelected(selected);
        } else if (comp instanceof JComboBox) {
            boolean set = false;
            JComboBox cbx = (JComboBox)comp;
            ComboBoxModel model = cbx.getModel();
            if (model.getSize() > 0 && model.getElementAt(0) instanceof ValueAndText) {
                for (int i = 0; i < model.getSize(); ++i) {
                    ValueAndText vat = (ValueAndText)model.getElementAt(i);
                    if (!CtrlUtil.Obj.equals((Object)vat.getValue(), (Object)val)) continue;
                    cbx.setSelectedIndex(i);
                    set = true;
                    break;
                }
            }
            if (!set) {
                cbx.setSelectedItem(val);
            }
        } else if (comp instanceof JList) {
            boolean set = false;
            JList lst = (JList)comp;
            ListModel model = lst.getModel();
            if (model.getSize() > 0 && model.getElementAt(0) instanceof ValueAndText) {
                for (int i = 0; i < model.getSize(); ++i) {
                    ValueAndText vat = (ValueAndText)model.getElementAt(i);
                    if (!CtrlUtil.Obj.equals((Object)vat.getValue(), (Object)val)) continue;
                    lst.setSelectedIndex(i);
                    set = true;
                    break;
                }
            }
            if (!set) {
                lst.setSelectedValue(val, true);
            }
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker dp = (KDDatePicker)comp;
            if (val instanceof Date) {
                dp.setValue(val);
            } else if (val instanceof String) {
                try {
                    dp.setValue((Object)DateFormat.getDateInstance().parse("" + val));
                }
                catch (ParseException ex) {
                    log.error((Object)"", (Throwable)ex);
                    dp.setValue(null);
                }
            }
        } else if (comp instanceof KDPromptBox) {
            if (val instanceof F7ValueObject) {
                KDBizPromptBox f7 = (KDBizPromptBox)comp;
                f7.setData(((F7ValueObject)val).lVal);
            }
        } else {
            log.error((Object)("unsupport," + comp));
        }
    }

    private static final Object getArg(Component comp) {
        if (comp instanceof JTextComponent) {
            String text = ((JTextComponent)comp).getText();
            if (text == null || text.length() == 0) {
                return null;
            }
            return text;
        }
        if (comp instanceof JSpinner) {
            return ((JSpinner)comp).getValue();
        }
        if (comp instanceof JToggleButton) {
            return ((JToggleButton)comp).isSelected();
        }
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        if (comp instanceof JComboBox) {
            JComboBox cbx = (JComboBox)comp;
            Object item = cbx.getSelectedItem();
            if (item instanceof ValueAndText) {
                return ((ValueAndText)item).getValue();
            }
            if (!cbx.isEditable() || cbx.getSelectedIndex() != -1) {
                return item;
            }
            return ArgInput.getArg(cbx.getEditor().getEditorComponent());
        }
        if (comp instanceof JList) {
            JList lst = (JList)comp;
            Object item = lst.getSelectedValue();
            if (item instanceof ValueAndText) {
                return ((ValueAndText)item).getValue();
            }
            return item;
        }
        if (comp instanceof KDDatePicker) {
            Date val = (Date)((KDDatePicker)comp).getValue();
            if (val == null) {
                return null;
            }
            return DateFormat.getDateInstance().format(val);
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox f7 = (KDBizPromptBox)comp;
            F7ValueObject valObj = new F7ValueObject(f7.getUserData(), f7.getData());
            return valObj;
        }
        return null;
    }

    private static final String makeValueObjectKey(String param_name) {
        return F7ValueObject.class.getName() + "$" + param_name;
    }

    public final void parseComponent(Component comp, HashMap args) {
        Object obj;
        String name = comp.getName();
        if (name != null && name.length() > 0 && (obj = ArgInput.getArg(comp)) != null) {
            if (obj instanceof F7ValueObject) {
                obj = ((F7ValueObject)obj).val;
            }
            args.put(name, obj);
        }
        if (comp instanceof Container) {
            Container cnt = (Container)comp;
            int z = cnt.getComponentCount();
            for (int i = 0; i < z; ++i) {
                this.parseComponent(cnt.getComponent(i), args);
            }
        }
    }

    public static class F7ValueObject
    implements Serializable {
        public Object val;
        public Object lVal;

        public F7ValueObject(Object val, Object lVal) {
            this.val = val;
            this.lVal = lVal;
        }
    }
}

