/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.tree.DefaultNodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ProgressBar;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ICopyBetweenStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.Component;
import org.apache.log4j.Logger;

public class ImportExportUtil {
    private static final Logger log = LogUtil.getPackageLogger(ImportExportUtil.class);
    private static DefaultNodeFilter invisibleFileFilter = null;
    private static boolean return_copyWithUI;

    public static DefaultNodeFilter getInvisibleFileFilter() {
        if (invisibleFileFilter == null) {
            invisibleFileFilter = new DefaultNodeFilter(null, new Object[]{StorageCategory.FILE});
        }
        return invisibleFileFilter;
    }

    public static boolean copyWithUI(final ICopyBetweenStorage m, final TreeUINode tnFrom, final Component owner, final String title) {
        final ProgressBar bar = (ProgressBar)((Object)WindowUtil.createWindow(ProgressBar.class, (Component)owner));
        bar.setTitle(title);
        new Thread(new Runnable(){

            @Override
            public void run() {
                CopyWithTree cwt = new CopyWithTree(m.getFromStorage(), m.getToStorage(), new BizStorageUtil.PromptExist(owner, title), bar);
                try {
                    cwt.copy("/", m.getToPath(), tnFrom);
                    WindowUtil.msgboxInfo((Object)(title + ClientResource.getString("res_155")), (String)title, (Component)owner);
                    return_copyWithUI = true;
                }
                catch (KDRSException ex) {
                    log.error((Object)(title + ClientResource.getString("res_156")), (Throwable)ex);
                    WindowUtil.showException((String)(title + ClientResource.getString("res_156")), (Throwable)ex, (String)title, (Component)owner);
                    return_copyWithUI = false;
                }
                bar.finished();
            }
        }).start();
        bar.show();
        return return_copyWithUI;
    }

    public static boolean importWithUI(ICopyBetweenStorage m, TreeUINode tnFrom, Component owner) {
        return ImportExportUtil.copyWithUI(m, tnFrom, owner, ClientResource.getString("res_157"));
    }

    public static boolean exportWithUI(ICopyBetweenStorage m, TreeUINode tnFrom, Component owner) {
        return ImportExportUtil.copyWithUI(m, tnFrom, owner, ClientResource.getString("res_158"));
    }

    private static class CopyWithTree {
        private IBizStorage fromStorage;
        private IBizStorage toStorage;
        private BizStorageUtil.IResourceCreator creator;
        private ProgressBar progressBar;

        public CopyWithTree(IBizStorage fromSto, IBizStorage toSto, BizStorageUtil.IResourceCreator creator, ProgressBar bar) {
            this.fromStorage = fromSto;
            this.toStorage = toSto;
            this.creator = creator;
            this.progressBar = bar;
        }

        public void copy(String fromPath, String toPath, TreeUINode tnFrom) throws KDRSException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("copyWithTree " + tnFrom));
            }
            if (this.progressBar != null) {
                this.progressBar.addLine(tnFrom.toString());
            }
            if (tnFrom.getAllowsChildren() && !tnFrom.isChildrenLoaded()) {
                BizStorageUtil.copyFolder(this.fromStorage, fromPath, this.toStorage, toPath, BizStorageUtil.OVERWRITE_EXIST);
                return;
            }
            if (tnFrom.isLeaf()) {
                BizStorageUtil.copyFile(this.fromStorage, fromPath, this.toStorage, toPath);
            } else {
                int j = tnFrom.getChildCount();
                for (int i = 0; i < j; ++i) {
                    TreeUINode tnChild = (TreeUINode)tnFrom.getChildAt(i);
                    if (tnChild.getCheckedValue() == 16) continue;
                    String childName = tnChild.getName();
                    String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
                    String toChild = PathUtil.makeChildPath((String)toPath, (String)childName);
                    this.creator.create(this.fromStorage, fromChild, this.toStorage, toChild);
                    this.copy(fromChild, toChild, tnChild);
                }
            }
        }
    }
}

