/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class Path
implements Serializable,
Comparable {
    private static Logger log = LogUtil.getPackageLogger(Path.class);
    public static final char SPLIT_CHAR = '/';
    public static final String ROOT_PATH_TEXT = "/";
    public static final String INVALID_CHARS = "\\:*?\"<>|";
    public static final Path ROOT = new Path("/", false);
    private String pathText;
    private int lastSplitCharIdx = -1;
    private int deep = 0;

    public final boolean isRoot() {
        return this.lastSplitCharIdx == -1;
    }

    public final int deep() {
        return this.deep;
    }

    public static final Path valueOf(String pathText) {
        try {
            return new Path(pathText, true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final boolean isSimpleName(String s) {
        return s != null && s.indexOf(47) == -1;
    }

    private Path(String text, boolean checkValid) {
        if (text != null) {
            this.pathText = text;
            if (text.length() == 1 && text.equals(ROOT_PATH_TEXT)) {
                return;
            }
            if (!checkValid || Path.isValidPath(text)) {
                this.lastSplitCharIdx = text.lastIndexOf(47);
                for (int i = 0; i < text.length(); ++i) {
                    this.deep += text.charAt(i) == '/' ? 1 : 0;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Bad path text '" + text + "'");
    }

    private static final Path _valueOf(String pathText) {
        return new Path(pathText, false);
    }

    public final String getPathText() {
        return this.pathText;
    }

    public final Path getBrother(String brotherName) {
        String t = this.getBrotherPathText(brotherName);
        if (t == null) {
            return null;
        }
        Path path = Path._valueOf(t);
        path.deep = this.deep;
        return path;
    }

    private final String getBrotherPathText(String brotherName) {
        if (this.isRoot()) {
            return null;
        }
        if (!Path.isValidPath('/' + brotherName)) {
            return null;
        }
        return this.pathText.substring(0, this.lastSplitCharIdx + 1) + brotherName;
    }

    public final Path getChild(String childName) {
        String t = this.getChildPathText(childName);
        if (t == null) {
            log.info((Object)("Bad child name '" + childName + "' for " + this.toString()));
            return null;
        }
        Path path = Path._valueOf(t);
        path.deep = this.deep + 1;
        return path;
    }

    public final Path makeAbsolutePath(Path relative) {
        if (this.isRoot()) {
            return relative;
        }
        return Path._valueOf(this.pathText + relative.pathText);
    }

    private final String getChildPathText(String childName) {
        String t = '/' + childName;
        if (!Path.isValidPath(t)) {
            return null;
        }
        if (this.isRoot()) {
            return t;
        }
        return this.pathText + t;
    }

    public final String getName() {
        if (this.isRoot()) {
            return "";
        }
        return this.pathText.substring(this.lastSplitCharIdx + 1);
    }

    public final Path getParent() {
        String t = this.getParentPathText();
        if (t == null) {
            return null;
        }
        if (t.length() == 0) {
            return ROOT;
        }
        Path path = Path._valueOf(t);
        path.deep = this.deep - 1;
        return path;
    }

    private final String getParentPathText() {
        if (this.isRoot()) {
            return null;
        }
        return this.pathText.substring(0, this.lastSplitCharIdx);
    }

    public static final Path contact(Path path1, Path path2) {
        if (path1.isRoot()) {
            return path2;
        }
        if (path2.isRoot()) {
            return path1;
        }
        return new Path(path1.pathText + path2.pathText, false);
    }

    public static final boolean isValidPath(String p) {
        boolean valid;
        boolean bl = valid = p.length() > 0 && p.charAt(0) == '/';
        if (valid) {
            if (p.length() > 1 && p.charAt(p.length() - 1) == '/') {
                return false;
            }
            for (int i = 1; i < p.length(); ++i) {
                if (INVALID_CHARS.indexOf(p.charAt(i)) != -1) {
                    return false;
                }
                if (p.charAt(i) != '/' || p.charAt(i - 1) != '/') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.pathText;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof Path && ((Path)obj).pathText.equalsIgnoreCase(this.pathText);
    }

    public final Path[] paths() {
        Path[] paths = new Path[this.deep + 1];
        int i = paths.length - 1;
        for (Path path = this; path != null; path = path.getParent()) {
            paths[i--] = path;
        }
        return paths;
    }

    public final boolean isFatherOf(Path path2, boolean direct) {
        String ptLower;
        if (this.isRoot()) {
            if (direct) {
                return path2.deep == 1;
            }
            return path2.deep != this.deep;
        }
        String pt2Lower = path2.pathText.toLowerCase();
        if (pt2Lower.startsWith((ptLower = this.pathText.toLowerCase()) + '/')) {
            return !direct || -1 == pt2Lower.indexOf(47, 1 + this.pathText.length());
        }
        return false;
    }

    public int hashCode() {
        return this.pathText.hashCode();
    }

    public int compareTo(Object o) {
        return this.pathText.compareTo((String)o);
    }
}

