/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BosBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.LocalCachedBizContentProxy;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizRpcReducer {
    private static final Logger log = LogUtil.getPackageLogger(BizRpcReducer.class);
    public static final String Clazz_Content = "IBizContent";
    public static final String Method_List2 = "IBizContent.list2";
    public static final String Method_GetAttributes = "IBizContent.getAttributes";
    public static final String Special_Login = "login";
    public static final String Special_FileVer = "Special.fileVer";
    public static final String Special_Template = "template";
    public static final Map ParamsType = new HashMap();
    private Map _batchRecords = new HashMap();
    private IContextSupplier _contextSupplier;
    public static String SameVersion;

    public static String[] decodeKey(String key) {
        int idxSeparator = key.indexOf(".");
        if (idxSeparator < 0) {
            throw new IllegalArgumentException("Invalid key.");
        }
        String[] result = new String[]{key.substring(0, idxSeparator), key.substring(idxSeparator + 1)};
        return result;
    }

    private static boolean isContainsParamsValue(Map map, Object[] paramsValue) {
        boolean isParamsValueExist = false;
        for (Object[] psV : map.keySet()) {
            if (!BizRpcReducer.compareParamsValue(psV, paramsValue)) continue;
            isParamsValueExist = true;
            break;
        }
        return isParamsValueExist;
    }

    private static Object getMethodResult(Map map, Object[] paramsValue) throws KDRSException {
        for (Object[] psV : map.keySet()) {
            if (!BizRpcReducer.compareParamsValue(psV, paramsValue)) continue;
            Object result = map.get(psV);
            if (result instanceof KDRSException) {
                throw (KDRSException)result;
            }
            return result;
        }
        return null;
    }

    private static boolean compareParamsValue(Object[] pv1, Object[] pv2) {
        if (pv1 == null) {
            return pv2 == null;
        }
        if (pv2 == null) {
            return false;
        }
        if (pv1.length != pv2.length) {
            return false;
        }
        for (int i = 0; i < pv1.length; ++i) {
            if (!(pv1[i] == null ? pv2[i] != null : (pv1[i] instanceof Object[] && pv2[i] instanceof Object[] ? !BizRpcReducer.compareParamsValue((Object[])pv1[i], (Object[])pv2[i]) : !pv1[i].equals(pv2[i])))) continue;
            return false;
        }
        return true;
    }

    private static void addSessionInfo(Map map, BosBizContext ctx) {
        String sessionId = ctx.getSesstion().getSid();
        map.put(Special_Login, sessionId);
    }

    public BizRpcReducer(IContextSupplier contextSupplier) {
        this._contextSupplier = contextSupplier;
    }

    private IBizContext getContext() {
        return this._contextSupplier.getContext();
    }

    public Map getBatchRecords() {
        return this._batchRecords;
    }

    public void setBatchRecords(Map map) {
        this._batchRecords = map;
    }

    public void clearBatch() {
        this._batchRecords.clear();
    }

    public void putBatchMethod(String method, Object[] paramsValue) {
        HashMap<Object[], Object> paramss = (HashMap<Object[], Object>)this._batchRecords.get(method);
        if (paramss == null) {
            paramss = new HashMap<Object[], Object>();
            this._batchRecords.put(method, paramss);
        }
        if (!BizRpcReducer.isContainsParamsValue(paramss, paramsValue)) {
            paramss.put(paramsValue, null);
        }
    }

    public void batchCall() {
        if (this.getContext() instanceof BosBizContext) {
            BizRpcReducer.addSessionInfo(this._batchRecords, (BosBizContext)this.getContext());
            try {
                this._batchRecords = ((BosBizContext)this.getContext()).batchCall(this._batchRecords);
            }
            catch (KDRSException e) {
                log.error((Object)"batchCall error.", (Throwable)e);
            }
        }
    }

    public Object getBatchResult(String method, Object[] paramsValue) throws KDRSException {
        log.info((Object)BizRpcReducer.getLogInfo(method, paramsValue));
        Map paramss = (Map)this._batchRecords.get(method);
        if (paramss != null && BizRpcReducer.isContainsParamsValue(paramss, paramsValue)) {
            log.info((Object)"Found BatchResult, get it.");
            return BizRpcReducer.getMethodResult(paramss, paramsValue);
        }
        if (this.getContext() instanceof BosBizContext) {
            log.info((Object)"Not found BatchResult. Use 'batchCall' method getting result...");
            Map<Object, Object> dirCallResult = new HashMap<Object[], Object>();
            dirCallResult.put(paramsValue, null);
            Map dirCall = new HashMap<String, HashMap<Object[], Object>>();
            dirCall.put(method, dirCallResult);
            BizRpcReducer.addSessionInfo(dirCall, (BosBizContext)this.getContext());
            dirCall = ((BosBizContext)this.getContext()).batchCall(dirCall);
            dirCallResult = (Map)dirCall.get(method);
            return BizRpcReducer.getMethodResult(dirCallResult, paramsValue);
        }
        Class[] paramsType = (Class[])ParamsType.get(method);
        String[] keys = BizRpcReducer.decodeKey(method);
        Object obj = null;
        if (Clazz_Content.equals(keys[0])) {
            obj = this.getContext().getBizContent();
        }
        try {
            return obj.getClass().getMethod(keys[1], paramsType).invoke(obj, paramsValue);
        }
        catch (Exception ex) {
            throw KDRSException.makeException(ex);
        }
    }

    private static String getLogInfo(String method, Object[] paramsValue) {
        StringBuffer sb = new StringBuffer("getBatchResult(");
        sb.append(method);
        sb.append(", {");
        for (int i = 0; i < paramsValue.length; ++i) {
            int idx;
            if (i > 0) {
                sb.append(", ");
            }
            if (paramsValue[i] instanceof Map) {
                sb.append("Map{");
                idx = 0;
                for (Object key : ((Map)paramsValue[i]).keySet()) {
                    if (idx++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                }
                continue;
            }
            if (paramsValue[i] instanceof String[]) {
                sb.append("String[]{");
                for (idx = 0; idx < ((String[])paramsValue[i]).length; ++idx) {
                    if (idx > 0) {
                        sb.append(", ");
                    }
                    sb.append(((String[])paramsValue[i])[idx]);
                }
                continue;
            }
            sb.append(paramsValue[i]);
        }
        sb.append("})");
        return sb.toString();
    }

    public Object getSpecial(String key) throws KDRSException {
        Object result = this.getBatchRecords().get(key);
        if (result instanceof KDRSException) {
            throw (KDRSException)result;
        }
        return result;
    }

    public byte[] readTemplate(IBizStorage localBizSto, String templatePath) throws KDRSException {
        byte[] content;
        Object data = this.getSpecial(Special_Template);
        if (data == null) {
            log.info((Object)("RpcReducer read template from traditional way." + templatePath));
            content = this.getContext().getBizContent().readTemplate(templatePath);
        } else if (SameVersion.equals(data)) {
            log.info((Object)("RpcReducer read template from local cache." + templatePath));
            content = BizRpcReducer.readTemplateFromLocal(localBizSto, templatePath);
        } else {
            content = (byte[])data;
            log.info((Object)("RpcReducer read template from batch result." + templatePath));
            String fileVer = (String)this.getSpecial(Special_FileVer);
            long r_lastModified = fileVer == null ? -1L : Long.parseLong(fileVer);
            try {
                localBizSto.writeFile(templatePath, -1, content);
                LocalCachedBizContentProxy.setLocalFileLastModified(localBizSto, templatePath, r_lastModified);
            }
            catch (KDRSException ex) {
                log.error((Object)"Write local cached error.", (Throwable)ex);
            }
        }
        return content;
    }

    public static String getComparingVer(IBizStorage localBizSto, String templatePath) throws KDRSException {
        String fileVer = null;
        String localTemplatePath = templatePath;
        for (int time = 0; time < 2; ++time) {
            try {
                if (!localBizSto.isAtomic(localTemplatePath)) {
                    localTemplatePath = localTemplatePath + "/template";
                }
                fileVer = (String)BizStorageUtil.getAttribute(localBizSto, localTemplatePath, LocalCachedBizContentProxy.ATTR_EX_REMOTE_LASTMODIFIED);
                continue;
            }
            catch (NotFoundException ex) {
                HashMap attrs = (HashMap)BizStorageUtil.SET_FILE_TYPE.clone();
                attrs.put("create_policy", String.valueOf(2));
                localBizSto.create(templatePath, attrs);
            }
        }
        return fileVer;
    }

    private static byte[] readTemplateFromLocal(IBizStorage localBizSto, String templatePath) throws KDRSException {
        String localTemplatePath = templatePath;
        if (!localBizSto.isAtomic(localTemplatePath)) {
            localTemplatePath = localTemplatePath + "/template";
        }
        KDRSException kdrsException = null;
        byte[] data = null;
        try {
            data = BizStorageUtil.readFile(localBizSto, localTemplatePath);
        }
        catch (KDRSException e) {
            kdrsException = e;
        }
        if (kdrsException != null) {
            throw kdrsException;
        }
        return data;
    }

    static {
        ParamsType.put(Method_List2, new Class[]{String.class, HashMap.class});
        ParamsType.put(Method_GetAttributes, new Class[]{String.class, String[].class});
        SameVersion = "same version";
    }
}

