/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.common.util.IntIDMaker;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControlTable;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Privilege;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Rule;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.UserGroup;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.CircularReferenceException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UnsupportedOperationException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SecurityInfo {
    public static final int OBJECT_USER = 0;
    public static final int OBJECT_USERGROUP = 1;
    public static final int OBJECT_PRIVILEGE = 2;
    public static final int OBJECT_AC = 3;
    public static final int OBJECT_RULE = 4;
    private final IntIDMaker userIdMaker = new IntIDMaker();
    private final IntIDMaker privilegeIdMaker = new IntIDMaker();
    private final IntIDMaker acIdMaker = new IntIDMaker();
    private final IntIDMaker ruleIdMaker = new IntIDMaker();
    private HashMap users = new HashMap();
    private HashMap privileges = new HashMap();
    private HashMap rules = new HashMap();
    private AccessControlTable acTable = new AccessControlTable();

    public final HashMap getPrivileges() {
        return this.privileges;
    }

    public final void setPrivileges(HashMap h) {
        this.privileges = h;
        this.markIDsUsed(this.privilegeIdMaker, h.values().iterator());
    }

    public final HashMap getRules() {
        return this.rules;
    }

    public final void setRules(HashMap h) {
        this.rules = h;
        this.markIDsUsed(this.ruleIdMaker, h.values().iterator());
    }

    public final HashMap getUsers() {
        return this.users;
    }

    public final void setUsers(HashMap h) {
        this.users = h;
        this.markIDsUsed(this.userIdMaker, h.values().iterator());
    }

    public final AccessControlTable getAcTable() {
        return this.acTable;
    }

    public final void setAcTable(AccessControlTable t) {
        this.acTable = t;
        this.markIDsUsed(this.acIdMaker, t.iterator());
    }

    private final void markIDsUsed(IntIDMaker idMaker, Iterator i) {
        idMaker.clear();
        while (i.hasNext()) {
            idMaker.markUsed(((SecObject)i.next()).getId());
        }
    }

    public final void deleteObject(int o, int id) throws KDRSException {
        this.deleteObject(this.checkObject(o, id));
    }

    public final void deleteObject(SecObject obj) throws KDRSException {
        if (obj instanceof User) {
            this.deleteUser((User)obj);
        } else if (obj instanceof Rule) {
            this.deleteRule((Rule)obj);
        }
    }

    private final void deleteUser(User user) throws KDRSException {
        for (Rule o : this.rules.values()) {
            o.removeACByPrincipal(user.getId());
        }
        if (user instanceof UserGroup) {
            ((UserGroup)user).clearMembers();
        }
        SecObject[] objs = this.checkObjects(0, StringUtil.str2IntArray((String)user.getGroups(), (String)","));
        for (int k = 0; k < objs.length; ++k) {
            ((UserGroup)objs[k]).removeMember(user);
        }
        this.users.remove(new Integer(user.getId()));
    }

    private final void deleteRule(Rule rule) throws KDRSException {
        rule.removeRef();
        if (rule.getRefs() == 0) {
            rule.setACs(null);
            this.ruleIdMaker.free(rule.getId());
            this.rules.remove(new Integer(rule.getId()));
        }
    }

    public final HashMap listObjects(int o, String[] attrNames) throws KDRSException {
        HashMap data = this.checkObjectType(o);
        if (o == 0 || o == 1) {
            HashMap temp = new HashMap();
            Iterator keys = data.keySet().iterator();
            Iterator vals = data.values().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                User user = (User)vals.next();
                if (o == 0) {
                    if (user instanceof UserGroup) continue;
                    temp.put(key, user);
                    continue;
                }
                if (!(user instanceof UserGroup)) continue;
                temp.put(key, user);
            }
            data = temp;
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (int i = 0; i < attrNames.length; ++i) {
            r.put(attrNames[i], new ArrayList());
        }
        Iterator ids = data.keySet().iterator();
        while (ids.hasNext()) {
            int id = (Integer)ids.next();
            HashMap tempR = this.getObjectInfo(o, id, attrNames);
            for (int i = 0; i < attrNames.length; ++i) {
                ((ArrayList)r.get(attrNames[i])).add(tempR.get(attrNames[i]));
            }
        }
        for (int i = 0; i < attrNames.length; ++i) {
            ArrayList al = (ArrayList)r.get(attrNames[i]);
            String[] vals = new String[al.size()];
            al.toArray(vals);
            r.put(attrNames[i], vals);
        }
        return r;
    }

    public final void setObjectInfo(int o, int id, HashMap h) throws KDRSException {
        SecObject secObject;
        SecObject obj = this.checkObject(o, id);
        String str = (String)h.remove("id");
        if (str != null && !str.equals(String.valueOf(id))) {
            throw new UnsupportedOperationException("Couldn't change object's id property.");
        }
        str = (String)h.remove("builtin");
        if (str != null && obj.isBuiltIn() != Boolean.getBoolean(str)) {
            throw new UnsupportedOperationException("Couldn't change object's builtin property.");
        }
        str = (String)h.get("name");
        if (str != null && (secObject = this.getObjectByName(o, str)) != obj) {
            if (obj.isBuiltIn()) {
                throw new UnsupportedOperationException("Couldn't rename this type of object.");
            }
            if (secObject != null) {
                throw new AlreadyExistsException("Specified object has already existed!");
            }
        }
        if (o == 0 || o == 1) {
            this.setUserExInfo((User)obj, h);
        } else if (o == 4) {
            this.setRuleContent((Rule)obj, h);
        }
    }

    public final HashMap getObjectInfo(SecObject obj, String[] attrNames) throws KDRSException {
        HashMap<String, String> h = new HashMap<String, String>();
        HashMap properties = obj.getProperties();
        for (int i = 0; i < attrNames.length; ++i) {
            h.put(attrNames[i], (String)(properties == null ? null : (Object)properties.get(attrNames[i])));
        }
        if (ArrayUtil.containElement((Object[])attrNames, (Object)"id")) {
            h.put("id", "" + obj.getId());
        }
        if (ArrayUtil.containElement((Object[])attrNames, (Object)"builtin")) {
            h.put("builtin", "" + obj.isBuiltIn());
        }
        if (obj instanceof User) {
            h.putAll(this.getUserExInfo((User)obj, attrNames));
        } else if (obj instanceof Rule) {
            h.putAll(this.getRuleContent((Rule)obj));
        }
        return h;
    }

    public final HashMap getObjectInfo(int o, int id, String[] attrNames) throws KDRSException {
        return this.getObjectInfo(this.checkObject(o, id), attrNames);
    }

    private final HashMap getRuleContent(Rule rule) throws KDRSException {
        HashMap<String, String> h = new HashMap<String, String>();
        AccessControl[] acs = rule.getACsCopy();
        if (acs != null) {
            for (int i = 0; i < acs.length; ++i) {
                h.put("" + acs[i].getPrincipalId(), acs[i].getPrivilegeIds());
            }
        }
        return h;
    }

    private final void setRuleContent(Rule rule, HashMap h) throws KDRSException {
        ArrayList<AccessControl> acs = new ArrayList<AccessControl>();
        Iterator principal_i = h.keySet().iterator();
        Iterator privileges_i = h.values().iterator();
        while (principal_i.hasNext()) {
            try {
                int principal = -1;
                try {
                    principal = Integer.parseInt((String)principal_i.next());
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                int[] privileges = StringUtil.str2IntArray((String)((String)privileges_i.next()), (String)",");
                User user = (User)this.checkObject(0, principal);
                this.checkObjects(2, privileges);
                AccessControl ac = this.acTable.findPeer(principal, privileges);
                if (ac == null) {
                    ac = new AccessControl(this.acIdMaker.next(), principal, privileges);
                    ac.setContainer(this.acTable);
                    ac.setPrincipal(user);
                }
                acs.add(ac);
            }
            catch (Exception ex) {
                if (ex instanceof NumberFormatException) {
                    throw new InvalidParameterException("Invalid parameters.");
                }
                throw KDRSException.makeException(ex);
            }
        }
        AccessControl[] acs2 = new AccessControl[acs.size()];
        acs.toArray(acs2);
        rule.setACs(acs2);
    }

    private final HashMap getUserExInfo(User obj, String[] attrNames) throws KDRSException {
        HashMap<String, String> h = new HashMap<String, String>();
        if (obj instanceof User && ArrayUtil.containElement((Object[])attrNames, (Object)"usergroups")) {
            h.put("usergroups", obj.getGroups());
        }
        if (obj instanceof UserGroup && ArrayUtil.containElement((Object[])attrNames, (Object)"members")) {
            h.put("members", ((UserGroup)obj).getMembers());
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setUserExInfo(User user, HashMap h) throws KDRSException {
        if (h.containsKey("members") && h.containsKey("usergroups")) {
            throw new InvalidParameterException("Couldn't support set MEMBERS and USERGROUPS properties at the same time.");
        }
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            Object[] t;
            ArrayList list;
            String str;
            if (user instanceof UserGroup && (str = (String)h.remove("members")) != null && !((UserGroup)user).setMembers(list = ArrayUtil.objects2ArrayList((Object[])(t = this.checkObjects(0, StringUtil.str2IntArray((String)str, (String)",")))))) {
                throw new CircularReferenceException("users/usergroups nested.");
            }
            str = (String)h.remove("usergroups");
            if (str != null) {
                SecObject[] list2 = this.checkObjects(0, StringUtil.str2IntArray((String)str, (String)","));
                UserGroup[] joinedGroups = new UserGroup[list2.length];
                for (int i = 0; i < joinedGroups.length; ++i) {
                    UserGroup joined = (UserGroup)list2[i];
                    if (joined.containMember(user, true)) continue;
                    if (!joined.addMember(user)) {
                        for (int j = 0; j < i; ++j) {
                            if (joinedGroups[j] == null) continue;
                            joinedGroups[j].removeMember(user);
                        }
                        throw new CircularReferenceException("users/usergroups nested.");
                    }
                    joinedGroups[i] = joined;
                }
            }
            user.getProperties().putAll(h);
        }
    }

    public final SecObject createObject(int o, HashMap h) throws KDRSException {
        HashMap data = this.checkObjectType(o);
        IntIDMaker idMaker = this.getIDMaker(o);
        SecObject obj = null;
        try {
            switch (o) {
                case 0: 
                case 1: {
                    if (0 == o) {
                        obj = new User(idMaker.next(), this.users);
                        break;
                    }
                    obj = new UserGroup(idMaker.next(), this.users);
                    break;
                }
                case 4: {
                    obj = new Rule(idMaker.next());
                    break;
                }
                default: {
                    throw new UnsupportedTypeException("Unkown object type(" + o + ")");
                }
            }
            data.put(new Integer(obj.getId()), obj);
            this.setObjectInfo(o, obj.getId(), h);
            return obj;
        }
        catch (Exception ex) {
            idMaker.free(obj.getId());
            data.remove(new Integer(obj.getId()));
            throw KDRSException.makeException(ex);
        }
    }

    public final User getUserByName(String name) throws KDRSException {
        return (User)this.getObjectByName(0, name);
    }

    public final SecObject getObjectByName(int o, String name) throws KDRSException {
        HashMap data = this.checkObjectType(o);
        for (SecObject secObject : data.values()) {
            String objName = (String)secObject.getProperties().get("name");
            if (!name.equalsIgnoreCase(objName)) continue;
            return secObject;
        }
        return null;
    }

    private final HashMap checkObjectType(int o) throws KDRSException {
        switch (o) {
            case 0: 
            case 1: {
                return this.users;
            }
            case 2: {
                return this.privileges;
            }
            case 4: {
                return this.rules;
            }
        }
        throw new UnsupportedTypeException("Unkown object type(" + o + ")");
    }

    private final IntIDMaker getIDMaker(int o) throws KDRSException {
        switch (o) {
            case 0: 
            case 1: {
                return this.userIdMaker;
            }
            case 4: {
                return this.ruleIdMaker;
            }
            case 3: {
                return this.acIdMaker;
            }
        }
        throw new UnsupportedTypeException("Unkown object type(" + o + ")");
    }

    private final SecObject checkObject(int o, int id) throws KDRSException {
        SecObject secObj = null;
        Integer key = new Integer(id);
        switch (o) {
            case 0: 
            case 1: {
                secObj = (SecObject)this.users.get(key);
                break;
            }
            case 2: {
                secObj = (SecObject)this.privileges.get(key);
                break;
            }
            case 3: {
                secObj = this.acTable.getAccessControl(id);
                break;
            }
            case 4: {
                secObj = (SecObject)this.rules.get(key);
            }
        }
        if (secObj == null) {
            throw new NotFoundException("Couldn't find object by id '" + id + "'");
        }
        return secObj;
    }

    private SecObject[] checkObjects(int o, int[] ids) throws KDRSException {
        SecObject[] objs = new SecObject[ids.length];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.checkObject(o, ids[i]);
        }
        return objs;
    }

    public final Privilege getPrivilegeByName(String name) {
        try {
            return (Privilege)this.getObjectByName(2, name);
        }
        catch (KDRSException ex) {
            return null;
        }
    }
}

