/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Privilege;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.refable.IRefableObject;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.refable.IRefableObjectContainer;

public class Rule
extends SecObject
implements IRefableObject {
    private AccessControl[] acs;
    private int[] acIds;
    private int refs = 1;

    public Rule() {
    }

    public Rule(int id) {
        super(id);
    }

    public boolean doPrivilege(User user, Privilege privilege) {
        if (this.acs == null) {
            return false;
        }
        for (int i = 0; i < this.acs.length; ++i) {
            if (!this.acs[i].doPrivilege(user, privilege)) continue;
            return true;
        }
        return false;
    }

    public void setACs(AccessControl[] newAcs) {
        int i;
        this.acIds = null;
        AccessControl[] old = this.acs;
        this.acs = newAcs;
        if (newAcs != null) {
            for (i = 0; i < newAcs.length; ++i) {
                newAcs[i].addRef();
            }
        }
        if (old != null) {
            for (i = 0; i < old.length; ++i) {
                old[i].removeRef();
            }
        }
    }

    public void setACIdList(String acIdList) {
        this.acIds = StringUtil.str2IntArray((String)acIdList, (String)",");
        this.acs = null;
    }

    public int[] getACs() {
        if (this.acIds != null) {
            return this.acIds;
        }
        if (this.acs != null) {
            int[] t = new int[this.acs.length];
            for (int i = 0; i < t.length; ++i) {
                t[i] = this.acs[i].getId();
            }
            return t;
        }
        return new int[0];
    }

    public AccessControl[] getACsCopy() {
        if (this.acs == null) {
            return new AccessControl[0];
        }
        AccessControl[] t = new AccessControl[this.acs.length];
        System.arraycopy(this.acs, 0, t, 0, t.length);
        return t;
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    public boolean removeACByPrincipal(int principal) {
        if (this.acIds != null) {
            int[] newIds = ArrayUtil.removeUniqueElement((int[])this.acIds, (int)principal);
            if (newIds.length != this.acIds.length) {
                this.acIds = newIds;
                return true;
            }
        } else if (this.acs != null) {
            int index = -1;
            for (int i = 0; i < this.acs.length; ++i) {
                if (this.acs[i].getPrincipalId() != principal) continue;
                index = i;
                break;
            }
            if (index != -1) {
                AccessControl[] newAcs = (AccessControl[])ArrayUtil.removeElement((Object[])this.acs, (Object)this.acs[index]);
                this.setACs(newAcs);
            }
        }
        return false;
    }

    @Override
    public void addRef() {
        ++this.refs;
    }

    @Override
    public int getRefs() {
        return this.refs;
    }

    @Override
    public void removeRef() {
        --this.refs;
    }

    @Override
    public void setContainer(IRefableObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

