/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.SecurityInfo;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.AccessControlTable;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Rule;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.SecObj2Xml;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.User;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.UserGroup;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.objects.Xml2SecObj;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom2.Content;
import org.jdom2.Element;

public class SecurityInfoIO {
    public static HashMap loadPrivileges(InputStream i) throws Exception {
        Element e = XmlUtil.loadXmlStream((InputStream)i);
        return Xml2SecObj.loadPrivileges(e);
    }

    public static void loadACL(InputStream in, AccessControlTable table, HashMap rules) throws Exception {
        Element e = XmlUtil.loadXmlStream((InputStream)in);
        HashMap<Integer, AccessControl> pureACs = new HashMap<Integer, AccessControl>();
        HashMap r = Xml2SecObj.loadACTable(e.getChild("ACs"));
        for (AccessControl ac : r.values()) {
            ac.setContainer(table);
            pureACs.put(new Integer(ac.getId()), ac);
        }
        r = Xml2SecObj.loadRules(e.getChild("Rules"));
        for (Rule rule : r.values()) {
            int[] acIds = rule.getACs();
            AccessControl[] acs = new AccessControl[acIds.length];
            for (int k = 0; k < acs.length; ++k) {
                acs[k] = (AccessControl)pureACs.get(new Integer(acIds[k]));
            }
            rule.setACs(acs);
        }
        rules.putAll(r);
    }

    public static void saveUsers(SecurityInfo si, String file) throws IOException {
        Element e = SecObj2Xml.users2XML(si.getUsers().values().iterator());
        XmlUtil.saveXmlFile((String)file, (Element)e);
    }

    public static HashMap loadUsers(Element e) throws Exception {
        HashMap r = Xml2SecObj.loadUsers(e);
        for (User user : r.values()) {
            String memberIds;
            if (!(user instanceof UserGroup) || (memberIds = (String)user.getProperties().remove("members")) == null || memberIds.length() <= 0) continue;
            String[] members = memberIds.split(",");
            for (int i = 0; i < members.length; ++i) {
                User u = (User)r.get(Integer.valueOf(members[i]));
                ((UserGroup)user).addMember(u);
            }
        }
        if (SecurityInfoIO.checkUsersCycle(r)) {
            return r;
        }
        throw new Exception("Cycle include users/usergroups.");
    }

    public static HashMap loadUsers(InputStream i) throws Exception {
        return SecurityInfoIO.loadUsers(XmlUtil.loadXmlStream((InputStream)i));
    }

    public static SecurityInfo load(InputStream usersFile, InputStream privilegesFile, InputStream aclFile) {
        try {
            SecurityInfo si = new SecurityInfo();
            if (usersFile != null) {
                si.setUsers(SecurityInfoIO.loadUsers(usersFile));
            }
            if (privilegesFile != null) {
                si.setPrivileges(SecurityInfoIO.loadPrivileges(privilegesFile));
            }
            if (aclFile != null) {
                AccessControlTable acTable = new AccessControlTable();
                HashMap rules = new HashMap();
                SecurityInfoIO.loadACL(aclFile, acTable, rules);
                si.setAcTable(acTable);
                si.setRules(rules);
                HashMap users = si.getUsers();
                if (users != null) {
                    Iterator acs = acTable.iterator();
                    while (acs.hasNext()) {
                        AccessControl ac = (AccessControl)acs.next();
                        ac.setPrincipal((User)users.get(new Integer(ac.getPrincipalId())));
                    }
                }
            }
            return si;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void savePrivileges(SecurityInfo si, String file) throws IOException {
        Element e = SecObj2Xml.privileges2XML(si.getPrivileges().values().iterator());
        XmlUtil.saveXmlFile((String)file, (Element)e);
    }

    public static void saveACL(SecurityInfo si, String file) throws IOException {
        Element eROOT = new Element("ACL");
        Element e = SecObj2Xml.accessControls2XML(si.getAcTable().iterator());
        eROOT.addContent((Content)e);
        e = SecObj2Xml.rules2XML(si.getRules().values().iterator());
        eROOT.addContent((Content)e);
        XmlUtil.saveXmlFile((String)file, (Element)eROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUsersCycle(HashMap allUsers) {
        Iterator i = allUsers.values().iterator();
        try {
            while (i.hasNext()) {
                User user = (User)i.next();
                if (!(user instanceof UserGroup) || SecurityInfoIO.checkCycle((UserGroup)user, allUsers)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            for (User user : allUsers.values()) {
                if (!(user instanceof UserGroup)) continue;
                user.getProperties().remove("checkFlag");
            }
        }
        return true;
    }

    public static boolean checkCycle(UserGroup ug, HashMap allUsers) {
        Object checkFlag = ug.getProperties().get("checkFlag");
        if ("checking".equals(checkFlag)) {
            return false;
        }
        if ("checked".equals(checkFlag)) {
            return true;
        }
        if (checkFlag == null) {
            ug.getProperties().put("checkFlag", "checking");
            ArrayList members = ug.getMembersCopy();
            for (int i = 0; i < members.size(); ++i) {
                User user = (User)members.get(i);
                if (!(user instanceof UserGroup) || SecurityInfoIO.checkCycle((UserGroup)user, allUsers)) continue;
                return false;
            }
        } else {
            throw new Error("Internnal error.");
        }
        ug.getProperties().put("checkFlag", "checked");
        return true;
    }
}

