/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import java.util.HashMap;

public class SpaceProviderProxy
implements ISpaceProvider {
    private ISpaceProvider impl;
    private Path basePath;

    public SpaceProviderProxy(ISpaceProvider impl, Path basePath) {
        this.impl = impl;
        this.basePath = basePath;
    }

    private Path getAbsolutePath(Path resPath) {
        return Path.contact(this.basePath, resPath);
    }

    @Override
    public void allocate(Path resPath, boolean isFile) throws KDRSException {
        this.impl.allocate(this.getAbsolutePath(resPath), isFile);
    }

    @Override
    public void copyFile(Path fromPath, Path toPath) throws KDRSException {
        this.impl.copyFile(this.getAbsolutePath(fromPath), this.getAbsolutePath(toPath));
    }

    @Override
    public int exist(Path resPath) throws KDRSException {
        return this.impl.exist(this.getAbsolutePath(resPath));
    }

    @Override
    public void free(Path resPath) throws KDRSException {
        this.impl.free(this.getAbsolutePath(resPath));
    }

    @Override
    public int getLength(Path resPath) throws KDRSException {
        return this.impl.getLength(this.getAbsolutePath(resPath));
    }

    @Override
    public HashMap list(Path resPath) throws KDRSException {
        return this.impl.list(this.getAbsolutePath(resPath));
    }

    @Override
    public void move(Path resPath, Path newPath) throws KDRSException {
        this.impl.move(this.getAbsolutePath(resPath), this.getAbsolutePath(newPath));
    }

    @Override
    public IRandomAccessStream openStream(Path resPath, boolean clear, boolean autoCreate, boolean readOnly) throws KDRSException {
        return this.impl.openStream(this.getAbsolutePath(resPath), clear, autoCreate, false);
    }

    @Override
    public void rename(Path resPath, String newName) throws KDRSException {
        this.impl.rename(this.getAbsolutePath(resPath), newName);
    }
}

