/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileBlocksInfoBean;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DBAccess {
    private static final Logger log = LogUtil.getPackageLogger(DBAccess.class);
    private static int MAX_SIMPLE_ATTRVAL_LEN = 48;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidTables(Statement stmt) {
        boolean bl;
        String sql0 = "SELECT TOP 1 * FROM T_KDRS_StorageTree";
        String sql1 = "SELECT TOP 1 * FROM T_KDRS_Attributes";
        String sql2 = "SELECT TOP 1 * FROM T_KDRS_StorageFileData";
        ResultSet rs0 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            rs0 = stmt.executeQuery(sql0);
            rs1 = stmt.executeQuery(sql1);
            rs2 = stmt.executeQuery(sql2);
            bl = true;
        }
        catch (SQLException ex) {
            boolean bl2;
            try {
                log.error((Object)("sqls:" + sql0 + "\n" + sql1 + "\n" + sql2), (Throwable)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeResultSet((ResultSet)rs0);
                CtrlUtil.DB.closeResultSet(rs1);
                CtrlUtil.DB.closeResultSet(rs2);
                throw throwable;
            }
            CtrlUtil.DB.closeResultSet((ResultSet)rs0);
            CtrlUtil.DB.closeResultSet((ResultSet)rs1);
            CtrlUtil.DB.closeResultSet((ResultSet)rs2);
            return bl2;
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs0);
        CtrlUtil.DB.closeResultSet((ResultSet)rs1);
        CtrlUtil.DB.closeResultSet((ResultSet)rs2);
        return bl;
    }

    public static FileInfoBean readRootInfo(Statement stmt) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readRootInfo:" + stmt));
        }
        String sql = "SELECT * FROM T_KDRS_StorageTree WHERE FParentID=-1";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                FileInfoBean fileInfoBean = DBAccess.makeFileInfo(rs);
                return fileInfoBean;
            }
            FileInfoBean fileInfoBean = null;
            return fileInfoBean;
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
    }

    public static void eraseFileData(Statement stmt, int fid) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("eraseFileData:" + stmt + "," + fid));
        }
        String sql = "DELETE FROM T_KDRS_StorageFileData WHERE FID=" + fid;
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void copyFile(Statement stmt, int fid0, int fid1) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("copyFile:" + stmt + "," + fid0 + "," + fid1));
        }
        DBAccess.eraseFileData(stmt, fid1);
        String sql = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO T_KDRS_StorageFileData (FID, FBlockIndex, FBlockData, FBlockSize)");
            sb.append(" SELECT ");
            sb.append(fid1);
            sb.append(", FBlockIndex, FBlockData, FBlockSize FROM T_KDRS_StorageFileData WHERE FID=");
            sb.append(fid0);
            sql = sb.toString();
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void removeFileEntry(Statement stmt, int fid) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeFileEntry:" + stmt + "," + fid));
        }
        String sql = "DELETE FROM T_KDRS_StorageTree WHERE FID=" + fid;
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void updateFileEntry(Statement stmt, FileInfoBean bean) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFileEntry:" + stmt + "," + bean));
        }
        String sql = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" UPDATE T_KDRS_StorageTree SET FName='");
            sb.append(bean.getName());
            sb.append("' ,FParentID=");
            sb.append(bean.getPid());
            sb.append(" WHERE FID=");
            sb.append(bean.getFid());
            sql = sb.toString();
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void insertFileEntry(Statement stmt, FileInfoBean bean) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("insertFileEntry:" + stmt + "," + bean));
        }
        String sql = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO T_KDRS_StorageTree (FID,FParentID,FName,FIsFile) VALUES(");
            sb.append(bean.getFid());
            sb.append(",");
            sb.append(bean.getPid());
            sb.append(",'");
            sb.append(bean.getName());
            sb.append("',");
            sb.append(bean.isFile() ? "1" : "0");
            sb.append(")");
            sql = sb.toString();
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap readFileEntries(Statement stmt) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("readAllFiles:" + stmt));
        }
        HashMap<Integer, FileInfoBean> allFiles = new HashMap<Integer, FileInfoBean>();
        String sql = "SELECT * FROM T_KDRS_StorageTree";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FileInfoBean bean = DBAccess.makeFileInfo(rs);
                allFiles.put(new Integer(bean.getFid()), bean);
            }
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
        return allFiles;
    }

    private static FileInfoBean makeFileInfo(ResultSet rs) throws SQLException {
        FileInfoBean bean = new FileInfoBean(rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getBoolean(4));
        return bean;
    }

    public static int readStorageTreeVersion(Statement stmt) throws SQLException {
        String sql = "SELECT FSimpleAttrVal FROM T_KDRS_ATTRIBUTES WHERE FID=-1 AND FAttrName='TreeUpdateCount'";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
    }

    public static boolean updateStorageTreeVersion(Statement stmt, int newVer) throws SQLException {
        String sql = newVer > 1 ? "UPDATE T_KDRS_ATTRIBUTES SET FSimpleAttrVal=" + newVer + " WHERE FID=-1 AND FAttrName='TreeUpdateCount' AND FSimpleAttrVal=" + (newVer - 1) : "INSERT INTO T_KDRS_ATTRIBUTES (FID,FAttrName,FIsSimpleAttr,FSimpleAttrVal) VALUES(-1,'TreeUpdateCount',1,1)";
        try {
            return 1 == stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void addUpdateLog(Statement stmt, String cmdStr, int index) throws SQLException {
        String sql = "INSERT INTO T_KDRS_STORAGETREE_UPDATE_LOG (FIndex,FData) VALUES (" + index + ",'" + cmdStr + "')";
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static ArrayList readTreeModification(Statement stmt, int fromVer) throws SQLException {
        String sql = "SELECT FData FROM T_KDRS_STORAGETREE_UPDATE_LOG WHERE FIndex>" + fromVer;
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
        return list;
    }

    public static FileBlocksInfoBean readFileBlocksInfo(Statement stmt, int fid) throws SQLException {
        FileBlocksInfoBean fileBlocksInfoBean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("readBlocksInfo:" + stmt + "," + fid));
        }
        String sql = "SELECT FBlockSize FROM T_KDRS_StorageFileData WHERE FID=" + fid;
        ResultSet rs = null;
        try {
            int lastUsed = 0;
            int blockCount = 0;
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                lastUsed = rs.getInt(1);
                ++blockCount;
            }
            fileBlocksInfoBean = new FileBlocksInfoBean(fid, blockCount, lastUsed);
        }
        catch (SQLException ex) {
            try {
                log.error((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeResultSet(rs);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeResultSet((ResultSet)rs);
        return fileBlocksInfoBean;
    }

    /*
     * Exception decompiling
     */
    public static int readFileBlock(Statement stmt, int fid, int blockIndex, byte[] blockData) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeFileBlock(Connection conn, int fid, int blockIndex, byte[] blockData, int length, boolean isNewBlock) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeFileBlock:" + conn + "," + fid + "," + blockIndex + "," + blockData + "," + length + "," + isNewBlock));
        }
        StringBuffer sb = new StringBuffer();
        if (isNewBlock) {
            sb.append("INSERT INTO T_KDRS_StorageFileData ");
            sb.append("(FID,FBlockIndex,FBlockData,FBlockSize) VALUES( ");
            sb.append(fid);
            sb.append(",");
            sb.append(blockIndex);
            sb.append(",?,");
            sb.append(length);
            sb.append(")");
        } else {
            sb.append("UPDATE T_KDRS_StorageFileData SET FBlockData=?,FBlockSize=");
            sb.append(length);
            sb.append(" WHERE FID=");
            sb.append(fid);
            sb.append(" AND FBlockIndex=");
            sb.append(blockIndex);
        }
        String sql = null;
        PreparedStatement ps = null;
        try {
            sql = sb.toString();
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(blockData, 0, length), length);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                log.error((Object)("sql:" + sql));
                throw ex;
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(ps);
                throw throwable;
            }
        }
        CtrlUtil.DB.closeStatement((Statement)ps);
    }

    public static void insertEmptyFileBlocks(Statement stmt, int fid, int blockCount, int indexFrom, int blockSize) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("insertEmptyFileBlocks:" + stmt + "," + fid + "," + blockCount + "," + indexFrom + "," + blockSize));
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < blockCount; ++i) {
            int blockId = indexFrom + i;
            sb.setLength(0);
            sb.append("INSERT INTO T_KDRS_StorageFileData ");
            sb.append("(FID,FBlockIndex,FBlockData,FBlockSize) VALUES(");
            sb.append(fid);
            sb.append(",");
            sb.append(blockId);
            sb.append(",NULL,");
            sb.append(blockSize);
            sb.append(")");
            String sql = sb.toString();
            stmt.addBatch(sql);
            sqls.add(sql);
        }
        try {
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            log.error((Object)("sqls:" + sqls));
            throw ex;
        }
    }

    public static void removeAttributes(Statement stmt, int fid) throws SQLException {
        String sql = "DELETE FROM T_KDRS_Attributes WHERE FID=" + fid;
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
    }

    public static void copyAttributes(Connection conn, int fidFrom, int fidTo, boolean isNew) throws SQLException {
        Statement stmt = conn.createStatement();
        HashMap attrs0 = DBAccess.loadAttributes(stmt, fidFrom);
        HashMap attrs1 = isNew ? null : DBAccess.loadAttributes(stmt, fidTo);
        DBAccess.saveAttributes(conn, fidTo, attrs0, attrs1);
    }

    public static HashMap loadAttributes(Statement stmt, int fid) throws SQLException {
        String sql = "SELECT FAttrName,FIsSimpleAttr,FSimpleAttrVal,FComplexAttrVal FROM T_KDRS_Attributes WHERE FID=" + fid;
        ResultSet rs = null;
        HashMap<String, String> attrs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String attrName = rs.getString(1);
                String attrVal = null;
                attrVal = rs.getBoolean(2) ? rs.getString(3) : new String(rs.getBytes(4));
                if (attrs == null) {
                    attrs = new HashMap<String, String>();
                }
                attrs.put(attrName, attrVal);
            }
        }
        catch (SQLException ex) {
            log.error((Object)("sql:" + sql));
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)rs);
        }
        return attrs;
    }

    public static void saveAttribute(Connection conn, int fid, String attrName, Object attrVal) throws SQLException {
        HashMap oldAttrs = DBAccess.loadAttributes(conn.createStatement(), fid);
        HashMap newAttrs = oldAttrs == null ? new HashMap() : (HashMap)oldAttrs.clone();
        newAttrs.put(attrName, attrVal);
        DBAccess.saveAttributes(conn, fid, newAttrs, oldAttrs);
    }

    public static void saveAttributes(Connection conn, int fid, HashMap newAttrs) throws SQLException {
        HashMap oldAttrs = DBAccess.loadAttributes(conn.createStatement(), fid);
        DBAccess.saveAttributes(conn, fid, newAttrs, oldAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAttributes(Connection conn, int fid, HashMap newAttrs, HashMap oldAttrs) throws SQLException {
        ArrayList alters = DBAccess.collectAttrs(oldAttrs, newAttrs);
        ArrayList<String> batchSqls = new ArrayList<String>();
        StringBuffer deleteSql = null;
        int len = alters.size();
        for (int i = 0; i < len; ++i) {
            AlterAttr alter = (AlterAttr)alters.get(i);
            if (alter.alterType == 0) {
                if (deleteSql == null) {
                    deleteSql = new StringBuffer();
                    deleteSql.append("DELETE FROM T_KDRS_Attributes WHERE FID=");
                    deleteSql.append(fid);
                    deleteSql.append(" AND (");
                } else {
                    deleteSql.append(" OR ");
                }
                deleteSql.append("FAttrName='");
                deleteSql.append(alter.name);
                deleteSql.append("' ");
                continue;
            }
            int attrValLen = alter.value.length();
            StringBuffer sqlb = new StringBuffer();
            if (attrValLen <= MAX_SIMPLE_ATTRVAL_LEN) {
                if (alter.alterType == 1) {
                    sqlb.append("UPDATE T_KDRS_Attributes SET FIsSimpleAttr=1,FSimpleAttrVal='");
                    sqlb.append(alter.value);
                    sqlb.append("',");
                    sqlb.append("FComplexAttrVal=NULL");
                    sqlb.append(" WHERE FID=");
                    sqlb.append(fid);
                    sqlb.append(" AND FAttrName='");
                    sqlb.append(alter.name);
                    sqlb.append("'");
                } else {
                    sqlb.append("INSERT INTO T_KDRS_Attributes (FID,FIsSimpleAttr,FAttrName,FSimpleAttrVal) VALUES(");
                    sqlb.append(fid);
                    sqlb.append(",1,");
                    sqlb.append("'");
                    sqlb.append(alter.name);
                    sqlb.append("','");
                    sqlb.append(alter.value);
                    sqlb.append("')");
                }
                batchSqls.add(sqlb.toString());
                continue;
            }
            PreparedStatement ps = null;
            try {
                sqlb.append("INSERT INTO T_KDRS_Attributes (FID,FIsSimpleAttr,FAttrName,FComplexAttrVal) VALUES(");
                sqlb.append(fid);
                sqlb.append(",0,");
                sqlb.append("'");
                sqlb.append(alter.name);
                sqlb.append("',?)");
                ps = conn.prepareStatement(sqlb.toString());
                ps.setBytes(1, alter.value.getBytes());
                ps.execute();
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(ps);
                throw throwable;
            }
            CtrlUtil.DB.closeStatement((Statement)ps);
        }
        if (deleteSql != null) {
            deleteSql.append(")");
            batchSqls.add(deleteSql.toString());
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            for (int i = 0; i < batchSqls.size(); ++i) {
                stmt.addBatch((String)batchSqls.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            log.error((Object)ex);
        }
        finally {
            CtrlUtil.DB.closeStatement((Statement)stmt);
        }
    }

    static ArrayList collectAttrs(HashMap oldAttrs, HashMap newAttrs) {
        ArrayList<AlterAttr> alters = new ArrayList<AlterAttr>();
        if (oldAttrs == null) {
            oldAttrs = new HashMap();
        }
        if (newAttrs == null) {
            newAttrs = new HashMap();
        }
        for (Object oldAttrName : oldAttrs.keySet()) {
            Object newAttrVal = newAttrs.get(oldAttrName);
            if (newAttrVal != null) continue;
            alters.add(new AlterAttr((String)oldAttrName, null, 0));
        }
        Iterator names = newAttrs.keySet().iterator();
        Iterator values = newAttrs.values().iterator();
        while (names.hasNext()) {
            Object newAttrName = names.next();
            Object newAttrVal = values.next();
            if (!oldAttrs.containsKey(newAttrName)) {
                if (newAttrVal == null) continue;
                alters.add(new AlterAttr((String)newAttrName, (String)newAttrVal, 2));
                continue;
            }
            if (newAttrVal == null || newAttrVal.equals(oldAttrs.get(newAttrName))) continue;
            alters.add(new AlterAttr((String)newAttrName, (String)newAttrVal, 1));
        }
        return alters;
    }

    public static class AlterAttr {
        String name;
        String value;
        int alterType;
        public static final int ALERT_REMOVE = 0;
        public static final int ALERT_UPDATE = 1;
        public static final int ALERT_INSERT = 2;

        AlterAttr(String name, String value, int alterType) {
            this.name = name;
            this.value = value;
            this.alterType = alterType;
        }

        public static String getAlterTypeName(int type) {
            switch (type) {
                case 0: {
                    return "remove";
                }
                case 1: {
                    return "update";
                }
                case 2: {
                    return "insert";
                }
            }
            return "unknown";
        }

        public String toString() {
            return "[" + AlterAttr.getAlterTypeName(this.alterType) + "] name=" + this.name + ",value=" + this.value;
        }
    }
}

