/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db2;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBAccess;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.OpenConnectionException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileInfoBean;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractDBStorage
implements IStorage {
    private static final Logger log = LogUtil.getPackageLogger(AbstractDBStorage.class);
    protected IDataSource connPool;
    public static OpenConnectionException _ocException = new OpenConnectionException();

    public AbstractDBStorage(IDataSource connPool) {
        this.connPool = connPool;
    }

    protected Connection openConnection() throws OpenConnectionException {
        Connection conn = this.connPool.getConnection();
        if (conn == null) {
            throw _ocException;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("openConnection:" + conn));
        }
        return conn;
    }

    protected final FileInfoBean checkExist(Connection conn, Path path) throws KDRSException, SQLException {
        return this.checkExist(conn, path, true);
    }

    protected final FileInfoBean checkNotExist(Connection conn, Path path) throws KDRSException, SQLException {
        return this.checkExist(conn, path, false);
    }

    protected final FileInfoBean checkFile(Connection conn, Path path) throws KDRSException, SQLException {
        return this.checkFile(conn, path, true);
    }

    protected final FileInfoBean checkFolder(Connection conn, Path path) throws KDRSException, SQLException {
        return this.checkFile(conn, path, false);
    }

    protected final FileInfoBean checkExist(Connection conn, Path path, boolean checkExist) throws KDRSException, SQLException {
        FileInfoBean bean = this.lookup(conn, path);
        if (bean == null) {
            if (checkExist) {
                throw new NotFoundException(path.getPathText());
            }
        } else if (!checkExist) {
            throw new AlreadyExistsException("Resource '" + path + "' was already exist.");
        }
        return bean;
    }

    protected final FileInfoBean checkFile(Connection conn, Path path, boolean checkExistFile) throws KDRSException, SQLException {
        FileInfoBean bean = this.checkExist(conn, path, true);
        if (bean.isFile()) {
            if (!checkExistFile) {
                throw new InvalidPathException("This operation requir folder type resource.");
            }
        } else if (checkExistFile) {
            throw new InvalidPathException("This operation requir file type resource.");
        }
        return bean;
    }

    protected final void checkEmptyFolder(Statement stmt, Path path) throws SQLException {
    }

    protected FileInfoBean lookup(Connection conn, Path path) throws SQLException {
        return DBAccess.lookupFile(conn, path);
    }

    protected abstract void _rename(Path var1, String var2) throws KDRSException;

    @Override
    public void rename(Path path, String newName) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rename:" + path + "," + newName));
        }
        StorageUtil.checkPath(path, false);
        if (path.getName().equalsIgnoreCase(newName)) {
            return;
        }
        this._rename(path, newName);
    }

    protected abstract ResourceType _getType(Path var1) throws KDRSException;

    @Override
    public ResourceType getType(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getType:" + path));
        }
        return this._getType(path);
    }

    @Override
    public boolean isExist(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("isExist:" + path));
        }
        try {
            this._getType(path);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    protected abstract void _create(Path var1, ResourceType var2, HashMap var3) throws KDRSException;

    @Override
    public void create(Path path, ResourceType type, HashMap attributes) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create:" + path + "," + type + "," + attributes));
        }
        StorageUtil.checkIsNotRoot(path);
        StorageUtil.checkAttrsNameLength(attributes);
        this._create(path, type, attributes);
    }

    protected abstract void _delete(Path var1) throws KDRSException;

    @Override
    public void delete(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete:" + path));
        }
        StorageUtil.checkIsNotRoot(path);
        this._delete(path);
    }

    protected abstract void _copyFile(Path var1, Path var2) throws KDRSException;

    @Override
    public void copyFile(Path source, Path target) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("copyFile:" + source + "," + target));
        }
        if (!StorageUtil.checkCopyParameters(source, target)) {
            return;
        }
        this._copyFile(source, target);
    }

    abstract String[] _listChildren(Path var1) throws KDRSException;

    @Override
    public String[] listChildren(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listChildren:" + path));
        }
        return this._listChildren(path);
    }

    protected abstract IRandomAccessStream _getFileStream(Path var1, boolean var2, boolean var3) throws KDRSException;

    @Override
    public IRandomAccessStream getFileStream(Path path, boolean clear, boolean readOnly) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFileStream:" + path + "," + clear + "," + readOnly));
        }
        return this._getFileStream(path, clear, readOnly);
    }

    @Override
    public int getFileLength(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFileLength:" + path));
        }
        IRandomAccessStream stream = null;
        try {
            stream = this._getFileStream(path, false, true);
            int n = (int)stream.length();
            return n;
        }
        catch (IOException ex) {
            throw KDRSException.makeException("", ex);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)"close stream,", (Throwable)ex);
            }
        }
    }

    abstract HashMap _getAttributes(Path var1) throws KDRSException;

    @Override
    public HashMap getAttributes(Path path) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttributes:" + path));
        }
        return this._getAttributes(path);
    }

    protected abstract void _setAttributes(Path var1, HashMap var2) throws KDRSException;

    @Override
    public void setAttributes(Path path, HashMap attributes) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttributes:" + path + "," + attributes));
        }
        StorageUtil.checkAttrsNameLength(attributes);
        this._setAttributes(path, attributes);
    }

    @Override
    public Object getAttribute(Path path, String attrName) throws KDRSException {
        HashMap attrs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttribute:" + path + "," + attrName));
        }
        return (attrs = this._getAttributes(path)) == null ? null : attrs.get(attrName);
    }

    protected abstract void _setAttribute(Path var1, String var2, Object var3) throws KDRSException;

    @Override
    public void setAttribute(Path path, String attrName, Object attrValue) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttribute:" + path + "," + attrName + "," + attrValue));
        }
        this._setAttribute(path, attrName, attrValue);
    }

    protected abstract void _move(Path var1, Path var2) throws KDRSException;

    @Override
    public void move(Path path1, Path path2) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("move:" + path1 + "," + path2));
        }
        StorageUtil.checkPath(path1, false);
        StorageUtil.checkPath(path2, false);
        if (path1.getParent().equals(path2.getParent())) {
            this._rename(path1, path2.getName());
            return;
        }
        this._move(path1, path2);
    }
}

