/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db2;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.BasicRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBAccess;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileBlocksInfoBean;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBStoredFile
extends BasicRandomAccessStream {
    private static final Logger log = LogUtil.getPackageLogger(DBStoredFile.class);
    public static final int BLOCK_SIZE = 32768;
    private FileBlocksInfoBean blocksInfo;
    private int curBlockIdx;
    private int offset;
    private byte[] buffer;
    private boolean isNewBlock;
    private int bufferLength;
    private String fid;
    private IDataSource connPool;
    private byte[] oneByte;
    private int ref;
    private boolean needSyncToDB;

    public DBStoredFile(String fid, boolean isNewFile, IDataSource connPool) {
        this.fid = fid;
        this.connPool = connPool;
        this.buffer = new byte[32768];
        this.oneByte = new byte[1];
        this.ref = 1;
        if (isNewFile) {
            try {
                this.prepairBlocksInfo(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addRef() {
        ++this.ref;
    }

    public String getFid() {
        return this.fid;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("position can't be negative.");
        }
        super.checkStatus();
        if (this.position() == pos) {
            return;
        }
        int reqBlockIdx = (int)(pos / 32768L);
        this.offset = (int)(pos % 32768L);
        if (reqBlockIdx == this.curBlockIdx) {
            return;
        }
        this.trySyncToDB();
        this.curBlockIdx = reqBlockIdx;
        this.bufferLength = -1;
    }

    @Override
    public long length() throws IOException {
        super.checkStatus();
        int blockCount = this.prepairBlocksInfo().getBlockCount();
        if (blockCount != 0) {
            return (blockCount - 1) * 32768 + this.blocksInfo.getLastUse();
        }
        return 0L;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null || off < 0 || len < 0 || off + len > buf.length) {
            throw new IOException("Bad parameters.");
        }
        super.checkStatus();
        int leftBytes = len;
        int readBytes = 0;
        while (leftBytes > 0) {
            this.prepairBlockData(true, false);
            int canRead = this.bufferLength - this.offset;
            if (canRead == 0) break;
            if (canRead > leftBytes) {
                canRead = leftBytes;
            }
            System.arraycopy(this.buffer, this.offset, buf, off, canRead);
            leftBytes -= canRead;
            off += canRead;
            readBytes += canRead;
            this.offset += canRead;
        }
        return readBytes == 0 ? -1 : readBytes;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null || off < 0 || len < 0 || off + len > buf.length) {
            throw new IOException("Bad parameters.");
        }
        super.checkStatus();
        if (len > 0) {
            this.tryExpandFile();
        }
        int left = len;
        while (left > 0) {
            int canFill = 32768 - this.offset;
            if (canFill == 0) {
                this.prepairBlockData(32768 > left, true);
                canFill = 32768;
            }
            if (canFill > left) {
                canFill = left;
            }
            System.arraycopy(buf, off, this.buffer, this.offset, canFill);
            left -= canFill;
            off += canFill;
            this.offset += canFill;
            if (this.offset > this.bufferLength) {
                this.bufferLength = this.offset;
                this.blocksInfo.setLastUse(this.bufferLength);
            }
            this.needSyncToDB = true;
        }
    }

    private boolean tryExpandFile() throws IOException {
        int curBlockCount;
        if (this.blocksInfo == null) {
            int bak = this.curBlockIdx;
            this.prepairBlocksInfo();
            this.curBlockIdx = bak;
        }
        if (this.curBlockIdx >= (curBlockCount = this.blocksInfo.getBlockCount())) {
            if (this.curBlockIdx > curBlockCount) {
                Connection conn = null;
                Statement stmt = null;
                try {
                    conn = this.connPool.getConnection();
                    stmt = conn.createStatement();
                    DBAccess.insertEmptyFileBlocks(stmt, this.fid, this.curBlockIdx - curBlockCount, curBlockCount, 32768);
                    curBlockCount += this.curBlockIdx - curBlockCount;
                    this.blocksInfo.setBlockCount(curBlockCount);
                }
                catch (SQLException ex) {
                    try {
                        throw new IOException("Internal error," + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        CtrlUtil.DB.closeStatement(stmt);
                        CtrlUtil.DB.closeDBConn((Connection)conn);
                        throw throwable;
                    }
                }
                CtrlUtil.DB.closeStatement((Statement)stmt);
                CtrlUtil.DB.closeDBConn((Connection)conn);
            }
            this.blocksInfo.setBlockCount(curBlockCount + 1);
            this.bufferLength = this.offset;
            this.blocksInfo.setLastUse(this.bufferLength);
            this.isNewBlock = true;
            return true;
        }
        this.blocksInfo.setLastUse(this.offset);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepairBlockData(boolean reallyLoad, boolean forWrite) throws IOException {
        boolean expanded = false;
        if (this.bufferLength > 0 && this.offset == 32768) {
            this.trySyncToDB();
            ++this.curBlockIdx;
            if (forWrite) {
                expanded = this.tryExpandFile();
            }
            this.bufferLength = -1;
            this.offset = 0;
        } else {
            this.prepairBlocksInfo();
        }
        if (this.bufferLength == -1) {
            if (reallyLoad) {
                try {
                    if (expanded) {
                        this.bufferLength = 0;
                    }
                    Connection conn = null;
                    Statement stmt = null;
                    try {
                        conn = this.connPool.getConnection();
                        stmt = conn.createStatement();
                        this.bufferLength = DBAccess.readFileBlock(stmt, this.fid, this.curBlockIdx, this.buffer);
                    }
                    catch (Throwable throwable) {
                        CtrlUtil.DB.closeStatement(stmt);
                        CtrlUtil.DB.closeDBConn((Connection)conn);
                        throw throwable;
                    }
                    CtrlUtil.DB.closeStatement((Statement)stmt);
                    CtrlUtil.DB.closeDBConn((Connection)conn);
                }
                catch (SQLException ex) {
                    log.error((Object)"", (Throwable)ex);
                    throw new IOException("Internal error," + ex.getMessage());
                }
            } else {
                this.bufferLength = 32768;
            }
            this.needSyncToDB = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileBlocksInfoBean prepairBlocksInfo(boolean loadFromDB) throws IOException {
        block4: {
            if (this.blocksInfo != null) break block4;
            try {
                block6: {
                    block5: {
                        if (!loadFromDB) break block5;
                        Connection conn = null;
                        Statement stmt = null;
                        try {
                            conn = this.connPool.getConnection();
                            stmt = conn.createStatement();
                            this.blocksInfo = DBAccess.readFileBlocksInfo(stmt, this.fid);
                        }
                        catch (Throwable throwable) {
                            CtrlUtil.DB.closeStatement(stmt);
                            CtrlUtil.DB.closeDBConn((Connection)conn);
                            throw throwable;
                        }
                        CtrlUtil.DB.closeStatement((Statement)stmt);
                        CtrlUtil.DB.closeDBConn((Connection)conn);
                        break block6;
                    }
                    this.blocksInfo = new FileBlocksInfoBean(this.fid, 0, 0);
                }
                this.curBlockIdx = 0;
                this.bufferLength = -1;
            }
            catch (SQLException ex) {
                log.error((Object)"", (Throwable)ex);
                throw new IOException("Internal error:" + ex.getMessage());
            }
        }
        return this.blocksInfo;
    }

    private FileBlocksInfoBean prepairBlocksInfo() throws IOException {
        return this.prepairBlocksInfo(true);
    }

    @Override
    public int read() throws IOException {
        int r = this.read(this.oneByte, 0, 1);
        return r == 0 ? -1 : this.oneByte[0];
    }

    public void clearFileData() throws IOException {
        super.checkStatus();
        try {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.connPool.getConnection();
                stmt = conn.createStatement();
                DBAccess.eraseFileData(stmt, this.fid);
            }
            catch (Throwable throwable) {
                CtrlUtil.DB.closeStatement(stmt);
                CtrlUtil.DB.closeDBConn((Connection)conn);
                throw throwable;
            }
            CtrlUtil.DB.closeStatement((Statement)stmt);
            CtrlUtil.DB.closeDBConn((Connection)conn);
            if (this.blocksInfo != null) {
                this.blocksInfo.setBlockCount(0);
                this.blocksInfo.setLastUse(0);
                this.curBlockIdx = 0;
                if (this.buffer != null) {
                    this.offset = 0;
                    this.bufferLength = -1;
                }
                this.needSyncToDB = false;
            } else {
                this.prepairBlocksInfo(false);
            }
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new IOException("Internal error," + ex.getMessage());
        }
    }

    @Override
    public long position() throws IOException {
        super.checkStatus();
        return this.curBlockIdx * 32768 + this.offset;
    }

    private void trySyncToDB() throws IOException {
        if (!this.needSyncToDB) {
            return;
        }
        try {
            Connection conn = null;
            try {
                conn = this.connPool.getConnection();
                DBAccess.writeFileBlock(conn, this.fid, this.curBlockIdx, this.buffer, this.bufferLength, this.isNewBlock);
            }
            finally {
                CtrlUtil.DB.closeDBConn((Connection)conn);
            }
            this.needSyncToDB = false;
            this.isNewBlock = false;
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new IOException("Internal error," + ex.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isNewBlock) {
            this.tryExpandFile();
        }
        this.trySyncToDB();
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }
}

