/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.meta;

import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.BasicMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.FileMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.LazyFolderMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class MetaIO {
    public static final String T_NODE = "Node";
    public static final String T_NODES = "Nodes";
    public static final String T_META = "Meta";
    public static final String A_NAME = "name";
    public static final String A_ALIAS = "alias";
    public static final String A_TYPE = "type";
    public static final String A_VERSION = "version";
    public static final String V_VERSION = "1.1";

    public static Element makeMeta(Iterator itrChild) {
        Element xmlMeta = new Element(T_META);
        xmlMeta.setAttribute(A_VERSION, V_VERSION);
        xmlMeta.addContent((Content)MetaIO.makeNodes(itrChild));
        return xmlMeta;
    }

    public static Element makeNodes(Iterator itrChild) {
        Element xmlNodes = new Element(T_NODES);
        while (itrChild.hasNext()) {
            xmlNodes.addContent((Content)MetaIO.makeNode((IResourceMeta)itrChild.next()));
        }
        return xmlNodes;
    }

    public static Element makeNode(IResourceMeta meta) {
        Element xmlNode = new Element(T_NODE);
        xmlNode.setAttribute(A_TYPE, meta.getType().getName());
        xmlNode.setAttribute(A_NAME, meta.getName());
        MetaIO.makeAttributes(meta, xmlNode);
        return xmlNode;
    }

    public static void makeAttributes(IResourceMeta meta, Element xmlNode) {
        HashMap attrs = meta.getAttributes();
        if (attrs != null) {
            Iterator keys = attrs.keySet().iterator();
            Iterator vals = attrs.values().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object val = vals.next();
                if (val == null) continue;
                xmlNode.setAttribute(key.toString(), val.toString());
            }
        }
    }

    public static Iterator parseMeta(Element xmlMeta) {
        Element xmlNodes = xmlMeta.getChild(T_NODES);
        if (xmlNodes == null) {
            return null;
        }
        return MetaIO.parseNodes(xmlNodes);
    }

    public static Iterator parseNodes(Element xmlNodes) {
        List xmlLst = xmlNodes.getChildren(T_NODE);
        Iterator xmlItr = xmlLst.iterator();
        ArrayList<IResourceMeta> metas = new ArrayList<IResourceMeta>(xmlLst.size());
        while (xmlItr.hasNext()) {
            metas.add(MetaIO.parseNode((Element)xmlItr.next()));
        }
        return metas.iterator();
    }

    public static IResourceMeta parseNode(Element xmlNode) {
        BasicMeta meta;
        ResourceType resType = ResourceType.valueOf(xmlNode.getAttributeValue(A_TYPE));
        String name = xmlNode.getAttributeValue(A_NAME);
        if (resType == ResourceType.FILE) {
            meta = new FileMeta(name);
        } else if (resType == ResourceType.FOLDER) {
            meta = new LazyFolderMeta(name);
        } else {
            return null;
        }
        meta.setAttributes(MetaIO.parseAttributes(xmlNode));
        return meta;
    }

    public static HashMap parseAttributes(Element xmlNode) {
        HashMap<String, String> attrs = new HashMap<String, String>(5);
        List xmlAttrs = xmlNode.getAttributes();
        for (int i = 0; i < xmlAttrs.size(); ++i) {
            Attribute attr = (Attribute)xmlAttrs.get(i);
            attrs.put(attr.getName(), attr.getValue());
        }
        return attrs;
    }
}

