/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.AbstractDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class OrderDataOperate
extends AbstractDataOperate {
    private KDTable table;

    @Override
    public void setSelectedData(DataExtend[] data) {
        this.isValid = data != null && data.length == 1;
    }

    @Override
    public boolean operate() {
        R1PrintModelHelper.pickSort(this.getCore().getModel());
        DataExtend[] dataExts = null;
        try {
            dataExts = this.getCore().getDataTree().getSelectedData();
        }
        catch (DataTree.SelectErrorException e) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.notData", ""), (String)MultiLanguageUtil.getMLS("data.OrderDataOperate.setOrder", ""), (Component)this.getParentCtrl());
            return false;
        }
        DataExtend ext = dataExts[0];
        List sortFields = R1PrintModelHelper.getDataSorts(ext);
        MetaClass data = (MetaClass)this.getCore().getModel().getDataManager().getObject(ext.getName());
        return this.orderFieldUI(data, sortFields);
    }

    private boolean orderFieldUI(MetaClass data, final List sortFields) {
        KDPanel panel = new KDPanel();
        TableLayout2 layout = new TableLayout2(3, 3);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(2, 40);
        layout.setRowSpacing(1, 5);
        layout.setRatableWidth(0, 8);
        layout.setRatableWidth(1, 1);
        layout.setRatableWidth(2, 1);
        panel.setLayout((LayoutManager)layout);
        KDLabel text = new KDLabel(MultiLanguageUtil.getMLS("data.OrderDataOperate.chooseField", ""));
        KDTextArea txaPrompt = new KDTextArea(MultiLanguageUtil.getMLS("data.OrderDataOperate.explain", ""));
        txaPrompt.setEditable(false);
        txaPrompt.setFocusable(false);
        KDWorkButton downButton = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        downButton.setToolTipText(MultiLanguageUtil.getMLS("data.OrderDataOperate.down", ""));
        KDWorkButton upButton = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        upButton.setToolTipText(MultiLanguageUtil.getMLS("data.OrderDataOperate.up", ""));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = KDTableUtil.getSelectedRow((KDTable)OrderDataOperate.this.table).getRowIndex();
                if (!(index >= OrderDataOperate.this.table.getRowCount() - 1 || index < sortFields.size() && ((SystemR1PrintDataSortItem)sortFields.get(index)).isSystem())) {
                    OrderDataOperate.this.table.exchangeRow(index, index + 1);
                    KDTableUtil.setSelectedRow((KDTable)OrderDataOperate.this.table, (int)(index + 1));
                }
            }
        });
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = KDTableUtil.getSelectedRow((KDTable)OrderDataOperate.this.table).getRowIndex();
                if (!(index <= 0 || index <= sortFields.size() && ((SystemR1PrintDataSortItem)sortFields.get(index - 1)).isSystem())) {
                    OrderDataOperate.this.table.exchangeRow(index, index - 1);
                    KDTableUtil.setSelectedRow((KDTable)OrderDataOperate.this.table, (int)(index - 1));
                }
            }
        });
        this.table = new KDTable(4, 0, 0);
        this.table.getSelectManager().setSelectMode(2);
        this.table.getColumn(0).setWidth(30);
        this.table.getColumn(1).setWidth(140);
        this.table.getColumn(2).setWidth(60);
        this.table.getColumn(3).setWidth(90);
        IRow headRow = this.table.addHeadRow();
        headRow.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.pitchOn", ""));
        headRow.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.fieldName", ""));
        headRow.getCell(2).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.order", ""));
        headRow.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.isSystem", ""));
        this.addOrderFields(data, sortFields);
        this.addOtherFields(data, sortFields);
        SimpleDialog dlg = SimpleDialog.create((Component)this.getParentCtrl());
        panel.add((Component)text, (Object)TableLayout2.param((int)0, (int)0));
        panel.add((Component)downButton, (Object)TableLayout2.param((int)0, (int)1));
        panel.add((Component)upButton, (Object)TableLayout2.param((int)0, (int)2));
        panel.add((Component)this.table, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        panel.add((Component)txaPrompt, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)2));
        dlg.setComponent((Component)panel);
        dlg.setTitle(MultiLanguageUtil.getMLS("data.OrderDataOperate.setOrder", ""));
        dlg.setSize(400, 480);
        if (dlg.showDialog()) {
            sortFields.clear();
            int rowCount = this.table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Boolean isOrder = (Boolean)this.table.getRow(i).getCell(0).getValue();
                if (!isOrder.booleanValue()) continue;
                String field = (String)this.table.getRow(i).getCell(1).getValue();
                field = this.getFieldName(field);
                KDComboBox comboBox = (KDComboBox)this.table.getRow(i).getCell(2).getEditor().getComponent();
                SystemR1PrintDataSortItem sortItem = new SystemR1PrintDataSortItem(field, comboBox.getSelectedIndex(), false);
                sortFields.add(sortItem);
            }
            this.getCore().getModel().setDirty(true);
            return true;
        }
        return false;
    }

    private void addOrderFields(MetaClass data, List sortFields) {
        for (int i = 0; i < sortFields.size(); ++i) {
            SystemR1PrintDataSortItem item = (SystemR1PrintDataSortItem)sortFields.get(i);
            MetaField field = data.getField(item.getSortField());
            this.addRow(true, field, item.getSortType(), item.isSystem());
        }
    }

    private void addOtherFields(MetaClass data, List sortFields) {
        List fields = data.getFields();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            int sortSize = sortFields.size();
            MetaField filed = (MetaField)fields.get(i);
            String fieldName = filed.getName();
            boolean has = false;
            for (int j = 0; j < sortSize; ++j) {
                String sortName = ((R1PrintDataSortItem)sortFields.get(j)).getSortField();
                if (!StringUtil.equals((String)fieldName, (String)sortName)) continue;
                has = true;
            }
            if (has) continue;
            this.addRow(false, filed, 0, false);
        }
    }

    private void addRow(boolean isOrder, MetaField field, int type, boolean isSystem) {
        this.table.addRow();
        IRow row = this.table.getRow(this.table.getRowCount() - 1);
        row.getCell(0).setValue((Object)new Boolean(isOrder));
        String alias = field.getAlias();
        String filedName = null;
        filedName = alias == null ? field.getName() : alias + ":" + field.getName();
        row.getCell(1).setValue((Object)filedName);
        row.getCell(1).getStyleAttributes().setLocked(true);
        KDComboBox comboBox = new KDComboBox((Object[])new String[]{MultiLanguageUtil.getMLS("data.OrderDataOperate.asc", ""), MultiLanguageUtil.getMLS("data.OrderDataOperate.desc", "")});
        KDTDefaultCellEditor choice = new KDTDefaultCellEditor((JComboBox)comboBox);
        row.getCell(2).setEditor((ICellEditor)choice);
        comboBox.setSelectedIndex(type);
        row.getCell(2).setValue(comboBox.getItemAt(type));
        if (isSystem) {
            row.getCell(0).getStyleAttributes().setLocked(true);
            row.getCell(0).setRenderer((IBasicRender)new checkBoxRender());
            row.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.yes", ""));
        } else {
            row.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("data.OrderDataOperate.no", ""));
        }
        row.getCell(3).getStyleAttributes().setLocked(true);
    }

    private String getFieldName(String field) {
        String[] fullName = field.split(":");
        if (fullName.length == 2) {
            return fullName[1];
        }
        return field;
    }

    private class checkBoxRender
    implements IBasicRender {
        KDCheckBox box = new KDCheckBox();

        private checkBoxRender() {
        }

        public void draw(Graphics g, Shape clip, Object object, Style cellStyle) {
            this.box.setSelected(((Boolean)object).booleanValue());
            this.box.setEnabled(!cellStyle.isLocked());
            Rectangle rect = clip.getBounds();
            int y = rect.y + (rect.height - 13) / 2;
            this.box.setSize(15, 15);
            Graphics g2 = g.create(3, y, rect.width, rect.height);
            this.box.paint(g2);
        }
    }
}

