/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.menu.IR1DesignerAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.toolbar.ISimilarAction;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.StateChangedEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.AbstractR1Designer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickListener;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

public abstract class AbstractR1ColorAction
implements IR1DesignerAction,
ISimilarAction {
    private KDComboColor _ctrl;
    private AbstractR1Designer _designer;

    @Override
    public void setBindCtrl(JComponent ctrl) {
        if (!(ctrl instanceof KDComboColor)) {
            throw new R1DesignerRuntimeException("Ctrl must be KDComboColor.");
        }
        this._ctrl = (KDComboColor)ctrl;
        this._ctrl.setBackground(KDComboColor.TRANSPARENTCOLOR);
        EventHandler eventHandler = new EventHandler();
        this._ctrl.addSelectedListener((ComboColorSelectedListener)eventHandler);
        this._ctrl.addViewPicClickListener((ComboColorViewPicClickListener)eventHandler);
        this.initCtrl(this._ctrl);
    }

    @Override
    public void setDesigner(AbstractR1Designer designer) {
        this._designer = designer;
    }

    @Override
    public AbstractR1Designer getDesigner() {
        return this._designer;
    }

    @Override
    public void todoStateChanged(StateChangedEvent evt) {
        if (evt.getState().isStateMark(4096L)) {
            this._ctrl.setEnabled(true);
        } else {
            this._ctrl.setEnabled(false);
        }
    }

    @Override
    public void todoSelectionChanged(ChangeEvent evt) {
        this._ctrl.setEnabled(this.isEnabled(this.getDesigner().getCore()));
    }

    protected abstract void initCtrl(KDComboColor var1);

    protected abstract boolean isEnabled(ComboPanel var1);

    protected abstract StyleAttributes setElementColor(IElement var1, Color var2);

    class EventHandler
    implements ComboColorSelectedListener,
    ComboColorViewPicClickListener {
        EventHandler() {
        }

        public void selected(ComboColorSelectedEvent evt) {
            this.doColorSelected(evt.getSelectedColor());
        }

        public void clicked(ComboColorViewPicClickEvent evt) {
            this.doColorSelected(evt.getCurrentColor());
        }

        private void doColorSelected(Color newColor) {
            ComboPanel core = AbstractR1ColorAction.this.getDesigner().getCore();
            ElementPath[] eps = core.getSelectionModel().getAll();
            for (int i = 0; i < eps.length; ++i) {
                IElement ele = (IElement)eps[i].getLastPathComponent();
                StyleAttributes sa = AbstractR1ColorAction.this.setElementColor(ele, newColor);
                Object obj = eps[i].getRootPathComponent();
                if (!(obj instanceof ICompositeObject) || sa == null) continue;
                ((ICompositeObject)obj).applySubElementStyle(ele, sa);
            }
            core.getModel().setDirty(true);
            core.getPageContainer().repaint();
        }
    }
}

