/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNormalContainer
extends AbstractReportObject
implements IContainer {
    private ArrayList _children;

    @Override
    public void addChild(IReportObject child, String layoutParm) {
        this.getChildren().add(child);
        child.setParent(new ElementPath(this));
    }

    @Override
    public boolean isCanAddChild(Point ptAtThis) {
        return true;
    }

    @Override
    public void removeChild(IReportObject child) {
        this.getChildren().remove(child);
        child.setParent(null);
    }

    @Override
    public List getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        return this._children;
    }

    @Override
    public int getChildrenCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    @Override
    public int getInsetsXLom() {
        Style style = this.getStyle();
        if (style != null) {
            return style.getPadding().getLeft();
        }
        return 0;
    }

    @Override
    public int getInsetsYLom() {
        Style style = this.getStyle();
        if (style != null) {
            return style.getPadding().getTop();
        }
        return 0;
    }

    @Override
    public int getInsetsWidthLom() {
        int w = this.getWidthLom();
        Style style = this.getStyle();
        if (style != null) {
            return w - style.getPadding().getLeft() - style.getPadding().getRight();
        }
        return w;
    }

    @Override
    public int getInsetsHeightLom() {
        int h = this.getHeightLom();
        Style style = this.getStyle();
        if (style != null) {
            return h - style.getPadding().getTop() - style.getPadding().getBottom();
        }
        return h;
    }

    @Override
    public Rectangle getInsetRect(String layoutParm) {
        Rectangle rect = new Rectangle(this.getInsetsXLom(), this.getInsetsYLom(), this.getInsetsWidthLom(), this.getInsetsHeightLom());
        Util.lom2Pixel(rect);
        return rect;
    }

    @Override
    public void layout() {
        for (IReportObject ro : this.getChildren()) {
            if (ro.isHorizontalFill()) {
                ro.setXLom(0);
                ro.setWidthLom(this.getInsetsWidthLom());
            }
            if (ro.isVerticalFill()) {
                ro.setYLom(0);
                ro.setHeightLom(this.getInsetsHeightLom());
            }
            if (ro instanceof IContainer) {
                ((IContainer)((Object)ro)).layout();
                continue;
            }
            if (!(ro instanceof ICompositeContainer)) continue;
            ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
        }
    }

    @Override
    public String getLayoutParm(Point ptAtThis) {
        return null;
    }
}

