/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.Toolbox;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.toolbox.IToolboxItem;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.IConfigFileCreator;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ToolboxLoader {
    public static void initToolbox(Toolbox toolbox, IConfigFileCreator configCreator) {
        Element root = ToolboxLoader.readXml(configCreator.create());
        if (root != null && "Toolbox".equalsIgnoreCase(root.getName())) {
            InitWhenDesign initer = new InitWhenDesign();
            initer.setToolbox(toolbox);
            ToolboxLoader.initWithConfig(root, initer);
            toolbox.validateContent();
        }
    }

    private static Element readXml(InputStream is) {
        Element root = null;
        try {
            root = XmlUtil.loadXmlStream((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return root;
    }

    private static void initWithConfig(Element root, Initialize initer) {
        for (Element nodeGroup : root.getChildren("Group")) {
            String title = nodeGroup.getAttributeValue("title");
            title = MultiLanguageUtil.getMLS("core.ToolboxLoader.toolbox", title);
            ToolboxGroup group = new ToolboxGroup();
            group.setTitle(title);
            initer.initGroup(group);
            for (Element nodeItem : nodeGroup.getChildren()) {
                String key;
                String classname = nodeItem.getAttributeValue("classname");
                IToolboxItem item = ToolboxLoader.createItem(classname, key = nodeItem.getAttributeValue("key"));
                if (item == null) continue;
                initer.initItem(group, item);
            }
        }
    }

    private static IToolboxItem createItem(String classname, String key) {
        Object obj = null;
        if (!StringUtil.isEmptyString((String)classname)) {
            try {
                obj = Class.forName(classname).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (obj instanceof IToolboxItem) {
            IToolboxItem item = obj;
            item.setKey(key);
            return item;
        }
        return null;
    }

    public static ArrayList createXmlTransChain(InputStream config) {
        ArrayList train = new ArrayList();
        Element root = ToolboxLoader.readXml(config);
        if (root != null && "Toolbox".equalsIgnoreCase(root.getName())) {
            InitWhenExecute initer = new InitWhenExecute();
            initer.setList(train);
            ToolboxLoader.initWithConfig(root, initer);
        }
        return train;
    }

    private static class InitWhenExecute
    implements Initialize {
        private List list;

        private InitWhenExecute() {
        }

        public void setList(List list) {
            this.list = list;
        }

        public List getList() {
            return this.list;
        }

        @Override
        public void initGroup(ToolboxGroup group) {
        }

        @Override
        public void initItem(ToolboxGroup group, IToolboxItem item) {
            IObjectXmlTrans oxt = item.getAnObjectFactory().getXmlTrans();
            this.list.add(oxt);
        }
    }

    private static class InitWhenDesign
    implements Initialize {
        private Toolbox toolbox;

        private InitWhenDesign() {
        }

        public void setToolbox(Toolbox toolbox) {
            this.toolbox = toolbox;
        }

        public Toolbox getToolbox() {
            return this.toolbox;
        }

        @Override
        public void initGroup(ToolboxGroup group) {
            this.toolbox.addGroup(group);
        }

        @Override
        public void initItem(ToolboxGroup group, IToolboxItem item) {
            KDToggleButton btn = item.createButton();
            group.initButton(btn);
            btn.setUserObject((Object)item);
            this.toolbox.getReportObjectFactory().add(item.getKey(), item);
            IObjectXmlTrans oxt = item.getAnObjectFactory().getXmlTrans();
            this.toolbox.getReportObjectFactory().getXmlTransTrain().add(oxt);
        }
    }

    private static interface Initialize {
        public void initGroup(ToolboxGroup var1);

        public void initItem(ToolboxGroup var1, IToolboxItem var2);
    }
}

