/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Element;

public class Memo {
    private String _prompt;
    private Element _xmlRoot;
    private Element _selection;

    public Memo(Element xmlRoot, ElementPath[] selection) {
        this._xmlRoot = xmlRoot;
        this._selection = Memo.selectionElementsToXml(selection);
    }

    public String getPrompt() {
        return this._prompt;
    }

    public void setPrompt(String prompt) {
        this._prompt = prompt;
    }

    public Element getReportXml() {
        return this._xmlRoot;
    }

    public ElementPath[] getSelection(ReportModel reportModel) {
        return Memo.xmlToSelectionElements(this._selection, reportModel);
    }

    public static Element selectionElementsToXml(ElementPath[] eps) {
        Element root = new Element("Selections");
        for (int i = 0; i < eps.length; ++i) {
            ElementPath ep = eps[i];
            Element node = new Element("Target");
            IElement ele = (IElement)ep.getLastPathComponent();
            if (ele instanceof IReportObject) {
                node.setAttribute("reportObject", ele.getId());
            } else {
                IReportObject ro = (IReportObject)ep.getRootPathComponent();
                node.setAttribute("reportObject", ro.getId());
                node.setAttribute("reportElement", ele.getId());
            }
            root.addContent((Content)node);
        }
        return root;
    }

    static ElementPath[] xmlToSelectionElements(Element root, ReportModel reportModel) {
        ArrayList<ElementPath> result = new ArrayList<ElementPath>();
        for (Element node : root.getChildren()) {
            String objId = node.getAttributeValue("reportObject");
            String eleId = node.getAttributeValue("reportElement");
            IReportObject ro = (IReportObject)reportModel.getElementById(objId);
            if (eleId != null) {
                IElement ele = reportModel.getElementById(eleId);
                ICompositeObject co = (ICompositeObject)((Object)ro);
                result.add(co.makeElementPath(ele));
                continue;
            }
            result.add(new ElementPath(ro));
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ElementPath[0]);
    }
}

