/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io;

import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractR1XmlWriter
implements IR1XmlWriter,
IR1XmlRecursiveWriter {
    private StyleCache _styleCache = new StyleCache();
    private List _xmlTransChain;

    protected StyleCache getStyleCache() {
        return this._styleCache;
    }

    @Override
    public void setXmlTransChain(List list) {
        this._xmlTransChain = list;
    }

    @Override
    public Element selectionToXml(ReportSelectionModel selectionModel) {
        Element root = new Element("DocRoot");
        Element nodeSelections = new Element("Selections");
        root.addContent((Content)nodeSelections);
        StringBuffer sbSelectedIds = new StringBuffer();
        Element nodeObjects = new Element("Objects");
        root.addContent((Content)nodeObjects);
        ElementPath[] eps = selectionModel.getAll();
        IReportObject reportObject = null;
        for (int i = 0; i < eps.length; ++i) {
            ElementPath ep = eps[i];
            IReportObject ro = (IReportObject)ep.getRootPathComponent();
            IElement ele = (IElement)ep.getLastPathComponent();
            if (sbSelectedIds.length() > 0) {
                sbSelectedIds.append(",");
            }
            sbSelectedIds.append(ele.getId());
            if (reportObject != ro) {
                nodeObjects.addContent((Content)this.parseObject(this, ro, this.getStyleCache()));
            }
            if (reportObject != null) continue;
            reportObject = ro;
        }
        nodeSelections.addContent(sbSelectedIds.toString());
        Element nodeStyles = new Element("Styles");
        root.addContent((Content)nodeStyles);
        this.storeStyles(nodeStyles);
        return root;
    }

    @Override
    public Element toXml(ReportModel model, IDataXmlTrans dataXmlTrans) {
        Element root = this.createRoot();
        this.storeParams(model, root.getChild("Parameters"));
        dataXmlTrans.toXml(model.getDataManager(), root.getChild("DataSources"));
        root.addContent((Content)this.createReport(model));
        this.storeStyles(root.getChild("Styles"));
        this.storeOthers(model, root);
        return root;
    }

    private Element createRoot() {
        Element root = new Element("DocRoot");
        Element datas = new Element("DataSources");
        Element params = new Element("Parameters");
        Element styles = new Element("Styles");
        root.addContent((Content)params);
        root.addContent((Content)datas);
        root.addContent((Content)styles);
        return root;
    }

    protected void storeParams(ReportModel model, Element xmlParams) {
        if (model.getDataManager().isSupportReportParams()) {
            List paramList = model.getParams();
            Iterator itr = paramList.iterator();
            while (itr.hasNext()) {
                xmlParams.addContent((Content)ParameterIO.makeParameter((Parameter)((Parameter)itr.next())));
            }
        }
    }

    private void storeStyles(Element stylesNode) {
        HashMap cache = this.getStyleCache().getCache();
        StyleParser.writeStyles((Element)stylesNode, (Namespace)stylesNode.getNamespace(), cache.entrySet().iterator());
    }

    protected abstract Element createReport(ReportModel var1);

    protected abstract void storeOthers(ReportModel var1, Element var2);

    @Override
    public void saveContainer(IR1XmlRecursiveWriter writer, IContainer container, Element node) {
        if (container.getChildrenCount() == 0) {
            return;
        }
        for (IReportObject ro : container.getChildren()) {
            Element nodeChild = this.parseObject(writer, ro, this.getStyleCache());
            if (nodeChild == null) continue;
            node.addContent((Content)nodeChild);
        }
    }

    @Override
    public Element parseObject(IR1XmlRecursiveWriter writer, IReportObject ro, StyleCache styleCache) {
        if (this._xmlTransChain == null) {
            return null;
        }
        for (Object objTrans : this._xmlTransChain) {
            IObjectXmlTrans trans;
            Element node;
            if (!(objTrans instanceof IObjectXmlTrans) || (node = (trans = (IObjectXmlTrans)objTrans).toXml(writer, ro, styleCache)) == null) continue;
            return node;
        }
        return null;
    }
}

