/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer;

import com.kingdee.bos.ctrl.kdf.util.render.BorderRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.render.NoteTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractLayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractLayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class GridRenderer
extends AbstractObjectRenderer
implements IBorderHolder {
    private static Style style4InvlidValue;
    protected AbstractGrid _grid;
    protected BorderRender _borderRender = new BorderRender((IBorderHolder)this);
    protected BorderRender.BorderInfo _bi = new BorderRender.BorderInfo(15);

    @Override
    public void draw(Graphics g, PageContainer c) {
        Graphics graphics = g.create(this._grid.getX(), this._grid.getY(), this._grid.getWidth() + 1, this._grid.getHeight() + 1);
        this.drawCells(graphics, c);
    }

    protected int getStartX() {
        return 0;
    }

    protected int getStartY() {
        return 0;
    }

    protected void drawCells(Graphics graphics, PageContainer c) {
        int y = this.getStartY();
        int rowCnt = this._grid.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            int x = this.getStartX();
            int h = this._grid.getRow(i).getFeatHeight();
            int colCnt = this._grid.getColumnsCount();
            for (int j = 0; j < colCnt; ++j) {
                boolean toDraw = true;
                int w = this._grid.getColumn(j).getFeatWidth();
                AbstractCell cell = this._grid.getCell(i, j);
                int width = 0;
                int height = 0;
                if (cell.getMergeBlock() == null) {
                    width = w;
                    height = h;
                } else {
                    MergeBlock block = cell.getMergeBlock();
                    if (block.isFirstCell(i, j)) {
                        width = block.getBlockWidth(this._grid);
                        height = block.getBlockHeight(this._grid);
                    } else {
                        toDraw = false;
                    }
                }
                if (toDraw) {
                    Style style = this.getCellStyle(i, j);
                    Rectangle rect = new Rectangle(x, y, width + 1, height + 1);
                    this.drawBackground(graphics, rect, style);
                    this._borderRender.draw(graphics, (Shape)rect, (Object)this._bi, GridRenderer.getNullBorderForDraw(style));
                    if (style != null) {
                        this._borderRender.draw(graphics, (Shape)rect, (Object)this._bi, style);
                        this.drawInsetsBorder(graphics, cell, x, y, width, height);
                    }
                    if (cell instanceof AbstractDataGridCell) {
                        ICellValue value = ((AbstractDataGridCell)cell).getValue();
                        this.drawText(graphics, value, rect, style == null ? Styles.getDefaultStyle() : style);
                    }
                }
                x += w;
            }
            y += h;
        }
    }

    protected void drawInsetsBorder(Graphics graphics, AbstractCell cell, int x, int y, int width, int height) {
        if (!(this._grid instanceof AbstractLayoutGrid)) {
            return;
        }
        AbstractLayoutGrid layoutGrid = (AbstractLayoutGrid)this._grid;
        AbstractLayoutGridCell layoutGridCell = (AbstractLayoutGridCell)cell;
        Color oriColor = graphics.getColor();
        graphics.setColor(Util.COLOR_INSETS_LINE);
        int innerX = x + Util.lom2Pixel(layoutGridCell.getInsetsXLom());
        int innerY = y + Util.lom2Pixel(layoutGridCell.getInsetsYLom());
        int innerW = Util.lom2Pixel(layoutGrid.getSubContainerInsetsWidthLom(layoutGridCell));
        int innerH = Util.lom2Pixel(layoutGrid.getSubContainerInsetsHeightLom(layoutGridCell));
        if (innerX != x) {
            graphics.drawLine(innerX, innerY, innerX, innerY + innerH);
        }
        if (innerY != y) {
            graphics.drawLine(innerX, innerY, innerX + innerW, innerY);
        }
        if (innerX + innerW != x + width) {
            graphics.drawLine(innerX + innerW, innerY, innerX + innerW, innerY + innerH);
        }
        if (innerY + innerH != y + height) {
            graphics.drawLine(innerX, innerY + innerH, innerX + innerW, innerY + innerH);
        }
        graphics.setColor(oriColor);
    }

    protected void drawText(Graphics graphics, ICellValue value, Rectangle rect, Style style) {
        if (value != null) {
            NoteTextRender cr = new NoteTextRender();
            cr.draw(graphics, (Shape)rect, (Object)value.getDrawString(), value.isInvalid() ? style4InvlidValue : style);
        }
    }

    protected static Style getNullBorderForDraw(Style oriStyle) {
        if (oriStyle == null || LineStyle.isNull((LineStyle)oriStyle.getBorderLineStyle(Styles.Position.LEFT)) && LineStyle.isNull((LineStyle)oriStyle.getBorderLineStyle(Styles.Position.RIGHT)) && LineStyle.isNull((LineStyle)oriStyle.getBorderLineStyle(Styles.Position.TOP)) && LineStyle.isNull((LineStyle)oriStyle.getBorderLineStyle(Styles.Position.BOTTOM))) {
            return Styles.getStyle((ShareStyleAttributes)GridRenderer.getNullBorderForDraw());
        }
        return oriStyle;
    }

    private static Style getNullBorderForDraw() {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_DOT);
        sa.setBorderColor(Styles.Position.LEFT, Color.GRAY);
        sa.setBorderColor(Styles.Position.RIGHT, Color.GRAY);
        sa.setBorderColor(Styles.Position.TOP, Color.GRAY);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.GRAY);
        return new Style((ShareStyleAttributes)sa);
    }

    public Style getCellStyle(int row, int col) {
        return this._grid.getCellStyle(row, col);
    }

    public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
        if (dir.isWest() && row > 1) {
            --row;
        } else if (dir.isEast() && row < this._grid.getRowsCount() - 1) {
            ++row;
        }
        if (dir.isNorth() && col > 1) {
            --col;
        } else if (dir.isSouth() && col < this._grid.getColumnsCount() - 1) {
            ++col;
        }
        return this._grid.getCellStyle(row, col);
    }

    @Override
    public void setReportObject(IReportObject obj) {
        this._grid = (AbstractGrid)obj;
    }

    static {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontColor(Color.RED);
        style4InvlidValue = Styles.getStyle((ShareStyleAttributes)sa);
    }
}

