/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.datagrid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.ComplexTextRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.LinkedList;
import java.util.Stack;

public class GroupPromptRender {
    private AbstractDataGrid grid;
    private int _headerWidth;
    private LinkedList _listWidth;
    private Stack _stackAfter;
    private LinkedList _listBefore;
    private LinkedList _groupField;
    private ComplexTextRenderer _complexTextRenderer = new ComplexTextRenderer();
    private IR1DataManager _dataManager;
    private FontMetrics _fm;
    private boolean _isLeft = true;
    private Point _prompPosition = new Point(0, 0);

    private int calculateWidth() {
        this._listBefore = new LinkedList();
        this._stackAfter = new Stack();
        this._groupField = new LinkedList();
        this._listWidth = new LinkedList();
        this._headerWidth = 40;
        this._listWidth.add(new Integer(this._headerWidth));
        R1DataGridGroup lastGroup = null;
        R1DataGridGroup group = null;
        boolean isBeforeDetail = true;
        boolean isInDetail = false;
        int y = 0;
        int c = this.grid.getRowsCount();
        for (int i = 0; i <= c; ++i) {
            AbstractRow row = i == c ? null : this.grid.getRow(i);
            if (isBeforeDetail && row instanceof AbstractDetailRow) {
                isBeforeDetail = false;
                isInDetail = true;
                this._listBefore.add(new Integer(y));
            }
            if (isInDetail && !(row instanceof AbstractDetailRow)) {
                isInDetail = false;
                this._stackAfter.push(new Integer(y));
            }
            if (row instanceof AbstractGroupRow) {
                group = ((AbstractGroupRow)row).getGroup();
            } else if (!(row instanceof AbstractDetailRow)) {
                group = null;
            }
            if (!R1DataGridGroup.equals(lastGroup, group)) {
                lastGroup = group;
                if (isBeforeDetail) {
                    this._listBefore.add(new Integer(y));
                    this.addGroupField(group);
                } else {
                    this._stackAfter.push(new Integer(y));
                }
            }
            if (row == null) continue;
            y += this.grid.getRowDrawingTimes(row) * row.getFeatHeight();
        }
        this._groupField.add(MultiLanguageUtil.getMLS("datagrid.GroupPromptRender.dataRow", ""));
        return this._headerWidth;
    }

    private void addGroupField(R1DataGridGroup group) {
        MetaClass data = null;
        String drawName = null;
        if (this._dataManager != null) {
            String name;
            MetaField field;
            String dsName = this.grid.getDataSource().getDs();
            data = (MetaClass)this._dataManager.getObject(dsName);
            if (data != null && (field = data.getField(name = group.getAccording())) != null) {
                String alias = field.getAlias();
                String string = drawName = StringUtil.isEmptyString((String)alias) ? field.getName() : alias;
            }
            if (drawName == null) {
                drawName = MultiLanguageUtil.getMLS("datagrid.GroupPromptRender.noField", "");
            }
            this._groupField.add(drawName);
            this._headerWidth += 10;
            this._headerWidth = this.controlWidth(this._headerWidth, drawName);
            this._listWidth.add(new Integer(this._headerWidth));
        }
    }

    private void setPrompPoint(int pagePositionX, int pagePosintY, Rectangle thisVisibleRect) {
        Point gridAtPage = ContainerUtil.getPointAtPage(this.grid);
        int gridX = gridAtPage.x + pagePositionX;
        int gridRight = gridX + this.grid.getWidth();
        int prompWidth = this.calculateWidth();
        this._isLeft = gridX - thisVisibleRect.x > prompWidth;
        this._prompPosition.x = this._isLeft ? Math.max(gridX, thisVisibleRect.x + prompWidth) : Math.min(gridRight + prompWidth, thisVisibleRect.width + thisVisibleRect.x) - prompWidth;
        this._prompPosition.y = gridAtPage.y + pagePosintY;
    }

    private int controlWidth(int width, String groupFieldName) {
        int stringWidth = this._fm.stringWidth(groupFieldName);
        if (stringWidth < 120) {
            if (width < stringWidth) {
                width = stringWidth;
            }
        } else if (width < 120) {
            width = 120;
        }
        return width;
    }

    public void draw(Graphics g, AbstractDataGrid grid, int pagePositionX, int pagePosintY, Rectangle thisVisibleRect) {
        Graphics2D gCopy = (Graphics2D)g.create();
        BasicStroke s = new BasicStroke();
        gCopy.setStroke(s);
        this.grid = grid;
        Style style = Styles.getDefaultStyle();
        this._fm = gCopy.getFontMetrics((Font)style.getKDFont());
        this.setPrompPoint(pagePositionX, pagePosintY, thisVisibleRect);
        gCopy.setColor(new Color(200, 200, 200));
        if (this._isLeft) {
            gCopy.fillRect(this._prompPosition.x - this._headerWidth, this._prompPosition.y, this._headerWidth, grid.getHeight());
        } else {
            gCopy.fillRect(this._prompPosition.x + 1, this._prompPosition.y, this._headerWidth, grid.getHeight());
        }
        int groupFieldBeforeHeight = 0;
        int groupFieldAfterHeight = 0;
        for (int i = 0; i < this._listBefore.size(); ++i) {
            int width = (Integer)this._listWidth.get(this._listBefore.size() - i - 1) - 1;
            int gridBeforeY = (Integer)this._listBefore.get(i);
            int girdAfterY = (Integer)this._stackAfter.pop();
            String groupFieldName = this._groupField.get(i).toString();
            int height = girdAfterY - gridBeforeY;
            if (i != this._listBefore.size() - 1) {
                groupFieldBeforeHeight = (Integer)this._listBefore.get(i + 1) - gridBeforeY;
            } else {
                groupFieldBeforeHeight = height;
                groupFieldAfterHeight = height;
            }
            if (!this._stackAfter.isEmpty()) {
                groupFieldAfterHeight = girdAfterY - (Integer)this._stackAfter.peek();
            }
            gCopy.setColor(new Color(200, 200, 200));
            int x = this._prompPosition.x;
            if (this._isLeft) {
                x -= width;
            }
            int y = this._prompPosition.y + gridBeforeY;
            gCopy.fillRect(x, y, width, height);
            gCopy.setColor(Color.DARK_GRAY);
            gCopy.drawRect(x, y, width, height);
            Graphics g1 = gCopy.create(x, y, width, groupFieldBeforeHeight);
            Rectangle rectNameBefore = new Rectangle(0, 0, width, groupFieldBeforeHeight);
            Graphics g2 = gCopy.create(x, this._prompPosition.y + girdAfterY - groupFieldAfterHeight, width, groupFieldAfterHeight);
            Rectangle rectNameAfter = new Rectangle(0, 0, width, groupFieldAfterHeight);
            this._complexTextRenderer.draw(g1, (Shape)rectNameBefore, (Object)groupFieldName, style);
            this._complexTextRenderer.draw(g2, (Shape)rectNameAfter, (Object)groupFieldName, style);
        }
    }

    public void setDataManager(IR1DataManager dataManager) {
        this._dataManager = dataManager;
    }

    public boolean isLeft() {
        return this._isLeft;
    }

    public int getPropmtWidth() {
        return this._headerWidth;
    }
}

