/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.actions.operate.grid;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CellTypeOperate
extends AbstractOperate {
    @Override
    public boolean operate() {
        CellTypeDialog dlg = CellTypeDialog.create(this.getParentCtrl());
        dlg.setTitle("\u5355\u5143\u683c\u7c7b\u578b");
        AbstractDataGridCell cell = (AbstractDataGridCell)this.getSelected().getLastPathComponent();
        ICellValue value = cell.getValue();
        int oldType = value == null ? 0 : value.getCellType();
        dlg.setSelectedType(oldType);
        if (!dlg.showDialog()) {
            return false;
        }
        this.getCore().storeUndoState("\u6539\u53d8\u5355\u5143\u683c\u7c7b\u578b");
        int newType = dlg.getSelectedType();
        if (oldType != newType) {
            switch (newType) {
                case 1: {
                    cell.setValue(new Text("\u6587\u672c"));
                    break;
                }
                case 2: {
                    cell.setValue(new CellField());
                    break;
                }
                case 3: {
                    cell.setValue(new StatField());
                    break;
                }
                default: {
                    cell.setValue(null);
                }
            }
            this.getCore().getModel().setDirty(true);
            this.getCore().getPageContainer().repaint();
        }
        return true;
    }

    @Override
    public boolean isValid() {
        ElementPath elePath = this.getSelected();
        return elePath.getLastPathComponent() instanceof AbstractDataGridCell;
    }

    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    private static class CellTypeDialog
    extends TypicalDialog {
        private KDRadioButton radDefault;
        private KDRadioButton radString;
        private KDRadioButton radField;
        private KDRadioButton radStat;
        private KDRadioButton radBak1;
        private KDRadioButton radBak2;
        private KDRadioButton radBak3;
        private KDRadioButton radBak4;

        public static CellTypeDialog create(JComponent parentCtrl) {
            Window owner = SwingUtilities.getWindowAncestor(parentCtrl);
            if (owner instanceof Dialog) {
                return new CellTypeDialog((Dialog)owner);
            }
            if (owner instanceof Frame) {
                return new CellTypeDialog((Frame)owner);
            }
            return new CellTypeDialog();
        }

        public CellTypeDialog() {
        }

        public CellTypeDialog(Frame owner) {
            super(owner);
        }

        public CellTypeDialog(Dialog owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setSize(200, 200);
            this.setResizable(false);
            this.radDefault = new KDRadioButton("\u9ed8\u8ba4");
            this.radString = new KDRadioButton("\u6587\u672c");
            this.radField = new KDRadioButton("\u5b57\u6bb5");
            this.radStat = new KDRadioButton("\u7edf\u8ba1");
            this.radBak1 = new KDRadioButton("\u5907\u75281");
            this.radBak2 = new KDRadioButton("\u5907\u75282");
            this.radBak3 = new KDRadioButton("\u5907\u75283");
            this.radBak4 = new KDRadioButton("\u5907\u75284");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.radDefault);
            buttonGroup.add((AbstractButton)this.radString);
            buttonGroup.add((AbstractButton)this.radField);
            buttonGroup.add((AbstractButton)this.radStat);
            buttonGroup.add((AbstractButton)this.radBak1);
            buttonGroup.add((AbstractButton)this.radBak2);
            buttonGroup.add((AbstractButton)this.radBak3);
            buttonGroup.add((AbstractButton)this.radBak4);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            Table tb = thisCell.splitRow(5);
            tb.style().setMarginBottom(6);
            tb.rowStyle(4).setPriY(1);
            parent.add((Component)this.radDefault, tb.cell(0));
            parent.add((Component)this.radString, tb.cell(1));
            parent.add((Component)this.radField, tb.cell(2));
            parent.add((Component)this.radStat, tb.cell(3));
        }

        public void setSelectedType(int type) {
            switch (type) {
                case 1: {
                    this.radString.setSelected(true);
                    break;
                }
                case 2: {
                    this.radField.setSelected(true);
                    break;
                }
                case 3: {
                    this.radStat.setSelected(true);
                    break;
                }
                default: {
                    this.radDefault.setSelected(true);
                }
            }
        }

        public int getSelectedType() {
            if (this.radString.isSelected()) {
                return 1;
            }
            if (this.radField.isSelected()) {
                return 2;
            }
            if (this.radStat.isSelected()) {
                return 3;
            }
            return 0;
        }
    }
}

