/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.element;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClick;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClickEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.TextEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.AbstractR1FormObjectWithData;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.renderer.TextAreaRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;

public class TextAreaObject
extends AbstractR1FormObjectWithData
implements IDoubleClick {
    public static final String[] STYLE_PANELS = new String[]{"digitFormat", "font", "interior"};
    private static TextAreaRenderer _renderer = new TextAreaRenderer();
    private String _text;

    @Override
    public String getIdPrefix() {
        return "textArea";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)Icons.SEC_TEXTAREA);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("multiRowText", "");
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return _renderer;
    }

    @Override
    public String[] getStylePanelKeys() {
        return STYLE_PANELS;
    }

    @Override
    public IDoubleClickEditor getEditor() {
        KDTextArea ctrl = new KDTextArea();
        ctrl.setBorder(null);
        KDScrollPane scp = new KDScrollPane();
        scp.setVerticalScrollBarPolicy(22);
        TextEditor editor = TextEditor.createInstance((JTextComponent)ctrl);
        editor.setScrollPane(scp);
        editor.setValue(this.getText());
        editor.setBindObject(this);
        return editor;
    }

    @Override
    public void setEditedValue(Object value) {
        this.setText((String)value);
    }

    @Override
    public boolean isCanEdit() {
        return !this.isBindData();
    }

    @Override
    public Rectangle getEditorBound() {
        return null;
    }

    @Override
    public String getType() {
        return "TextArea";
    }

    @Override
    protected String[] propertyPanelKeys(ICompositeObject co) {
        return new String[]{"textAreaSet"};
    }
}

