/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.properties.IRequestFill;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class PanelBound
extends AbstractPropertyPanel {
    private KDSpinner spnX;
    private KDSpinner spnY;
    private KDSpinner spnW;
    private KDSpinner spnH;
    private KDCheckBox chkHorizontalFill;
    private KDCheckBox chkVerticalFill;
    private boolean isMultiSelected;
    private boolean isHResizable;
    private boolean isVResizable;
    private ComboPanel core;

    public PanelBound() {
        this.init();
        this.installListener();
    }

    private void init() {
        this.spnX = new KDSpinner();
        this.spnY = new KDSpinner();
        this.spnW = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, Short.MAX_VALUE, 1));
        this.spnH = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, Short.MAX_VALUE, 1));
        KDLabelContainer lbcX = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnX, (String)MultiLanguageUtil.getMLS("locationX", ""), (int)80);
        KDLabelContainer lbcY = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnY, (String)MultiLanguageUtil.getMLS("locationY", ""), (int)80);
        KDLabelContainer lbcW = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnW, (String)MultiLanguageUtil.getMLS("width", ""), (int)80);
        KDLabelContainer lbcH = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnH, (String)MultiLanguageUtil.getMLS("height", ""), (int)80);
        this.chkHorizontalFill = new KDCheckBox(MultiLanguageUtil.getMLS("hFill", ""));
        this.chkVerticalFill = new KDCheckBox(MultiLanguageUtil.getMLS("vFill", ""));
        this.chkHorizontalFill.setSwitch(false);
        this.chkVerticalFill.setSwitch(false);
        TableLayout tlPos = TableLayout.split((int)2, (int)2);
        tlPos.style().setMargin(10, 20, 10, 10);
        tlPos.rowStyle(0).setHeight(20);
        tlPos.rowStyle(0).setMarginBottom(3);
        tlPos.rowStyle(1).setHeight(20);
        tlPos.colStyle(0).setWidth(180);
        tlPos.colStyle(1).setPriX(1);
        KDPanel panPos = new KDPanel((LayoutManager)tlPos);
        panPos.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("location", "")));
        panPos.add((Component)lbcX, (Object)tlPos.cell(0, 0));
        panPos.add((Component)lbcY, (Object)tlPos.cell(1, 0));
        TableLayout tlSize = TableLayout.split((int)2, (int)2);
        tlSize.style().setMargin(10, 20, 10, 10);
        tlSize.rowStyle(0).setHeight(20);
        tlSize.rowStyle(0).setMarginBottom(3);
        tlSize.rowStyle(1).setHeight(20);
        tlSize.colStyle(0).setWidth(180);
        tlSize.colStyle(1).setPriX(1);
        KDPanel panSize = new KDPanel((LayoutManager)tlSize);
        panSize.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("size", "\u5927\u5c0f")));
        panSize.add((Component)lbcW, (Object)tlSize.cell(0, 0));
        panSize.add((Component)lbcH, (Object)tlSize.cell(1, 0));
        TableLayout tlFill = TableLayout.split((int)1, (int)2);
        tlFill.style().setMargin(10, 20, 10, 10);
        tlFill.colStyle(0).setWidth(-50);
        tlFill.colStyle(1).setWidth(-50);
        KDPanel panFill = new KDPanel((LayoutManager)tlFill);
        panFill.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("fillC", "")));
        panFill.add((Component)this.chkHorizontalFill, (Object)tlFill.cell(0));
        panFill.add((Component)this.chkVerticalFill, (Object)tlFill.cell(1));
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.style().setMargin(8, 8, 8, 8);
        tl.rowStyle(0).setHeight(80);
        tl.rowStyle(0).setMarginBottom(8);
        tl.rowStyle(1).setHeight(50);
        tl.rowStyle(2).setPriY(1);
        Table row1 = tl.cell(0).split(1, 2);
        row1.colStyle(0).setWidth(-50);
        row1.colStyle(0).setMarginRight(6);
        row1.colStyle(1).setWidth(-50);
        this.setLayout((LayoutManager)tl);
        this.add((Component)panPos, row1.cell(0));
        this.add((Component)panSize, row1.cell(1));
        this.add((Component)panFill, tl.cell(1));
    }

    private void installListener() {
        this.chkHorizontalFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBound.this.syncEnabled();
            }
        });
        this.chkVerticalFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBound.this.syncEnabled();
            }
        });
    }

    private void syncEnabled() {
        if (!this.isMultiSelected) {
            this.spnX.setEnabled(!this.chkHorizontalFill.isSelected());
            if (!this.isHResizable) {
                this.spnW.setEnabled(false);
            } else {
                this.spnW.setEnabled(!this.chkHorizontalFill.isSelected());
            }
            this.spnY.setEnabled(!this.chkVerticalFill.isSelected());
            if (!this.isVResizable) {
                this.spnH.setEnabled(false);
            } else {
                this.spnH.setEnabled(!this.chkVerticalFill.isSelected());
            }
        }
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("layout", "");
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        IRequestFill requestFill;
        Object objParent;
        boolean toChange;
        IReportObject ro = (IReportObject)elePath.getLastPathComponent();
        if (ro instanceof IR1Page) {
            ro.setWidthLom(Util.pixel2Lom(this.spnW.getIntegerVlaue()));
            ro.setHeightLom(Util.pixel2Lom(this.spnH.getIntegerVlaue()));
            return;
        }
        if (!this.isMultiSelected) {
            ro.setXLom(Util.pixel2Lom(this.spnX.getIntegerVlaue()));
            ro.setYLom(Util.pixel2Lom(this.spnY.getIntegerVlaue()));
            if (this.isHResizable) {
                ro.setWidthLom(Util.pixel2Lom(this.spnW.getIntegerVlaue()));
            }
            if (this.isVResizable) {
                ro.setHeightLom(Util.pixel2Lom(this.spnH.getIntegerVlaue()));
            }
            if (this.isHResizable || this.isVResizable) {
                ContainerUtil.layoutChildren((IReportObject)elePath.getRootPathComponent());
            }
        }
        if (this.chkHorizontalFill.getSelectState() != 64) {
            toChange = true;
            if (this.isMultiSelected && (objParent = ro.getParent().getLastPathComponent()) instanceof IRequestFill && !(requestFill = (IRequestFill)objParent).isHFillEditable()) {
                toChange = false;
            }
            if (toChange) {
                ro.setHorizontalFill(this.chkHorizontalFill.isSelected());
            }
        }
        if (this.chkVerticalFill.getSelectState() != 64) {
            toChange = true;
            if (this.isMultiSelected && (objParent = ro.getParent().getLastPathComponent()) instanceof IRequestFill && !(requestFill = (IRequestFill)objParent).isVFillEditable()) {
                toChange = false;
            }
            if (toChange) {
                ro.setVerticalFill(this.chkVerticalFill.isSelected());
            }
        }
        this.core.getModel().getPage().layout();
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eles) {
        IReportObject ro = (IReportObject)eles[0].getLastPathComponent();
        if (eles.length > 1) {
            this.isMultiSelected = true;
            this.spnX.setEnabled(false);
            this.spnY.setEnabled(false);
            this.spnW.setEnabled(false);
            this.spnH.setEnabled(false);
        } else {
            this.isMultiSelected = false;
            this.spnX.setValue((Object)new Integer(Util.lom2Pixel(ro.getXLom())));
            this.spnY.setValue((Object)new Integer(Util.lom2Pixel(ro.getYLom())));
            this.spnW.setValue((Object)new Integer(Util.lom2Pixel(ro.getWidthLom())));
            this.spnH.setValue((Object)new Integer(Util.lom2Pixel(ro.getHeightLom())));
        }
        if (ro instanceof IR1Page) {
            this.spnX.setEnabled(false);
            this.spnY.setEnabled(false);
            this.chkHorizontalFill.setEnabled(false);
            this.chkVerticalFill.setEnabled(false);
            return;
        }
        this.chkHorizontalFill.setEnabled(true);
        this.chkVerticalFill.setEnabled(true);
        this.isHResizable = ro.isHorizontalResizable();
        this.isVResizable = ro.isVerticalResizable();
        boolean isHF = ro.isHorizontalFill();
        boolean isVF = ro.isVerticalFill();
        boolean isHFUnsure = false;
        boolean isVFUnsure = false;
        for (int i = 1; i < eles.length; ++i) {
            ro = (IReportObject)eles[i].getLastPathComponent();
            if (!isHFUnsure && isHF != ro.isHorizontalFill()) {
                isHFUnsure = true;
            }
            if (!isVFUnsure && isVF != ro.isVerticalFill()) {
                isVFUnsure = true;
            }
            this.isHResizable = this.isHResizable && ro.isHorizontalResizable();
            this.isVResizable = this.isVResizable && ro.isVerticalResizable();
        }
        Object objParent = ro.getParent().getLastPathComponent();
        if (objParent instanceof IRequestFill) {
            IRequestFill requestFill = (IRequestFill)objParent;
            this.chkHorizontalFill.setEnabled(requestFill.isHFillEditable());
            this.chkVerticalFill.setEnabled(requestFill.isVFillEditable());
        }
        if (this.chkHorizontalFill.isEnabled()) {
            this.chkHorizontalFill.setEnabled(this.isHResizable);
        }
        if (this.chkVerticalFill.isEnabled()) {
            this.chkVerticalFill.setEnabled(this.isVResizable);
        }
        if (isHFUnsure) {
            this.chkHorizontalFill.setSelectState(64);
        } else {
            this.chkHorizontalFill.setSelected(isHF);
        }
        if (isVFUnsure) {
            this.chkVerticalFill.setSelectState(64);
        } else {
            this.chkVerticalFill.setSelected(isVF);
        }
        this.syncEnabled();
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eps) {
        this.core = core;
    }
}

