/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.data;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class CommonFieldPane
extends KDPanel {
    private KDRadioButton radBindField;
    private KDRadioButton radCustomBindField;
    private KDComboBox cmbBindField;
    private KDTextField txtCustomBindField;
    private KDRadioButton radShowField;
    private KDRadioButton radCustomShowField;
    private KDComboBox cmbShowField;
    private KDTextField txtCustomShowField;
    private KDPanel panShowField;

    public CommonFieldPane() {
        this.init();
        this.installListener();
    }

    private void init() {
        this.radBindField = new KDRadioButton();
        this.radCustomBindField = new KDRadioButton();
        this.cmbBindField = new KDComboBox();
        this.txtCustomBindField = new KDTextField();
        KDLabelContainer lbcBindField = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindField, (String)MultiLanguageUtil.getMLS("bindField", ""), (int)80);
        KDLabelContainer lbcCustomBindField = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtCustomBindField, (String)MultiLanguageUtil.getMLS("selfDefineField", ""), (int)120);
        this.radShowField = new KDRadioButton();
        this.radCustomShowField = new KDRadioButton();
        this.cmbShowField = new KDComboBox();
        this.txtCustomShowField = new KDTextField();
        KDLabelContainer lbcShowField = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbShowField, (String)MultiLanguageUtil.getMLS("ShowField", ""), (int)80);
        KDLabelContainer lbcCustomShowField = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtCustomShowField, (String)MultiLanguageUtil.getMLS("SelfDefineShowField", ""), (int)120);
        TableLayout tlBind = TableLayout.split((int)2, (int)5);
        tlBind.style().setMargin(10, 20, 10, 20);
        tlBind.rowStyle(0).setHeight(20);
        tlBind.rowStyle(1).setPriY(1);
        tlBind.colStyle(0).setWidth(20);
        tlBind.colStyle(1).setWidth(250);
        tlBind.colStyle(1).setMarginRight(20);
        tlBind.colStyle(2).setWidth(20);
        tlBind.colStyle(3).setWidth(200);
        tlBind.colStyle(4).setPriX(1);
        KDPanel panBindField = new KDPanel((LayoutManager)tlBind);
        panBindField.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("bindField", "")));
        panBindField.add((Component)this.radBindField, (Object)tlBind.cell(0));
        panBindField.add((Component)lbcBindField, (Object)tlBind.cell(1));
        panBindField.add((Component)this.radCustomBindField, (Object)tlBind.cell(2));
        panBindField.add((Component)lbcCustomBindField, (Object)tlBind.cell(3));
        TableLayout tlShow = TableLayout.split((int)2, (int)5);
        tlShow.style().setMargin(10, 20, 10, 20);
        tlShow.rowStyle(0).setHeight(20);
        tlShow.rowStyle(1).setPriY(1);
        tlShow.colStyle(0).setWidth(20);
        tlShow.colStyle(1).setWidth(250);
        tlShow.colStyle(1).setMarginRight(20);
        tlShow.colStyle(2).setWidth(20);
        tlShow.colStyle(3).setWidth(200);
        tlShow.colStyle(4).setPriX(1);
        this.panShowField = new KDPanel((LayoutManager)tlShow);
        this.panShowField.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("showField", "")));
        this.panShowField.add((Component)this.radShowField, (Object)tlShow.cell(0));
        this.panShowField.add((Component)lbcShowField, (Object)tlShow.cell(1));
        this.panShowField.add((Component)this.radCustomShowField, (Object)tlShow.cell(2));
        this.panShowField.add((Component)lbcCustomShowField, (Object)tlShow.cell(3));
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.rowStyle(0).setHeight(60);
        tl.rowStyle(0).setMarginBottom(8);
        tl.rowStyle(1).setHeight(60);
        tl.rowStyle(1).setMarginBottom(8);
        tl.rowStyle(2).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)panBindField, tl.cell(0, 0));
        this.add((Component)this.panShowField, tl.cell(1, 0));
        this.radBindField.setSelected(true);
        this.radShowField.setSelected(true);
    }

    private void installListener() {
        ButtonGroup bgBind = new ButtonGroup();
        bgBind.add((AbstractButton)this.radBindField);
        bgBind.add((AbstractButton)this.radCustomBindField);
        ButtonGroup bgShow = new ButtonGroup();
        bgShow.add((AbstractButton)this.radShowField);
        bgShow.add((AbstractButton)this.radCustomShowField);
        RadioActoinHandler handler = new RadioActoinHandler();
        this.radBindField.addActionListener((ActionListener)handler);
        this.radCustomBindField.addActionListener((ActionListener)handler);
        this.radShowField.addActionListener((ActionListener)handler);
        this.radCustomShowField.addActionListener((ActionListener)handler);
    }

    private void syncEnabled() {
        this.cmbBindField.setEnabled(this.radBindField.isSelected());
        this.txtCustomBindField.setEnabled(this.radCustomBindField.isSelected());
        this.cmbShowField.setEnabled(this.radShowField.isSelected());
        this.txtCustomShowField.setEnabled(this.radCustomShowField.isSelected());
    }

    public void setShowFieldEnabled(boolean enabled) {
        this.panShowField.setVisible(enabled);
    }

    public void prepareSupplyValue(Object mc) {
        this.cmbBindField.removeAllItems();
        this.cmbShowField.removeAllItems();
        if (mc instanceof MetaClass) {
            for (MetaField mf : ((MetaClass)mc).getFields()) {
                Field field = Field.fromMetaField(mf);
                this.cmbBindField.addItem((Object)field);
                this.cmbShowField.addItem((Object)field);
            }
        }
        this.cmbBindField.setSelectedIndex(-1);
        this.cmbShowField.setSelectedIndex(-1);
    }

    public void prepareCtrlValue(IBind.IBindField bindField, IBind.IBindField showField) {
        if (bindField != null) {
            Field f1 = bindField.getField();
            this.cmbBindField.setSelectedItem((Object)f1);
            if (this.cmbBindField.getSelectedIndex() >= 0) {
                this.radBindField.setSelected(true);
                this.radCustomBindField.setSelected(false);
            } else {
                this.radBindField.setSelected(f1 == null);
                this.radCustomBindField.setSelected(f1 != null);
                if (f1 != null) {
                    this.txtCustomBindField.setText(f1.getName());
                }
            }
        }
        if (showField != null) {
            Field f2 = showField.getField();
            this.cmbShowField.setSelectedItem((Object)f2);
            if (this.cmbShowField.getSelectedIndex() >= 0) {
                this.radShowField.setSelected(true);
                this.radCustomShowField.setSelected(false);
            } else {
                this.radShowField.setSelected(f2 == null);
                this.radCustomShowField.setSelected(f2 != null);
                if (f2 != null) {
                    this.txtCustomShowField.setText(f2.getName());
                }
            }
        }
        this.syncEnabled();
    }

    public void updateElementValue(IBind.IBindField bindField, IBind.IBindField showField) {
        String txt;
        Field f = null;
        if (bindField != null) {
            if (this.radBindField.isSelected()) {
                f = (Field)this.cmbBindField.getSelectedItem();
            } else {
                txt = this.txtCustomBindField.getText().trim();
                if (!StringUtil.isEmptyString((String)txt)) {
                    f = Field.valueOf(txt, null);
                }
            }
            bindField.setField(f);
        }
        if (showField != null) {
            if (this.radShowField.isSelected()) {
                f = (Field)this.cmbShowField.getSelectedItem();
            } else {
                txt = this.txtCustomShowField.getText().trim();
                if (!StringUtil.isEmptyString((String)txt)) {
                    f = Field.valueOf(txt, null);
                }
            }
            showField.setField(f);
        }
    }

    private class RadioActoinHandler
    implements ActionListener {
        private RadioActoinHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonFieldPane.this.syncEnabled();
        }
    }
}

