/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.billlist.BillListCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.billlist.BillListGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.billlist.BillListHeadRow;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class BillListGridXmlTrans
extends AbstractR1FormXmlTrans {
    public BillListGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"BillList", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        BillListGrid grid = new BillListGrid();
        this.loadObjectCommon(node, grid);
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        return grid;
    }

    private void loadColumn(Element nodeCol, BillListGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(BillListGridXmlTrans.getIntAttr(nodeCol, "width"));
        if (StringUtil.equals((String)nodeCol.getAttributeValue("autoAdjustColumn"), (String)"true")) {
            column.setFixedWidth(false);
        }
    }

    private void loadRow(Element nodeRow, BillListGrid grid, Element nodeGrid) throws R1Exception {
        AbstractRow row;
        String rowType = nodeRow.getAttributeValue("type");
        if (StringUtil.equals((String)"detail", (String)rowType)) {
            row = grid.addRow(2);
        } else if (StringUtil.equals((String)"head", (String)rowType)) {
            row = grid.addRow(4);
        } else {
            return;
        }
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(BillListGridXmlTrans.getIntAttr(nodeRow, "height"));
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            BillListCell cell = (BillListCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadCell(Element nodeCell, BillListGrid grid, BillListCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        if ("true".equals(nodeCell.getAttributeValue("isExecutedMerge"))) {
            cell.setExectuedMerge(true);
        }
        GridXmlTransUtil.loadCellValue(nodeCell, cell);
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof BillListGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("BillList");
        this.saveObjectCommon(ro, nodeGrid);
        BillListGrid grid = (BillListGrid)ro;
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        return nodeGrid;
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        BillListGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        if (!column.isFixedWidth()) {
            nodeColumn.setAttribute("autoAdjustColumn", "true");
        }
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, BillListGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver) {
        Element nodeRow = new Element("TR");
        BillListGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        if (row instanceof AbstractDetailRow) {
            nodeRow.setAttribute("type", "detail");
        } else if (row instanceof BillListHeadRow) {
            nodeRow.setAttribute("type", "head");
        }
        this.saveElementCommon(row, nodeRow);
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            BillListCell cell = (BillListCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(grid, cell));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private Element saveCell(BillListGrid grid, BillListCell cell) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        if (cell.isExectuedMerge()) {
            nodeCell.setAttribute("isExecutedMerge", "true");
        }
        GridXmlTransUtil.saveCellValue(cell, nodeCell);
        return nodeCell;
    }
}

