/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LoadKDStyleUtil {
    private static Hashtable map = new Hashtable();
    public static final Logger log = LogUtil.getPackageLogger(LoadKDStyleUtil.class);

    public static StyleAttributes passKDTextField(JComponent txa) throws Exception {
        StyleAttributes sa = (StyleAttributes)map.get(KDTextField.class);
        if (sa == null) {
            sa = LoadKDStyleUtil.createStyleAttributes(txa);
            map.put(KDTextArea.class, sa);
        }
        return Styles.getSA((StyleAttributes)sa);
    }

    public static StyleAttributes passKDTextArea(JComponent txa) throws Exception {
        StyleAttributes sa = (StyleAttributes)map.get(KDTextArea.class);
        if (sa == null) {
            sa = LoadKDStyleUtil.createStyleAttributes(txa);
            sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
            map.put(KDTextArea.class, sa);
        }
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
        return Styles.getSA((StyleAttributes)sa);
    }

    public static StyleAttributes passKDSeparator(JComponent txa) throws Exception {
        StyleAttributes sa = (StyleAttributes)map.get(KDSeparator.class);
        if (sa == null) {
            sa = LoadKDStyleUtil.createStyleAttributes(txa);
            map.put(KDSeparator.class, sa);
        }
        return Styles.getSA((StyleAttributes)sa);
    }

    public static StyleAttributes passKDLabel(JComponent txa) throws Exception {
        StyleAttributes sa = (StyleAttributes)map.get(KDLabel.class);
        if (sa == null) {
            sa = LoadKDStyleUtil.createStyleAttributes(txa);
            map.put(KDTextArea.class, sa);
        }
        return Styles.getSA((StyleAttributes)sa);
    }

    public static StyleAttributes passKDTree() throws Exception {
        StyleAttributes sa = (StyleAttributes)map.get(KDTree.class);
        if (sa == null) {
            KDTree tree = new KDTree();
            sa = Styles.getDefaultSA();
            sa.setFont(tree.getFont());
            sa.setBackground(tree.getBackground());
            sa.setFontColor(tree.getForeground());
            map.put(KDTree.class, sa);
        }
        return sa;
    }

    public static Styles.HorizontalAlignment ConversToGM(JLabel label) {
        if (Integer.parseInt(Styles.HorizontalAlignment.NORMAL.toString()) == label.getHorizontalAlignment()) {
            return Styles.HorizontalAlignment.NORMAL;
        }
        if (Integer.parseInt(Styles.HorizontalAlignment.LEFT.toString()) == label.getHorizontalAlignment()) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (Integer.parseInt(Styles.HorizontalAlignment.RIGHT.toString()) == label.getHorizontalAlignment()) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        if (Integer.parseInt(Styles.HorizontalAlignment.CENTER.toString()) == label.getHorizontalAlignment()) {
            return Styles.HorizontalAlignment.CENTER;
        }
        return Styles.HorizontalAlignment.LEFT;
    }

    private static StyleAttributes createStyleAttributes(JComponent comp) {
        StyleAttributes sa = Styles.getDefaultSA();
        LoadKDStyleUtil.passUtil(comp, sa);
        return sa;
    }

    private static void passUtil(JComponent comp, StyleAttributes sa) {
        if (comp instanceof JLabel) {
            LoadKDStyleUtil.passLabel((JLabel)comp, sa);
        } else if (comp instanceof KDTextField) {
            LoadKDStyleUtil.passCommon((JTextField)comp, sa);
        } else {
            LoadKDStyleUtil.passCommon(comp, sa);
        }
    }

    private static void passCommon(JComponent comp, StyleAttributes sa) {
        Font font = comp.getFont();
        if (font != null) {
            sa.setFont(font);
        }
        sa.setBackground(comp.getBackground());
        sa.setFontColor(comp.getForeground());
    }

    private static void passLabel(JLabel label, StyleAttributes sa) {
        sa.setFont(label.getFont());
    }

    private static void passTextField(JTextField textfield, StyleAttributes sa) {
    }

    public static void tableStyleFromCtrl(AbstractRow row, boolean isHead) {
        if (isHead) {
            KDTable kdt = new KDTable();
            kdt.addHeadRow();
            IRow kdtableHead = kdt.getHeadRow(0);
            row.setStyleAttribute(Styles.getSA((StyleAttributes)kdtableHead.getStyleAttributes()));
            row.setHeightLom(Util.pixel2Lom(kdtableHead.getHeight()));
        } else {
            KDTable kdt = new KDTable();
            kdt.addRow();
            IRow kdtableRow = kdt.getRow(0);
            row.setStyleAttribute(Styles.getSA((StyleAttributes)kdtableRow.getStyleAttributes()));
            row.setHeightLom(Util.pixel2Lom(kdtableRow.getHeight()));
        }
    }
}

