/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.form.view;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.billlist.BillListCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.billlist.BillListGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1TableModel_st;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;

public class R1FBillListView
extends ASwingView {
    private BillListGrid billListGrid;
    private String[] columnNames = null;

    public R1FBillListView() {
        super((JComponent)new KDTable());
    }

    @Override
    protected JComponent init(JComponent c) {
        return c;
    }

    public KDTable getMainView() {
        return (KDTable)this.getComponent();
    }

    @Override
    protected void update(MvcEvent mvc) {
        R1TableModel_st model = (R1TableModel_st)mvc.getSource();
        KDTable table = this.getMainView();
        table.checkParsed();
        table.getDataRequestManager().setDataRequestMode(1);
        table.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)new MyDataRequestListener(model));
        table.setEditable(false);
        table.addColumns(this.billListGrid.getColumnsCount());
        int headCount = this.billListGrid.getHeadRowCount();
        HashSet<MergeBlock> mbs = new HashSet<MergeBlock>();
        for (int i = 0; i < headCount; ++i) {
            AbstractRow row = this.billListGrid.getRow(i);
            IRow tableRow = table.addHeadRow();
            for (int j = 0; j < row.getCellCount(); ++j) {
                MergeBlock mb;
                BillListCell cell = (BillListCell)row.getCell(j);
                ICellValue cellValue = cell.getValue();
                if (cellValue instanceof Text) {
                    tableRow.getCell(j).setValue((Object)((Text)cellValue).getText());
                }
                if ((mb = row.getCell(j).getMergeBlock()) == null || mbs.contains(mb)) continue;
                table.getHeadMergeManager().mergeBlock(mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight());
                mbs.add(mb);
            }
        }
        table.refresh();
    }

    private String[] getColumnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        int headRowCount = this.billListGrid.getHeadRowCount();
        AbstractRow dataRow = this.billListGrid.getRow(headRowCount);
        int colCount = dataRow.getCellCount();
        String[] columnNames = new String[colCount];
        for (int i = 0; i < colCount; ++i) {
            BillListCell cell = (BillListCell)dataRow.getCell(i);
            ICellValue cellValue = cell.getValue();
            if (!(cellValue instanceof CellField)) continue;
            columnNames[i] = ((CellField)cellValue).getName();
        }
        return columnNames;
    }

    public BillListGrid getBillListGrid() {
        return this.billListGrid;
    }

    public void setBillListGrid(BillListGrid billListGrid) {
        this.billListGrid = billListGrid;
    }

    @Override
    public void setModel(AModel model) {
        if (model instanceof R1TableModel_st) {
            ((R1TableModel_st)model).setRowsModel(false);
        }
        super.setModel(model);
    }

    private class MyDataRequestListener
    implements KDTDataRequestListener {
        R1TableModel_st model;

        public MyDataRequestListener(R1TableModel_st model) {
            this.model = model;
        }

        public void tableDataRequest(KDTDataRequestEvent e) {
            KDTable table = R1FBillListView.this.getMainView();
            try {
                int from = e.getFirstRow();
                int len = e.getLastRow() - from + 1;
                boolean first = from == 0;
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                if (first) {
                    params.put("columnNames", R1FBillListView.this.getColumnNames());
                    params.put("mode", "billList");
                }
                RptParams rptParams = this.model.executeQuery(first, from, len, params);
                if (first) {
                    int rowCount = rptParams.getInt("rowCount");
                    table.setRowCount(rowCount);
                    if (rowCount == 0) {
                        return;
                    }
                }
                RptRowSet rs = (RptRowSet)rptParams.getObject("rowset");
                KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)table);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }
}

