/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AutoGrowGrid;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class MergingGrid
extends AutoGrowGrid {
    public void merge(int rowIdx, int colIdx, int rowSpan, int colSpan) {
        MergeInfo mi = new MergeInfo();
        mi.rowIndex = rowIdx;
        mi.colIndex = colIdx;
        mi.rowSpan = rowSpan;
        mi.colSpan = colSpan;
        mi.cell = super.getCell(rowIdx, colIdx);
        int rowEnd = rowIdx + rowSpan;
        int colEnd = colIdx + colSpan;
        for (int i = rowIdx; i < rowEnd; ++i) {
            for (int j = colIdx; j < colEnd; ++j) {
                super.setCell(i, j, mi);
            }
        }
    }

    public void split(int rowIdx, int colIdx) {
        Object cell = super.getCell(rowIdx, colIdx);
        if (cell instanceof MergeInfo) {
            MergeInfo mi = (MergeInfo)cell;
            int rowEnd = rowIdx + mi.rowSpan;
            int colEnd = colIdx + mi.colSpan;
            for (int i = rowIdx; i < rowEnd; ++i) {
                for (int j = colIdx; j < colEnd; ++j) {
                    super.setCell(i, j, null);
                }
            }
            super.setCell(rowIdx, colIdx, mi.cell);
        }
    }

    public MergeInfo getMergeInfo(int rowIdx, int colIdx) {
        Object obj = super.getCell(rowIdx, colIdx);
        if (obj instanceof MergeInfo) {
            return (MergeInfo)obj;
        }
        return null;
    }

    private Object parseCell(Object obj) {
        if (obj instanceof MergeInfo) {
            return ((MergeInfo)obj).cell;
        }
        return obj;
    }

    @Override
    public Object getSureCell(int rowIdx, int colIdx) {
        return this.parseCell(super.getSureCell(rowIdx, colIdx));
    }

    @Override
    public Object getCell(int rowIdx, int colIdx) {
        return this.parseCell(super.getCell(rowIdx, colIdx));
    }

    @Override
    public void setCell(int rowIdx, int colIdx, Object cell) {
        Object obj;
        if (rowIdx < this.getRowCount() && (obj = super.getCell(rowIdx, colIdx)) instanceof MergeInfo) {
            ((MergeInfo)obj).cell = cell;
            return;
        }
        super.setCell(rowIdx, colIdx, cell);
    }

    public MergingCellsIterator iterateMergingCells() {
        return new MergingCellsIterator();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        sb.append("MERGING-GRID: ");
        sb.append(rowCount);
        sb.append("rows, ");
        sb.append(colCount);
        sb.append("cols\r\n");
        sb.append("COLUMNS: \t");
        for (int j = 0; j < colCount; ++j) {
            sb.append("[");
            sb.append(j);
            sb.append("]=");
            Object col = this.getCol(j);
            if (col != null) {
                sb.append(col);
            } else {
                sb.append("_");
                sb.append(j);
                sb.append("_");
            }
            sb.append("\t");
        }
        sb.append("\r\n");
        for (int i = 0; i < rowCount; ++i) {
            sb.append("[");
            sb.append(i);
            sb.append("]=");
            sb.append(this.getRow(i));
            sb.append(":");
            for (int j = 0; j < colCount; ++j) {
                sb.append("\t|");
                sb.append(j);
                sb.append("| ");
                MergeInfo mi = this.getMergeInfo(i, j);
                if (mi != null) {
                    if (mi.getRowIndex() == i && mi.getColIndex() == j) {
                        sb.append(mi);
                        continue;
                    }
                    sb.append("{-}");
                    if (mi.getCell() == null) continue;
                    sb.append(mi.getCell());
                    continue;
                }
                Object cell = this.getCell(i, j);
                if (cell == null) continue;
                sb.append(cell);
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public class MergingCellsIterator
    extends AutoGrowGrid.CellsIterator {
        private MergeInfo mi = null;
        private NextMergingCells ctx;

        MergingCellsIterator() {
            this.ctx = new NextMergingCells();
            this.ctx.next();
        }

        @Override
        public boolean hasNext() {
            return this.ctx.rowIdx < MergingGrid.this.getRowCount();
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object obj = this.ctx.cell;
            this.rowIdx = this.ctx.rowIdx;
            this.colIdx = this.ctx.colIdx;
            this.mi = this.ctx.mi;
            this.ctx.next();
            return obj;
        }

        public final MergeInfo getMergeInfo() {
            return this.mi;
        }
    }

    private class NextMergingCells {
        int rowIdx = 0;
        int colIdx = -1;
        MergeInfo mi = null;
        Object cell;

        private NextMergingCells() {
        }

        boolean next() {
            Object obj;
            block10: {
                do {
                    if (this.mi != null) {
                        if (this.mi.colSpan < MergingGrid.this.getColCount()) {
                            this.colIdx += this.mi.colSpan;
                            if (this.colIdx == MergingGrid.this.getColCount()) {
                                ++this.rowIdx;
                                this.colIdx = 0;
                            }
                        } else {
                            this.rowIdx += this.mi.rowSpan;
                            this.colIdx = 0;
                        }
                        this.mi = null;
                    } else {
                        ++this.colIdx;
                        if (this.colIdx == MergingGrid.this.getColCount()) {
                            ++this.rowIdx;
                            this.colIdx = 0;
                        }
                    }
                    if (this.rowIdx == MergingGrid.this.getRowCount()) {
                        return false;
                    }
                    try {
                        obj = MergingGrid.super.getCell(this.rowIdx, this.colIdx);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                    if (!(obj instanceof MergeInfo)) break block10;
                    this.mi = (MergeInfo)obj;
                } while (this.mi.rowIndex != this.rowIdx || this.mi.colIndex != this.colIdx);
                this.cell = this.mi.cell;
                return true;
            }
            this.cell = obj;
            return true;
        }
    }

    public static final class MergeInfo {
        int rowIndex;
        int colIndex;
        int rowSpan;
        int colSpan;
        Object cell;

        MergeInfo() {
        }

        public final Object getCell() {
            return this.cell;
        }

        public final int getColIndex() {
            return this.colIndex;
        }

        public final int getColSpan() {
            return this.colSpan;
        }

        public final int getRowIndex() {
            return this.rowIndex;
        }

        public final int getRowSpan() {
            return this.rowSpan;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append(this.rowIndex);
            sb.append(",");
            sb.append(this.colIndex);
            sb.append("-");
            sb.append(this.rowSpan);
            sb.append("x");
            sb.append(this.colSpan);
            sb.append("}");
            if (this.cell != null) {
                sb.append(this.cell);
            }
            return sb.toString();
        }
    }
}

